/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.util;

import blanco.cg.BlancoCgSupportedLang;
import blanco.commons.util.BlancoStringUtil;

/**
 * blancoCg̃Xe[ggɊւ郆[eBeBłB
 * 
 * ̃NX̓vO~O𒴂ėp܂B
 * 
 * @author IGA Tosiki
 */
class BlancoCgStatementUtil {
    /**
     * if̊Jn\擾܂B
     * 
     * ubNJn\iJavȁꍇAʁj܂݂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argExpr
     *            B
     * @return if̊Jn\B
     */
    public static final String getIfBegin(final int argTargetLang,
            final String argExpr) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "if (" + argExpr + ") {";
        case BlancoCgSupportedLang.VB:
            return "If (" + argExpr + ") Then";
        case BlancoCgSupportedLang.RUBY:
            return "if " + argExpr;
        case BlancoCgSupportedLang.PYTHON:
            return "if " + argExpr + ":";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * if̏I\擾܂B
     * 
     * Pythonł́Aif̏I͕@IɕKv܂񂪁A
     * ꂽ\[XR[h𐮌`邽߂ɁARg
     * ߂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return if̏I\B
     */
    public static final String getIfEnd(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "}";
        case BlancoCgSupportedLang.VB:
            return "End If";
        case BlancoCgSupportedLang.RUBY:
            return "end";
        case BlancoCgSupportedLang.PYTHON:
            return "#end";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * for̊Jn\擾܂B
     * 
     * Java, C#, JavaScript, PHPɑΉĂ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argExpr1
     *            B
     * @param argExpr2
     *            pB
     * @param argExpr3
     *            [v̂ǎ{鏈B
     * @return for̊Jn\B
     */
    public static final String getForBeginJava(final int argTargetLang,
            final String argExpr1, final String argExpr2, final String argExpr3) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "for (" + argExpr1 + "; " + argExpr2 + "; " + argExpr3
                    + ") {";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil.getForBeginJava: T|[gȂvO~O("
                            + argTargetLang + ")^܂B");
        }
    }

    /**
     * for̊Jn\擾܂B
     * 
     * VB.NETɑΉĂ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argCounter
     *            [vJE^Bu: i As Integer = 1v
     * @param argTo
     *            IƂȂ邵l (ł͂܂)Bu: 10v
     * @param argStep
     *            StepɗplBu: 2vBnull̏ꍇɂ Step͏ȗ܂B
     * @return for̊Jn\B
     */
    public static final String getForBeginVb(final int argTargetLang,
            final String argCounter, final String argTo, final String argStep) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.VB:
            break;
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil.getForBeginVb: T|[gȂvO~O("
                            + argTargetLang + ")^܂B");
        }

        String argLine = "For " + argCounter + " To " + argTo;
        if (BlancoStringUtil.null2Blank(argStep).length() > 0) {
            argLine += " Step " + argStep;
        }

        return argLine;
    }

    /**
     * 
     * for̊Jn\擾܂B
     * 
     * RubyɑΉĂ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argCounter
     *            [vJE^B
     * @param argFrom
     *            Jnl (ł͂܂)Bu: 1v
     * @param argTo
     *            Il (ł͂܂)Bu: 10v
     * @return for̊Jn\B
     */
    public static String getForBeginRuby(int argTargetLang, String argCounter,
            String argFrom, String argTo) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.RUBY:
            break;
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil.getForBeginRuby: T|[gȂvO~O("
                            + argTargetLang + ")^܂B");
        }

        String argLine = "for " + argCounter + " in " + argFrom + ".." + argTo;

        return argLine;
    }

    /**
     * 
     * for̊Jn\擾܂B
     * 
     * PythonɑΉĂ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argItem
     *            [vΏۂƂȂIuWFNǧݒlB
     * @param argItems
     *            [vΏۂƂȂIuWFNgB
     * @return for̊Jn\B
     */
    public static String getForBeginPython(int argTargetLang, String argItem,
            String argItems) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            break;
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil.getForBeginRuby: T|[gȂvO~O("
                            + argTargetLang + ")^܂B");
        }

        String argLine = "for " + argItem + " in " + argItems + ":";

        return argLine;
    }

    /**
     * foȑI\擾܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return foȑI\B
     */
    public static final String getForEnd(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "}";
        case BlancoCgSupportedLang.VB:
            // [vϐ͏ȗ܂B
            return "Next";
        case BlancoCgSupportedLang.RUBY:
            return "end";
        case BlancoCgSupportedLang.PYTHON:
            return "#end";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * for𔲂镶\킷擾܂B
     * 
     * ̏I(JavȁꍇAZ~R)͊܂݂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return for𔲂镶\킷B
     */
    public static final String getForExit(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            return "break";
        case BlancoCgSupportedLang.VB:
            return "Exit For";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * while̊Jn\킷擾܂B
     * 
     * Ruby, PythonɑΉĂ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argCon
     *            B
     * @return while̊Jn\킷B
     */
    public static String getWhileBeginRuby(int argTargetLang, String argCon) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.RUBY:
            return "while " + argCon;
        case BlancoCgSupportedLang.PYTHON:
            return "while " + argCon + ":";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil.getWhileBeginRuby: T|[gȂvO~O("
                            + argTargetLang + ")^܂B");
        }
    }

    /**
     * whilȅI\擾܂B
     * 
     * Ruby, PythonɑΉĂ܂B
     * Pythonł́AwhilȅI͕@IɕKv܂񂪁A
     * ꂽ\[XR[h𐮌`邽߂ɁARg
     * ߂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return whilȅI\B
     */
    public static final String getWhileEnd(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.RUBY:
            return "end";
        case BlancoCgSupportedLang.PYTHON:
            return "#end";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * eachubN̊Jn\擾܂B
     * 
     * RubyɑΉĂ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argObject
     *            each\bhĂяoΏۂƂȂIuWFNgB
     * @param argVariable
     *            each\bȟݒlB
     * @return eachubN̊Jn\B
     */
    public static String getEachBeginRuby(int argTargetLang, String argObject,
            String argVariable) {
        // argArray.each do |arg|
        switch (argTargetLang) {
        case BlancoCgSupportedLang.RUBY:
            return argObject + ".each do |" + argVariable + "|";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * eachubN̏I\擾܂B
     * 
     * RubyɑΉĂ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return eachubN̏I\B
     */
    public static final String getEachEnd(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.RUBY:
            return "end";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }
    
    /**
     * ̏I擾܂B
     * 
     * JavaȂǑ̌ł́AZ~R߂܂B
     * RubyȂǕ̏IKvȂł́A0̕
     * ߂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return ̏IB
     */
    public static final String getTerminator(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return ";";
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            return "";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * return\擾܂B
     * 
     * ̏I(JavȁꍇAZ~R)͊܂݂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argExpr
     *            return鎮B
     * @return return\B
     */
    public static final String getReturn(final int argTargetLang,
            final String argExpr) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            // ӁBZ~R͊܂݂܂B
            return "return " + argExpr;
        case BlancoCgSupportedLang.VB:
            // [vϐ͏ȗ܂B
            return "Return " + argExpr;
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

}