/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.message;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.message.message.BlancoMessageMessage;
import blanco.message.resourcebundle.BlancoMessageResourceBundle;
import blanco.message.valueobject.BlancoMessageFieldStructure;
import blanco.message.valueobject.BlancoMessageStructure;
import blanco.resourcebundle.BlancoResourceBundleUtil;
import blanco.resourcebundle.BlancoResourceBundleXml2JavaClass;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleResourceStringStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;

/**
 * ubZ[W`vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMessageXml2SourceFile {
    private final BlancoMessageMessage fMsg = new BlancoMessageMessage();

    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoMessageResourceBundle fBundle = new BlancoMessageResourceBundle();

    /**
     * o͑ΏۂƂȂvO~OB
     */
    private int fTargetLang = BlancoCgSupportedLang.NOT_DEFINED;

    /**
     * 萔ƂăNXɏo͂邩ǂB
     */
    private boolean fIsGenerateConstants = false;

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @param argIsGenerateConstants
     *            萔NXɏo͂邩ǂ̃tOB
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argTargetLang, final boolean argIsGenerateConstants,
            final File argDirectoryTarget) throws IOException {

        fTargetLang = new BlancoCgSupportedLang().convertToInt(argTargetLang);
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            break;
        default:
            throw new IllegalArgumentException(fMsg.getMbmsgi02(argTargetLang));
        }

        fIsGenerateConstants = argIsGenerateConstants;

        final BlancoMessageStructure[] structures = new BlancoMessageXmlParser()
                .parse(argMetaXmlSourceFile);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Source(structures[index], argDirectoryTarget);

            if (fTargetLang == BlancoCgSupportedLang.JAVA) {
                expandResourceBundleForJava(structures[index],
                        argDirectoryTarget);
            }
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param argStructure
     *            ^XN̍\B
     * @param argDirectoryTarget
     *            o͐fBNg
     */
    public void structure2Source(final BlancoMessageStructure argStructure,
            final File argDirectoryTarget) {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argStructure.getPackage(),
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(argStructure.getName()
                + BlancoStringUtil.null2Blank(argStructure.getSuffix()),
                BlancoStringUtil.null2Blank(argStructure.getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        if (fTargetLang == BlancoCgSupportedLang.JAVA) {
            // Javȁꍇɂ̓\[Xoh𗘗pB
            final BlancoCgField field = new BlancoCgField();
            field.setName("fBundle");
            field.setType(fCgFactory.createType(argStructure.getPackage() + "."
                    + BlancoNameAdjuster.toClassName(argStructure.getName())
                    + argStructure.getSuffix() + "ResourceBundle"));
            field.setDescription("bZ[WvpeBt@CΉ邽߂̓Iɗp郊\[XohNXB");
            field.setDefault("new "
                    + BlancoNameAdjuster.toClassName(argStructure.getName())
                    + argStructure.getSuffix() + "ResourceBundle()");
            field.setFinal(true);
            field.setAccess("protected");
            fCgClass.getFieldList().add(field);
        }

        if (fIsGenerateConstants) {
            expandFieldMessage(argStructure);
        }

        expandMethodGetMessage(argStructure);

        BlancoCgTransformerFactory.getSourceTransformer(fTargetLang).transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * 萔tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandFieldMessage(
            final BlancoMessageStructure argProcessStructure) {

        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoMessageFieldStructure fieldLook = (BlancoMessageFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);

            final String fieldName = fieldLook.getName().toUpperCase();

            // ubZ[Wɒu񂪂ꍇɂ͒萔tB[h͐ȂvƂdl邩ǂ̃tOւ̑ΉB
            if ("true".equals(fBundle
                    .getXml2sourceFileNoGenerateConstantIfFormatElementExist())) {
                final List listSplitMessage = new ArrayList();
                listSplitMessage.add(fieldLook.getMessage());
                final int maxReplaceNumber = new BlancoMessageSplitUtil()
                        .split(listSplitMessage);
                if (maxReplaceNumber >= 0) {
                    // u񂪑݂̂Œ萔tB[h͐܂B
                    continue;
                }
            }

            final BlancoCgField cgField = fCgFactory.createField(fieldName,
                    getTypeString(), "["
                            + BlancoCgSourceUtil.escapeStringAsLangDoc(
                                    fTargetLang, fieldLook.getMessage()) + "]");
            fCgClass.getFieldList().add(cgField);
            cgField.setAccess("public");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault(BlancoCgLineUtil
                    .getStringLiteralEnclosure(fTargetLang)
                    + BlancoCgSourceUtil.escapeStringAsSource(fTargetLang,
                            (argProcessStructure.getIdEmbedding() ? "["
                                    + fieldLook.getName() + "] " : "")
                                    + fieldLook.getMessage())
                    + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang));

            if (fieldLook.getNo() != null) {
                cgField.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
        }
    }

    /**
     * getbZ[W \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodGetMessage(
            final BlancoMessageStructure argProcessStructure) {

        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoMessageFieldStructure fieldLook = (BlancoMessageFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);

            final List listSplitMessage = new ArrayList();
            listSplitMessage.add((argProcessStructure.getIdEmbedding() ? "["
                    + fieldLook.getName() + "] " : "")
                    + fieldLook.getMessage());
            final int maxReplaceNumber = new BlancoMessageSplitUtil()
                    .split(listSplitMessage);

            final int blancoResourceBundleFormatCount = BlancoResourceBundleUtil
                    .getFormatsByArgumentIndex(fieldLook.getMessage(), false).length;

            if (maxReplaceNumber + 1 != blancoResourceBundleFormatCount) {
                throw new IllegalArgumentException(fMsg.getMbmsgi04(
                        argProcessStructure.getName(), fieldLook.getName(),
                        Integer.toString(maxReplaceNumber + 1), Integer
                                .toString(blancoResourceBundleFormatCount)));
            }

            switch (fTargetLang) {
            case BlancoCgSupportedLang.RUBY:
            case BlancoCgSupportedLang.PYTHON:
                new BlancoMessageSplitUtil()
                        .splitByNewLineChar(listSplitMessage);
                break;
            }
            final String methodName = "get"
                    + BlancoNameAdjuster.toClassName(fieldLook.getName());

            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    getMethodName(methodName), "bZ[W`ID["
                            + argProcessStructure.getName() + "]AL[["
                            + fieldLook.getName() + "]̕擾܂B");
            fCgClass.getMethodList().add(cgMethod);

            // System.out.println("u:" + maxReplaceNumber);
            for (int indexArg = 0; indexArg <= maxReplaceNumber; indexArg++) {
                cgMethod.getParameterList().add(
                        fCgFactory.createParameter("arg" + indexArg,
                                getTypeString(), "u{" + indexArg + "}̒lB",
                                true));
            }

            if (fieldLook.getNo() != null) {
                cgMethod.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
            cgMethod.getLangDoc().getDescriptionList().add(
                    "["
                            + BlancoCgSourceUtil.escapeStringAsLangDoc(
                                    fTargetLang, fieldLook.getMessage()) + "]");

            cgMethod.setReturn(fCgFactory.createReturn(getTypeString(),
                    "bZ[WB"));

            final List lineList = cgMethod.getLineList();

            StringBuffer bufLine = new StringBuffer();

            switch (fTargetLang) {
            case BlancoCgSupportedLang.JAVA:
                if (true) {
                    final StringBuffer buf = new StringBuffer();
                    if (argProcessStructure.getIdEmbedding()) {
                        // IDߍ
                        buf.append(BlancoCgLineUtil
                                .getStringLiteralEnclosure(fTargetLang)
                                + "["
                                + fieldLook.getName()
                                + "] "
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " + ");
                    }
                    buf.append("fBundle.get"
                            + BlancoNameAdjuster.toClassName(fieldLook
                                    .getName()) + "(");
                    for (int indexArg = 0; indexArg <= maxReplaceNumber; indexArg++) {
                        if (indexArg != 0) {
                            buf.append(", ");
                        }
                        buf.append("arg" + indexArg);
                    }
                    buf.append(")");
                    bufLine.append(buf.toString());
                }
                break;
            case BlancoCgSupportedLang.RUBY:
            case BlancoCgSupportedLang.PYTHON:
                bufLine.append(getReturnStringRuby(listSplitMessage));
                break;
            default:
                bufLine.append(getReturnString(listSplitMessage));
                break;
            }

            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, bufLine
                    .toString())
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
        }
    }

    /**
     * vO~Oꏈnɍ String ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeString() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "java.lang.String";
        case BlancoCgSupportedLang.CS:
            return "string";
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "string";
        case BlancoCgSupportedLang.VB:
            return "String";
        }
    }

    /**
     * vO~Oꏈnɍ \bh̖Oό`Ȃ܂B
     * 
     * \bh̓ǂݑւB
     * 
     * @return
     */
    private final String getMethodName(final String argMethodName) {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return argMethodName;
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.VB:
            return BlancoNameAdjuster.toUpperCaseTitle(argMethodName);
        case BlancoCgSupportedLang.JS:
            return argMethodName;
        }
    }

    /**
     * 
     * bZ[W𐶐鎮擾
     * 
     * @param listSplitMessage
     *            ߍݕŕꂽbZ[W̃Xg
     * @return
     */
    private StringBuffer getReturnString(final List listSplitMessage) {
        StringBuffer bufLine = new StringBuffer();
        boolean isPastString = false;
        for (int index = 0; index < listSplitMessage.size(); index++) {
            final Object objLook = listSplitMessage.get(index);
            if (objLook instanceof Integer) {
                // uB
                final Integer intLook = (Integer) objLook;
                if (isPastString) {
                    bufLine.append(BlancoCgLineUtil
                            .getStringLiteralEnclosure(fTargetLang));
                }
                isPastString = false;
                if (index != 0) {
                    bufLine
                            .append(" "
                                    + BlancoCgLineUtil
                                            .getStringConcatenationOperator(fTargetLang)
                                    + " ");
                }
                if (fTargetLang == BlancoCgSupportedLang.PHP) {
                    bufLine.append("$");
                }
                bufLine.append("arg" + intLook.intValue());
            } else {
                if (isPastString == false) {
                    if (index != 0) {
                        bufLine
                                .append(" "
                                        + BlancoCgLineUtil
                                                .getStringConcatenationOperator(fTargetLang)
                                        + " ");
                    }
                    bufLine.append(BlancoCgLineUtil
                            .getStringLiteralEnclosure(fTargetLang));
                }
                isPastString = true;

                final String strLook = (String) objLook;
                bufLine.append(BlancoCgSourceUtil.escapeStringAsSource(
                        fTargetLang, strLook));
            }
        }

        if (isPastString) {
            bufLine.append(BlancoCgLineUtil
                    .getStringLiteralEnclosure(fTargetLang));
        }

        return bufLine;
    }

    /**
     * 
     * RubyɂāAbZ[W𐶐鎮擾
     * 
     * sʂ̕񃊃eƂĎ舵ꍇ gp܂B
     * 
     * @param listSplitMessage
     *            ߍݕŕꂽbZ[W̃Xg
     * @return
     */
    private StringBuffer getReturnStringRuby(final List listSplitMessage) {
        StringBuffer bufLine = new StringBuffer();
        for (int index = 0; index < listSplitMessage.size(); index++) {
            final Object objLook = listSplitMessage.get(index);
            if (index != 0) {
                bufLine.append(" "
                        + BlancoCgLineUtil
                                .getStringConcatenationOperator(fTargetLang)
                        + " ");
            }
            if (objLook instanceof Integer) {
                // ȕꍇB
                final Integer intLook = (Integer) objLook;

                if (fTargetLang == BlancoCgSupportedLang.PHP) {
                    bufLine.append("$");
                }
                bufLine.append("arg" + intLook.intValue());
            } else {
                // 񃊃ȅꍇB
                final String strLook = (String) objLook;

                // ŝ݂̏ꍇA񃊃e\"ň݂͂܂
                StringBuffer literalEnclosure = new StringBuffer();
                if ("\n".equals(strLook)) {
                    literalEnclosure.append("\"");
                } else {
                    literalEnclosure.append(BlancoCgLineUtil
                            .getStringLiteralEnclosure(fTargetLang));
                }

                bufLine.append(literalEnclosure);
                bufLine.append(BlancoCgSourceUtil.escapeStringAsSource(
                        fTargetLang, strLook));
                bufLine.append(literalEnclosure);
            }
        }

        return bufLine;
    }

    /**
     * JavȁꍇɃ\[XohNX𐶐܂B
     * 
     * @param argStructure
     * @param argDirectoryTarget
     */
    private void expandResourceBundleForJava(
            final BlancoMessageStructure argStructure,
            final File argDirectoryTarget) {
        final BlancoResourceBundleBundleStructure bundleStructure = new BlancoResourceBundleBundleStructure();
        bundleStructure.setName(BlancoNameAdjuster.toClassName(argStructure
                .getName())
                + argStructure.getSuffix());
        bundleStructure.setPackage(argStructure.getPackage());
        // NXpbP[WANZXɐ܂B
        bundleStructure.setAccess("");
        bundleStructure.setSuffix("ResourceBundle");
        bundleStructure.setDescription("bZ[W`[" + argStructure.getName()
                + "]Iɗp郊\[XohNXB");

        // TODO ftHgP[𗘗p邱ƂɂĂ܂B
        final Locale defalutLocale = Locale.getDefault();

        for (int index = 0; index < argStructure.getFieldList().size(); index++) {
            final BlancoMessageFieldStructure fieldStructure = (BlancoMessageFieldStructure) argStructure
                    .getFieldList().get(index);
            final BlancoResourceBundleBundleItemStructure item = new BlancoResourceBundleBundleItemStructure();
            item.setKey(fieldStructure.getName());
            final BlancoResourceBundleBundleResourceStringStructure resourceString = new BlancoResourceBundleBundleResourceStringStructure();
            resourceString.setResourceString(BlancoStringUtil
                    .null2Blank(fieldStructure.getMessage()));
            resourceString.setLocale(defalutLocale.getLanguage());
            item.getResourceStringList().add(resourceString);
            bundleStructure.getItemList().add(item);
        }

        new BlancoResourceBundleXml2JavaClass().structure2Source(
                bundleStructure, argDirectoryTarget);
    }
}
