/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.charactergroup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.charactergroup.message.BlancoCharacterGroupMessage;
import blanco.charactergroup.valueobject.BlancoCharacterGroupFieldStructure;
import blanco.charactergroup.valueobject.BlancoCharacterGroupStructure;
import blanco.commons.util.BlancoStringUtil;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * blancoValueObject XMLt@C`p[X(ǂݏ)NXB
 * 
 * @author IGA Tosiki
 */
public class BlancoCharacterGroupXmlParser {
    /**
     * bZ[WB
     */
    private final BlancoCharacterGroupMessage fMsg = new BlancoCharacterGroupMessage();

    /**
     * XMLt@CXMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoCharacterGroupStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);

    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoCharacterGroupStructure[] parse(
            final BlancoXmlDocument argXmlDocument) {
        final ArrayList listStructure = new ArrayList();

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");

        for (int index = 0; index < listSheet.size(); index++) {
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            final BlancoCharacterGroupStructure objClassStructure = parseElementSheet(elementSheet);
            if (objClassStructure != null) {
                // ꂽL܂B
                listStructure.add(objClassStructure);
            }
        }

        final BlancoCharacterGroupStructure[] result = new BlancoCharacterGroupStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoCharacterGroupStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoCharacterGroupStructure classStructure = new BlancoCharacterGroupStructure();
        final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancocharactergroup-common");
        if (listCommon == null || listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                .get(0);
        classStructure.setName(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "name"));
        classStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "package"));
        classStructure.setDescription(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "description"));
        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "suffix") != null) {
            classStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "suffix"));
        }

        if (BlancoStringUtil.null2Blank(classStructure.getName()).length() == 0) {
            // Ô̓XLbv܂B
            return null;
        }

        if (classStructure.getPackage() == null) {
            throw new IllegalArgumentException(fMsg.getMbchgi01(classStructure
                    .getName()));
        }

        final List listList = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancocharactergroup-list");
        if (listList != null && listList.size() != 0) {
            final BlancoXmlElement elementListRoot = (BlancoXmlElement) listList
                    .get(0);
            final List listChildNodes = BlancoXmlBindingUtil
                    .getElementsByTagName(elementListRoot, "field");
            for (int index = 0; index < listChildNodes.size(); index++) {
                if (listChildNodes.get(index) instanceof BlancoXmlElement == false) {
                    continue;
                }

                final BlancoXmlElement elementList = (BlancoXmlElement) listChildNodes
                        .get(index);
                final BlancoCharacterGroupFieldStructure fieldStructure = new BlancoCharacterGroupFieldStructure();

                fieldStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                        elementList, "no"));
                fieldStructure.setValue(BlancoXmlBindingUtil.getTextContent(
                        elementList, "value"));
                fieldStructure.setDescription(BlancoXmlBindingUtil
                        .getTextContent(elementList, "description"));
                if (fieldStructure.getValue() == null) {
                    // value trimđݔ肵Ă͂Ȃ܂Bp󔒂 value ƂĂ蓾邩łB
                    continue;
                }

                // value̒`FbNB
                if (fieldStructure.getValue().length() > 1) {
                    throw new IllegalArgumentException(fMsg.getMbchgi04(
                            classStructure.getName(),
                            fieldStructure.getValue(),
                            String.valueOf(fieldStructure.getValue().length())));
                }

                // ɓeo^ĂȂǂ̃`FbNB
                for (int indexPast = 0; indexPast < classStructure
                        .getFieldList().size(); indexPast++) {
                    final BlancoCharacterGroupFieldStructure fieldPast = (BlancoCharacterGroupFieldStructure) classStructure
                            .getFieldList().get(indexPast);
                    if (fieldPast.getValue().equals(fieldStructure.getValue())) {
                        throw new IllegalArgumentException(fMsg.getMbchgi03(
                                classStructure.getName(), fieldStructure
                                        .getValue()));
                    }
                }

                classStructure.getFieldList().add(fieldStructure);
            }
        }

        return classStructure;
    }
}
