/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.stringgroup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.stringgroup.message.BlancoStringGroupMessage;
import blanco.stringgroup.valueobject.BlancoStringGroupFieldStructure;
import blanco.stringgroup.valueobject.BlancoStringGroupStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * ̃NX́AXMLt@C񒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoStringGroupXmlParser {
    /**
     * bZ[W`B
     */
    protected final BlancoStringGroupMessage fMsg = new BlancoStringGroupMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoStringGroupStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoStringGroupStructure[] parse(
            final BlancoXmlDocument argXmlDocument) {
        final ArrayList listStructure = new ArrayList();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            final BlancoStringGroupStructure structure = parseElementSheet(elementSheet);
            if (structure != null) {
                // ꂽL܂B
                listStructure.add(structure);
            }
        }

        final BlancoStringGroupStructure[] result = new BlancoStringGroupStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoStringGroupStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoStringGroupStructure structure = new BlancoStringGroupStructure();
        // ̓p[^擾܂B

        final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancostringgroup-common");
        if (listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        // ŏ̃ACêݏĂ܂B
        final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                .get(0);

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "name"));
        structure.setPackage(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "package"));

        if (BlancoStringUtil.null2Blank(structure.getName()).length() == 0) {
            return null;
        }

        if (BlancoStringUtil.null2Blank(structure.getPackage()).trim().length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbsgi001(structure
                    .getName()));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "description") != null) {
            structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "suffix") != null) {
            structure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "suffix"));
        }

        final BlancoXmlElement elementStringGroupList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancostringgroup-list");
        if (elementStringGroupList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                elementStringGroupList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);
            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;

            final BlancoStringGroupFieldStructure fieldStructure = new BlancoStringGroupFieldStructure();

            fieldStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "no"));
            fieldStructure.setValue(BlancoXmlBindingUtil.getTextContent(
                    elementField, "value"));
            if (fieldStructure.getValue() == null) {
                // valuew肳ĂȂꍇɂ͏܂B
                continue;
            }

            fieldStructure.setConstant(BlancoXmlBindingUtil.getTextContent(
                    elementField, "constant"));

            fieldStructure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementField, "description"));

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < structure.getFieldList().size(); indexPast++) {
                final BlancoStringGroupFieldStructure fieldPast = (BlancoStringGroupFieldStructure) structure
                        .getFieldList().get(indexPast);
                if (fieldPast.getValue().equals(fieldStructure.getValue())) {
                    throw new IllegalArgumentException(fMsg.getMbsgi003(
                            structure.getName(), fieldStructure.getValue()));
                }
            }

            structure.getFieldList().add(fieldStructure);
        }

        return structure;
    }
}
