/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtChapterStructure;
import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtStructure;

/**
 * u\[XeLXgvuHTMLt@Cvɕϊ܂B
 * 
 * ̑OɁASrcTxtւ̃C|[gWJ͏IĂKv肻łB
 */
public class BlancoTextConverterSrcTxtStructure2Html {
    public void structure2File(
            final BlancoTextConverterSrcTxtStructure argStructure,
            final BufferedWriter argWriter) throws IOException {
        argWriter
                .write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        argWriter.newLine();

        argWriter.write("<html lang=\"ja\">");
        argWriter.newLine();

        argWriter.write("<head>");
        argWriter.newLine();

        argWriter.write("  <title>");
        // TODO HTML̃GXP[vB
        argWriter.write(argStructure.getSubject());
        argWriter.write("</title>");
        argWriter.newLine();

        // TODO HTML̃GXP[vB
        argWriter.write("  <meta name=\"DESCRIPTION\" content=\""
                + argStructure.getDescription() + "\">");
        argWriter.newLine();

        // TODO HTML̃GXP[vB
        argWriter.write("  <meta name=\"KEYWORDS\" content=\""
                + argStructure.getKeywords() + "\">");
        argWriter.newLine();

        if (argStructure.getDate() != null) {
            final SimpleDateFormat sdFormat1 = new SimpleDateFormat(
                    "yyyy-MM-dd");
            final SimpleDateFormat sdFormat2 = new SimpleDateFormat(
                    "HH:mm:ss+09:00");

            final StringBuffer strDate = new StringBuffer();
            strDate.append(sdFormat1.format(argStructure.getDate()));

            if (sdFormat2.format(argStructure.getDate()).equals(
                    "00:00:00+09:00")) {
                // 00:00:00o͂}܂B
            } else {
                strDate.append("T" + sdFormat2.format(argStructure.getDate()));
            }

            argWriter.write("  <meta name=\"DATE\" content=\"" + strDate
                    + "\">");
            argWriter.newLine();
        }

        argWriter.write("  <meta name=\"GENERATOR\" content=\""
                + BlancoTextConverterConstants.PRODUCT_NAME + " ("
                + BlancoTextConverterConstants.VERSION + ")\">");
        argWriter.newLine();

        // TODO R[hǂ̂H
        argWriter
                .write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset="
                        + BlancoTextConverterConstants.HTML_ENCODING + "\">");
        argWriter.newLine();

        argWriter
                .write("  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\">");
        argWriter.newLine();

        argWriter.write("</head>");
        argWriter.newLine();

        argWriter.newLine();

        argWriter.write("<body bgcolor=\"#eeddcc\">");
        argWriter.newLine();

        for (int index = 0; index < argStructure.getLineList().size(); index++) {
            final Object objLine = argStructure.getLineList().get(index);
            if (objLine instanceof BlancoTextConverterSrcTxtChapterStructure) {
                final BlancoTextConverterSrcTxtChapterStructure chapter = (BlancoTextConverterSrcTxtChapterStructure) objLine;
                if (chapter.getLevel() == 0) {
                    argWriter.newLine();
                    argWriter.write("<table summary=\"mini title\">");
                    argWriter.newLine();
                    argWriter.write("<tbody>");
                    argWriter.newLine();
                    argWriter.write("  <tr>");
                    argWriter.newLine();
                    argWriter
                            .write("    <td bgcolor=\"#ff9900\" valign=\"top\"><font color=\"#ffffff\" size=\"+1\"><strong>"
                                    + BlancoJavaSourceUtil
                                            .escapeStringAsJavaDoc(chapter
                                                    .getLine())
                                    + "</strong></font></td>");
                    argWriter.newLine();
                    argWriter.write("  </tr>");
                    argWriter.newLine();
                    argWriter.write("</tbody>");
                    argWriter.newLine();
                    argWriter.write("</table>");
                    argWriter.newLine();
                } else {
                    // TODO xƂ̕\ύXB
                    if (chapter.getLevel() <= 2) {
                        argWriter.write("<font color=\"#ff00ff\">");
                    } else {
                        argWriter.write("<font color=\"#8844ff\">");
                    }
                    if (chapter.getLevel() == 1) {
                        argWriter.write("<strong>");
                    }
                    argWriter.write(BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc(chapter.getLine()));
                    if (chapter.getLevel() == 1) {
                        argWriter.write("</strong>");
                    }

                    argWriter.write("</font>");
                    argWriter.newLine();
                }
            } else {
                final String line = (String) objLine;
                // ʂ̍sB
                // TODO HTML̃GXP[vB
                argWriter.write("<p>");

                StringTokenizer token = new StringTokenizer(line, "\n");
                for (boolean isFirst = true; token.hasMoreTokens(); isFirst = false) {
                    if (isFirst == false) {
                        argWriter.newLine();
                    }
                    argWriter.write(token.nextToken());
                }

                argWriter.write("</p>");
                argWriter.newLine();
            }
        }

        argWriter.write("<hr>");
        argWriter.newLine();
        argWriter.write("<address>");
        argWriter.newLine();

        if (argStructure.getDate() != null) {
            final SimpleDateFormat sdFormat1 = new SimpleDateFormat(
                    "yyyy/MM/dd");
            final SimpleDateFormat sdFormat2 = new SimpleDateFormat("HH:mm:ss");
            final StringBuffer strDate = new StringBuffer();
            strDate.append(sdFormat1.format(argStructure.getDate()));
            if (sdFormat2.format(argStructure.getDate()).equals("00:00:00") == false) {
                strDate.append(" " + sdFormat2.format(argStructure.getDate()));
            }
            argWriter
                    .write("<a href=\"memo/memoigapyon.html\">҂ɂ</a><br>  Last modified: $Date: "
                            + strDate + " $");
        }

        argWriter.write("</address>");
        argWriter.newLine();

        argWriter.write("</body>");
        argWriter.newLine();

        argWriter.write("</html>");
        argWriter.newLine();
    }
}
