/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobjectdotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.valueobjectdotnet.message.BlancoValueObjectDotNetMessage;
import blanco.valueobjectdotnet.valueobject.BlancoValueObjectDotNetClassStructure;
import blanco.valueobjectdotnet.valueobject.BlancoValueObjectDotNetFieldStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * blancoValueObject XMLt@C`p[X(ǂݏ)NXB
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectDotNetXmlParser {
    /**
     * bZ[WB
     */
    private final BlancoValueObjectDotNetMessage fMsg = new BlancoValueObjectDotNetMessage();

    /**
     * XMLt@CXMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoValueObjectDotNetClassStructure[] parse(
            final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);

    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoValueObjectDotNetClassStructure[] parse(
            final BlancoXmlDocument argXmlDocument) {
        final ArrayList listStructure = new ArrayList();

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");

        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                    elementSheet, "blancovalueobjectdotnet-common");
            if (listCommon.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            // ŏ̃ACêݏĂ܂B
            final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                    .get(0);
            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                continue;
            }

            final BlancoValueObjectDotNetClassStructure objClassStructure = parseElementSheet(elementSheet);
            if (objClassStructure != null) {
                // ꂽL܂B
                listStructure.add(objClassStructure);
            }
        }

        final BlancoValueObjectDotNetClassStructure[] result = new BlancoValueObjectDotNetClassStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoValueObjectDotNetClassStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoValueObjectDotNetClassStructure objClassStructure = new BlancoValueObjectDotNetClassStructure();
        final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancovalueobjectdotnet-common");
        if (listCommon == null || listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }
        final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                .get(0);
        objClassStructure.setName(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "name"));
        objClassStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "package"));
        objClassStructure.setDescription(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "description"));
        objClassStructure.setFieldList(new ArrayList());

        if (BlancoStringUtil.null2Blank(objClassStructure.getName()).trim()
                .length() == 0) {
            // Ô̓XLbv܂B
            return null;
        }

        if (objClassStructure.getPackage() == null) {
            throw new IllegalArgumentException(fMsg
                    .getMbvoni01(objClassStructure.getName()));
        }

        final List listList = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancovalueobjectdotnet-list");
        if (listList != null && listList.size() != 0) {
            final BlancoXmlElement elementListRoot = (BlancoXmlElement) listList
                    .get(0);
            final List listChildNodes = BlancoXmlBindingUtil
                    .getElementsByTagName(elementListRoot, "field");
            for (int index = 0; index < listChildNodes.size(); index++) {
                if (listChildNodes.get(index) instanceof BlancoXmlElement == false) {
                    continue;
                }
                final BlancoXmlElement elementList = (BlancoXmlElement) listChildNodes
                        .get(index);
                final BlancoValueObjectDotNetFieldStructure fieldStructure = new BlancoValueObjectDotNetFieldStructure();

                fieldStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                        elementList, "no"));
                fieldStructure.setName(BlancoXmlBindingUtil.getTextContent(
                        elementList, "name"));
                if (fieldStructure.getName() == null
                        || fieldStructure.getName().trim().length() == 0) {
                    continue;
                }

                fieldStructure.setType(BlancoXmlBindingUtil.getTextContent(
                        elementList, "type"));
                fieldStructure.setDescription(BlancoXmlBindingUtil
                        .getTextContent(elementList, "description"));
                fieldStructure.setDefault(BlancoXmlBindingUtil.getTextContent(
                        elementList, "default"));
                fieldStructure.setMinLength(BlancoXmlBindingUtil
                        .getTextContent(elementList, "minLength"));
                fieldStructure.setMaxLength(BlancoXmlBindingUtil
                        .getTextContent(elementList, "maxLength"));
                fieldStructure.setLength(BlancoXmlBindingUtil.getTextContent(
                        elementList, "length"));
                fieldStructure.setMinInclusive(BlancoXmlBindingUtil
                        .getTextContent(elementList, "minInclusive"));
                fieldStructure.setMaxInclusive(BlancoXmlBindingUtil
                        .getTextContent(elementList, "maxInclusive"));
                fieldStructure.setPattern(BlancoXmlBindingUtil.getTextContent(
                        elementList, "pattern"));

                if (fieldStructure.getType() == null
                        || fieldStructure.getType().trim().length() == 0) {
                    throw new IllegalArgumentException(fMsg.getMbvoni02(
                            objClassStructure.getName(), fieldStructure
                                    .getName()));
                }

                objClassStructure.getFieldList().add(fieldStructure);
            }
        }

        return objClassStructure;
    }
}
