/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtStructure;

/**
 * u\[XeLXgvuHTMLt@Cvɕϊ܂B
 * 
 * ̑OɁASrcTxtւ̃C|[gWJ͏IĂKv肻łB
 */
public class BlancoTextConverterSrcTxt2Html {
    public void convert(final File inFile, final File outFile)
            throws IOException {
        convertInternal(inFile, outFile);
    }

    private void convertInternal(final File inFile, final File outFile)
            throws IOException {
        BlancoTextConverterSrcTxtStructure structure = null;
        {
            // t@C̓eǂݍ݁B
            byte[] wrk = readFile(inFile);

            // C|[gWJB
            // 1ڂ̃p[XłBł SubjectȂǂ̃wbhῗȂ܂B
            {
                final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                final BufferedReader reader = new BufferedReader(
                        new InputStreamReader(new ByteArrayInputStream(wrk)));
                final BufferedWriter writer = new BufferedWriter(
                        new OutputStreamWriter(outStream));
                final BlancoTextConverterSrcTxtPreCmdProcessor cmdParser = new BlancoTextConverterSrcTxtPreCmdProcessor();
                cmdParser
                        .addCommand(new BlancoTextConverterSrcTxtPreCmdInclude());
                cmdParser.execute(reader, writer);
                reader.close();
                writer.close();

                wrk = outStream.toByteArray();

                // TODO ωȂȂ܂ŁȀJԂKv܂B
            }

            // ㏈(?)
            // TODO RpXځASpXڂȂǂz肳܂B
            // 邢́A{̏ K؂ɕ򂩁H

            // p[Xč\̂ɕϊB
            {
                final BufferedReader reader = new BufferedReader(
                        new InputStreamReader(new ByteArrayInputStream(wrk)));
                structure = new BlancoTextConverterSrcTxtSrcTxt2Structure()
                        .parse(reader);
                reader.close();
            }
        }

        new BlancoTextConverterSrcTxtMergeParagraph().process(structure);

        {
            final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            final BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(outStream,
                            BlancoTextConverterConstants.HTML_ENCODING));
            // \̂̓et@Cɏ݁I
            new BlancoTextConverterSrcTxtStructure2Html().structure2File(
                    structure, writer);
            writer.close();

            final byte[] wrk = outStream.toByteArray();
            writeFile(wrk, inFile.lastModified(), outFile);
        }
    }

    private void writeFile(final byte[] outBytes, final long lastModified,
            final File outFile) throws IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader(
                    new ByteArrayInputStream(outBytes),
                    BlancoTextConverterConstants.HTML_ENCODING));
            writer = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(outFile),
                    BlancoTextConverterConstants.HTML_ENCODING));

            BlancoTextConverterSrcTxtUtil.copy(reader, writer);

            reader.close();
            reader = null;
            writer.close();
            writer = null;

            outFile.setLastModified(lastModified);
        } finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private byte[] readFile(final File inFile) throws IOException {
        final ByteArrayOutputStream outBytes = new ByteArrayOutputStream();

        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(inFile)));

            writer = new BufferedWriter(new OutputStreamWriter(outBytes));

            BlancoTextConverterSrcTxtUtil.copy(reader, writer);

            reader.close();
            reader = null;
            writer.close();
            writer = null;
        } finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }

        return outBytes.toByteArray();
    }
}
