/*
 * blanco Framework
 * Copyright(C) 2006-2008 NTT DATA BUSINESS BRAINS CORPORATION.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.soap.terasoluna.rich;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.transform.TransformerException;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.MethodExpander;
import blanco.wsdl.parser.BlancoWsdlParser;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

/**
 * WSDLrWlXWbÑC^tF[XNXB
 * 
 * ̃NX́AblancoSOAPTERASOLUNA RichΉg̈ꕔƂȂ܂B
 * 
 * @author IGA Tosiki
 * @version 1.0
 */
public class TerasolunaBLogicWsdl2BLogicInterface {

    /**
     * WSDLt@C̉͌
     */
    private BlancoWsdlWebService fWsdl = null;

    /**
     * d`ւ̃}bvB
     */
    private HashMap fMapTelegramProcessDef = null;

    /**
     * ̂̂WSDLt@CB
     * 
     * WSDLt@C͂Ƃ rWlXWbÑC^tF[XƂȂJava\[XR[h𐶐B
     * 
     * @param fileSource
     *            WSDLt@CB
     * @param mapTelegramProcessDef
     *            d`MAP
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNgB
     * @throws IOException
     *             o͗OꍇB
     * @throws TransformerException
     *             XMLϊOꍇB
     */
    public void process(final File fileSource,
            final HashMap mapTelegramProcessDef, final File directoryTarget)
            throws IOException, TransformerException {
        fWsdl = new BlancoWsdlParser().parse(fileSource);
        fMapTelegramProcessDef = mapTelegramProcessDef;

        // WSDL̂̂̂operationWJB
        final ArrayList listOperation = fWsdl.getOperationList();
        for (int indexOperation = 0; indexOperation < listOperation.size(); indexOperation++) {
            final BlancoWsdlWebServiceOperation operation = (BlancoWsdlWebServiceOperation) listOperation
                    .get(indexOperation);
            expandOperation(operation, directoryTarget);
        }
    }

    /**
     * WSDLoperation̋Lqɏ] rWlXWbÑC^tF[XWJB
     * 
     * @param operation
     *            WSDL̃Iy[V
     * @param directoryTarget
     *            Java\[XR[ho͐fBNgB
     * @throws IOException
     *             o͗OꍇB
     */
    private void expandOperation(final BlancoWsdlWebServiceOperation operation,
            final File directoryTarget) throws IOException {
        // d`̃}bvAd`̏o[IuWFNĝƏƂĎoB
        final BlancoWsdlWebServiceOperation telegramProcessDefInfo = TerasolunaBLogicUtil
                .getTelegramProcessorDef(operation.getName(),
                        fMapTelegramProcessDef);

        // NXWJ\zB
        final ClassExpander classExpander = new ClassExpander(new Type(fWsdl
                .getPackage(), BlancoNameAdjuster.toClassName(operation
                .getName())
                + "BLogic")) {
            public boolean isInterface() {
                // C^tF[X𐶐B
                return true;
            }

            protected void expandClassStruct() {
                addFileComment("TERASOLUNA RichprWlXWbÑC^tF[Xł<br>");
                addFileComment("̃NX blancoɂ莩Ă܂B");

                getJavaDoc().addLine(
                        "dID[" + operation.getName()
                                + "]̃rWlXWbNC^tF[XłB");
                getJavaDoc().addLine("");
                if (BlancoStringUtil.null2Blank(
                        telegramProcessDefInfo.getDescription()).length() > 0) {
                    // uv݂ꍇɂ̂ݏo͂܂B
                    getJavaDoc()
                            .addLine(
                                    ": "
                                            + BlancoJavaSourceUtil
                                                    .escapeStringAsJavaDoc(telegramProcessDefInfo
                                                            .getDescription())
                                            + "<br>");
                }
                getJavaDoc().addLine(
                        "̃C^tF[XāA["
                                + BlancoNameAdjuster.toClassName(operation
                                        .getName())
                                + "BLogicImpl]NX쐬ĂB<br>");
                getJavaDoc().addLine("̃C^tF[X́ADIRei痘p܂B<br>");
                getJavaDoc().addLine("");
                getJavaDoc().addLine(
                        "vdID: " + operation.getInput().getName() + "<br>");
                getJavaDoc().addLine(
                        "dID: " + operation.getOutput().getName() + "<br>");
                getJavaDoc().addLine("<br>");
                getJavaDoc().addLine("<br>");

                // bean`̋̓IȋLqe JavaDocɓWJB
                getJavaDoc().addLine("bean`̗̋LɎ܂B<br>");
                getJavaDoc().addLine("<pre>");
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("<bean id=\""
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogic\"")
                                + "<br>");
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("    class=\""
                                        + fWsdl.getPackage()
                                        + "."
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogicImpl\" singleton=\"false\">")
                                + "<br>");
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil.escapeStringAsJavaDoc("</bean>"));
                getJavaDoc().addLine("</pre>");

                // vdщd̃NXC|[gB
                addImport(new Type(operation.getInput().getTypeOfJava()));
                addImport(new Type(operation.getOutput().getTypeOfJava()));

                // execute\bhWJB
                addMethod(new MethodExpander("execute") {
                    protected boolean isAbstract() {
                        // ۃ\bhƂB
                        return true;
                    }

                    // \bh̃VOj`ZbgAbvB
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "dID[" + operation.getName()
                                        + "]̃rWlXWbNs܂B");
                        getJavaDoc().addLine("");
                        getJavaDoc().addLine("̃\bhpāA̓IȃrWlXWbNLq܂B");
                        getJavaDoc().addLine(
                                "̃\bh t[[NRg[oRČĂяo܂B");
                        getJavaDoc().addParameter(
                                "input",
                                "vdID[" + operation.getInput().getName()
                                        + "]");
                        getJavaDoc().addReturn(
                                "dID[" + operation.getOutput().getName()
                                        + "]");
                        addArgument(new Value(new Type(operation.getInput()
                                .getTypeOfJava()), "input"));
                        setReturnType(new Type(operation.getOutput()
                                .getTypeOfJava()));
                    }

                    public void implement() {
                        // ۃ\bhł邽ߖ{݂̂͑܂B
                    }
                });
            }
        };

        TerasolunaBLogicUtil.generateJavaSource(classExpander, directoryTarget);
    }
}
