/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.soap.actions;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.plugin.soap.resourcebundle.BlancoSOAPPluginResourceBundle;

/**
 * blancoSOAPANVg|CgۃNXB<br>
 * 
 * ̃NX́AblancoSOAPgĂяo߂̂^܂B<br>
 * ̃NXoRāAblancoSOAPvOCblancoSOAPg̊e@\ĂяoB
 * 
 * @author IGA Tosiki
 */
public abstract class AbstractActionExternalOption {
    private static final BlancoSOAPPluginResourceBundle bundle = new BlancoSOAPPluginResourceBundle();

    /**
     * OsIvV𗘗p邩ǂ
     * 
     * @return trueȂ痘pB falseȂ痘pȂB
     */
    public static boolean isUseExternalOption() {
        if (bundle.getExternalOption01ClassName().trim().length() == 0) {
            return false;
        }
        return true;
    }

    /**
     * OvÕCX^X𐶐܂B
     * 
     * @return
     * @throws IllegalAccessException
     * @throws InstantiationException
     */
    public static final AbstractActionExternalOption newInstance()
            throws InstantiationException, IllegalAccessException {
        final String className = bundle.getExternalOption01ClassName();
        try {
            return (AbstractActionExternalOption) Class.forName(className)
                    .newInstance();
        } catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("g|CgɂOIvVvOENX["
                    + className + "]̃[hɎs܂B");
        }
    }

    /**
     * X̃t@COɈxJns܂B
     */
    public abstract void open();

    /**
     * tH_̌X̃t@C܂B
     * 
     * @param fileLook
     *            ݏ̃t@CB
     * @param fileTmpDirectory
     *            e|fBNgB
     * @param blancoTargetDirectory
     *            o͐fBNgB
     * @throws IOException
     * @throws TransformerException
     */
    public abstract void processFile(final File fileLook,
            final File fileTmpDirectory, final File blancoTargetDirectory)
            throws IOException, TransformerException;

    /**
     * X̃t@COɈxIs܂B
     */
    public abstract void close(final File folderTargetDirectoryBlanco)
            throws Exception;
}
