/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.soap.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.plugin.soap.BlancoSOAPPlugin;
import blanco.plugin.soap.actions.BlancoSAXGenerateAction;
import blanco.plugin.soap.actions.BlancoSOAPGenerateAction;
import blanco.plugin.soap.actions.BlancoXsdGenerateAction;

/**
 * EclipsevOCɂGfB^
 * 
 * @author IGA Tosiki
 */
public class BlancoSOAPEditor extends TextEditor {

    private Composite top = null;

    public static final String TARGET_FILENAME = "blancosoap.blancofw";

    public static final String BLANCO_META_FILE_TELEGRAM = "d`Ed`";

    public static final String BLANCO_META_FILE_CONCRETESAX = "ۉSAXev[gt@C";

    public BlancoSOAPEditor() {
        // GR[fBO𑀍삷邽߂ɃZbgĂ܂B
        setDocumentProvider(new BlancoSOAPDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoSOAPTitle = new Label(top, SWT.NONE);
        labelBlancoSOAPTitle.setText("BlancoSOAPݒt@C GfB^");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoSOAPSettingId = new Label(top, SWT.NONE);
        labelBlancoSOAPSettingId.setText("ݒID");
        textBlancoSOAPSettingId = new Text(top, SWT.BORDER);
        textBlancoSOAPSettingId.setText("blancoSOAP");
        textBlancoSOAPSettingId.setEditable(false);

        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("ۉSAX (ConcreteSAX) ZNV");

        new Label(top, SWT.NONE).setText("^fBNg");
        comboMetaSaxDir = new Combo(top, SWT.NONE);
        comboMetaSaxDir.add("meta/soap/sax");
        comboMetaSaxDir.select(0);

        new Label(top, SWT.NONE).setText("pbP[W");
        comboMetaSaxPackage = new Combo(top, SWT.NONE);
        comboMetaSaxPackage.add("myapp.sax");
        comboMetaSaxPackage.add("mycompany.myapp.sax");
        comboMetaSaxPackage.select(0);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetaSaxFile = new Button(top, SWT.NONE);
        buttonCreateMetaSaxFile.setText(BLANCO_META_FILE_CONCRETESAX + " VK쐬");
        buttonCreateMetaSaxFile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetaSaxDir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            BLANCO_META_FILE_CONCRETESAX
                                                    + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta/soap/sax' łB");
                            return;
                        }
                        if (comboMetaSaxPackage.getText().length() == 0) {
                            MessageDialog.openWarning(top.getShell(),
                                    BLANCO_META_FILE_CONCRETESAX + " VK쐬",
                                    "pbP[Ww肵ĂB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoSOAPPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetaSaxDir.getText()).exists() == false) {
                                BlancoSOAPPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetaSaxDir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetaSaxDir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }

                            if (BlancoSOAPPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetaSaxDir.getText()).exists() == false) {
                                BlancoSOAPPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetaSaxDir.getText());
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(),
                                    BLANCO_META_FILE_CONCRETESAX + " VK쐬",
                                    "^fBNg쐬Ɏs܂Bf܂B:"
                                            + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        try {
                            URL localURL = getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), BLANCO_META_FILE_CONCRETESAX
                                    + " VK쐬", BLANCO_META_FILE_CONCRETESAX
                                    + "(^t@C)^fBNg["
                                    + comboMetaSaxDir.getText() + "]ɍ쐬܂B"
                                    + BLANCO_META_FILE_CONCRETESAX
                                    + "̐VKt@C͂ĂB",
                                    "SampleConcreteSax.xml",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xml") == false) {
                                                return "t@C .xmlŏI悤Ɏw肵ĂB";
                                            }
                                            if (BlancoNameUtil
                                                    .isValidFileName(newText) == false) {
                                                return "t@Cɂ "
                                                        + BlancoNameUtil
                                                                .invalidFileNameChar()
                                                        + " ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetaSaxDir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            InputStream inStream = new FileInputStream(
                                    localURL.getPath()
                                            + "/meta/soap/sax/template/blancoConcreteSaxTemplate.xml");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetaSaxDir.getText())
                                    .getFile(newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            inStream.close();
                            MessageDialog
                                    .openInformation(
                                            top.getShell(),
                                            BLANCO_META_FILE_CONCRETESAX
                                                    + " VK쐬",
                                            BLANCO_META_FILE_CONCRETESAX
                                                    + "(^t@C ["
                                                    + newMetaFilename
                                                    + "] ^fBNg["
                                                    + comboMetaSaxDir.getText()
                                                    + "]ɐVK쐬܂B\n"
                                                    + "̃t@CҏWāAT^IXMLt@Cݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteSax = new Button(top, SWT.NONE);
        buttonExecuteSax.setText("ۉSAX (ConcreteSAX) \[XR[h");
        buttonExecuteSax
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteSax.setEnabled(false);

                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetaSaxDir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + comboMetaSaxDir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }
                            if (comboMetaSaxPackage.getText().length() == 0) {
                                MessageDialog.openWarning(top.getShell(),
                                        BLANCO_META_FILE_CONCRETESAX + " VK쐬",
                                        "pbP[Ww肵Ă珈sĂB𒆒f܂B");
                                return;
                            }

                            BlancoSAXGenerateAction.process(input.getFile(),
                                    top.getShell(), getProgressMonitor(),
                                    comboMetaSaxDir.getText(),
                                    comboMetaSaxPackage.getText());

                            // blancotH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // soaptH_𓯊
                            // ܂łیƂē܂B
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboMetaSaxDir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteSax.setEnabled(true);
                        }
                    }
                });

        /**
         * ͓dѓd`ZNVB
         */

        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("dѓd`ZNV");

        Label labelMetaWsdlDir = new Label(top, SWT.NONE);
        labelMetaWsdlDir.setText("^fBNg");
        comboMetaWsdlDir = new Combo(top, SWT.NONE);
        comboMetaWsdlDir.add("meta/soap/wsdl");
        comboMetaWsdlDir.select(0);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetaWsdlFile = new Button(top, SWT.NONE);
        buttonCreateMetaWsdlFile.setText(BLANCO_META_FILE_TELEGRAM + " VK쐬");
        buttonCreateMetaWsdlFile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetaWsdlDir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            BLANCO_META_FILE_TELEGRAM + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta/soap/wsdl' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoSOAPPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetaWsdlDir.getText()).exists() == false) {
                                BlancoSOAPPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetaWsdlDir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetaWsdlDir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }

                            if (BlancoSOAPPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetaWsdlDir.getText()).exists() == false) {
                                BlancoSOAPPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetaWsdlDir.getText());
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(),
                                    BLANCO_META_FILE_TELEGRAM + " VK쐬",
                                    "^fBNg쐬Ɏs܂Bf܂B:"
                                            + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        try {
                            URL localURL = getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), BLANCO_META_FILE_TELEGRAM
                                    + " VK쐬", BLANCO_META_FILE_TELEGRAM
                                    + "(^t@C)^fBNg["
                                    + comboMetaWsdlDir.getText() + "]ɍ쐬܂B"
                                    + BLANCO_META_FILE_TELEGRAM
                                    + "̐VKt@C͂ĂB",
                                    "blancoWsdlMeta.xls",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            if (BlancoNameUtil
                                                    .isValidFileName(newText) == false) {
                                                return "t@Cɂ "
                                                        + BlancoNameUtil
                                                                .invalidFileNameChar()
                                                        + " ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetaWsdlDir
                                                                    .getText())

                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            InputStream inStream = new FileInputStream(
                                    localURL.getPath()
                                            + "/meta/soap/wsdl/template/blancoWsdlTemplate.xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetaWsdlDir.getText())
                                    .getFile(newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            inStream.close();
                            MessageDialog
                                    .openInformation(
                                            top.getShell(),
                                            BLANCO_META_FILE_TELEGRAM + " VK쐬",
                                            BLANCO_META_FILE_TELEGRAM
                                                    + "(^t@C ["
                                                    + newMetaFilename
                                                    + "] ^fBNg["
                                                    + comboMetaWsdlDir
                                                            .getText()
                                                    + "]ɐVK쐬܂B\n"
                                                    + "̃t@CҏWāAd`Ed` ֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteWsdl = new Button(top, SWT.NONE);
        buttonExecuteWsdl.setText("d`Ed`wsdlxsd𐶐");
        buttonExecuteWsdl
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteWsdl.setEnabled(false);

                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetaWsdlDir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + comboMetaWsdlDir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            BlancoSOAPGenerateAction.processBlancoSOAP(input
                                    .getFile(), top.getShell(),
                                    getProgressMonitor(), comboMetaWsdlDir
                                            .getText(),
                                    checkBoxGenerateXsdElementDeclaration
                                            .getSelection());

                            // blancotH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // soaptH_𓯊
                            // ܂łیƂē܂B
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboMetaWsdlDir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteWsdl.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");
        Group group = new Group(top, SWT.NONE);
        group.setLayout(new FillLayout());
        group.setText("XML SchemaIvV");
        checkBoxGenerateXsdElementDeclaration = new Button(group, SWT.CHECK);
        checkBoxGenerateXsdElementDeclaration.setText("vf錾𐶐");
        checkBoxGenerateXsdElementDeclaration.setSelection(false);

        /**
         * xsdJava\[XR[h𐶐ZNVB
         */

        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("xsdJava\[XR[h𐶐ZNV");

        new Label(top, SWT.NONE).setText("^fBNg");
        comboMetaXsdDir = new Combo(top, SWT.NONE);
        comboMetaXsdDir.add("tmp/soap/wsdl");
        comboMetaXsdDir.select(0);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteXsd = new Button(top, SWT.NONE);
        buttonExecuteXsd.setText("xsdJava\[XR[h𐶐");
        buttonExecuteXsd
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteXsd.setEnabled(false);

                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetaXsdDir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + comboMetaXsdDir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            BlancoXsdGenerateAction.process(input.getFile(),
                                    top.getShell(), getProgressMonitor(),
                                    comboMetaXsdDir.getText());

                            // blancotH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // ܂łیƂē܂B
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboMetaXsdDir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteXsd.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        new Label(top, SWT.NONE).setText("eX̐ݒl " + TARGET_FILENAME
                + "t@CɕŊi[܂B");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        new Label(top, SWT.NONE).setText("^fBNg͒ʏύXɗp܂B");

        loadFromTextEditor();

        setFocusLostHandler(comboMetaSaxDir);
        setFocusLostHandler(comboMetaSaxPackage);
        setFocusLostHandler(comboMetaWsdlDir);
        setFocusLostHandler(comboMetaXsdDir);
        setFocusLostHandler(checkBoxGenerateXsdElementDeclaration);
    }

    /**
     * vOC̃[gfBNg擾܂B
     * 
     * @return [gfBNgURL getPath()ƃtpXɂȂ܂B
     * @throws IOException
     */
    public static URL getPluginRoot() throws IOException {
        URL relativeURL = BlancoSOAPPlugin.getDefault().getBundle().getEntry(
                "/");
        URL localURL = Platform.asLocalURL(relativeURL);
        return localURL;
    }

    private void setFocusLostHandler(Control target) {
        target.addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                saveToTextEditor();
            }

        });
    }

    public void setFocus() {
    }

    /**
     * Ǎs܂ <br>
     * ̃\bh͏ɖč쐬܂B <br>
     */
    public void loadFromTextEditor() {

        final String editorText = getDocumentProvider().getDocument(
                getEditorInput()).get();

        final DOMResult result = BlancoXmlUtil
                .transformStream2Dom(new ByteArrayInputStream(editorText
                        .getBytes()));
        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final Element elementBlancoSoap = BlancoXmlUtil.getElement(
                    rootDocument, "blanco/target/blancosoap");
            if (elementBlancoSoap == null) {
                // ߂ďf܂B
                return;
            }

            if (elementBlancoSoap.getAttribute("metawsdldir") != null) {
                comboMetaWsdlDir.setText(elementBlancoSoap
                        .getAttribute("metawsdldir"));
            }
            if (elementBlancoSoap.getAttribute("metasaxdir") != null) {
                comboMetaSaxDir.setText(elementBlancoSoap
                        .getAttribute("metasaxdir"));
            }
            if (elementBlancoSoap.getAttribute("metasaxpackage") != null) {
                comboMetaSaxPackage.setText(elementBlancoSoap
                        .getAttribute("metasaxpackage"));
            }
            if (elementBlancoSoap.getAttribute("metaxsddir") != null) {
                comboMetaXsdDir.setText(elementBlancoSoap
                        .getAttribute("metaxsddir"));
            }
            if (elementBlancoSoap.getAttribute("generatexsdelementdeclaration") != null) {
                checkBoxGenerateXsdElementDeclaration
                        .setSelection(elementBlancoSoap.getAttribute(
                                "generatexsdelementdeclaration").equals("true"));
            }
        }
    }

    /**
     * ۑs܂B
     */
    public void saveToTextEditor() {
        final Document document = BlancoXmlUtil.newDocument();
        final Element blanco = document.createElement("blanco");
        document.appendChild(blanco);
        final Element target = document.createElement("target");
        blanco.appendChild(target);
        final Element blancosoap = document.createElement("blancosoap");
        target.appendChild(blancosoap);
        blancosoap.setAttribute("metawsdldir", comboMetaWsdlDir.getText());
        blancosoap.setAttribute("metasaxdir", comboMetaSaxDir.getText());
        blancosoap
                .setAttribute("metasaxpackage", comboMetaSaxPackage.getText());
        blancosoap.setAttribute("metaxsddir", comboMetaXsdDir.getText());
        blancosoap.setAttribute("generatexsdelementdeclaration",
                checkBoxGenerateXsdElementDeclaration.getSelection() ? "true"
                        : "false");

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        BlancoXmlUtil.transformDom2Stream(document, outStream);
        try {
            outStream.flush();
        } catch (IOException e) {
            throw new IllegalArgumentException("z肵ȂO܂B" + e.toString());
        }

        final String currentText = new String(outStream.toByteArray());

        String pastEditorText = getDocumentProvider().getDocument(
                getEditorInput()).get();
        if (pastEditorText.equals(currentText) == false) {
            // eقȂꍇɂ̂ݏ݂s܂B
            getDocumentProvider().getDocument(getEditorInput())
                    .set(currentText);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboMetaWsdlDir.getText().length() == 0) {
            comboMetaWsdlDir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetaWsdlDir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    // rWÄ
    private Label labelBlancoSOAPTitle = null;

    private Label labelBlancoSOAPSettingId = null;

    private Text textBlancoSOAPSettingId = null;

    private Combo comboMetaSaxDir = null;

    private Combo comboMetaSaxPackage = null;

    private Combo comboMetaWsdlDir = null;

    private Combo comboMetaXsdDir = null;

    private Button buttonExecuteWsdl = null;

    private Button buttonCreateMetaWsdlFile = null;

    private Button buttonExecuteSax = null;

    private Button buttonCreateMetaSaxFile = null;

    private Button buttonExecuteXsd = null;

    private Button checkBoxGenerateXsdElementDeclaration = null;

}