/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff;

import java.io.File;

import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffNote;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTool;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoXliffUtil {
    /**
     * pGg|CgB
     * 
     * @param args
     */
    public static final void main(final String[] args) {
        final BlancoXliff xliff = new BlancoXliff();

        {
            final BlancoXliffTool tool = new BlancoXliffTool();
            tool.setToolId("pleiades");
            tool.setToolName("Pleiades");
            xliff.getToolList().add(tool);
        }
        {
            final BlancoXliffTool tool = new BlancoXliffTool();
            tool.setToolId("eclipse3.2.1");
            tool.setToolName("Eclipse 3.2.1 Language Pack");
            xliff.getToolList().add(tool);
        }

        for (int index = 0; index < 10; index++) {
            final BlancoXliffTransUnit unit = new BlancoXliffTransUnit();
            xliff.getTransUnitList().add(unit);
            unit.setId("a" + index);
            unit.setSource("ugeuge" + index);

            final BlancoXliffTarget target = new BlancoXliffTarget();
            unit.setTarget(target);
            target.setTarget("" + index);

            {
                final BlancoXliffNote note = new BlancoXliffNote();
                unit.getNoteList().add(note);
                note.setText("B");
            }

            {
                final BlancoXliffAltTrans altTrans = new BlancoXliffAltTrans();
                altTrans.setToolId("pleiades");
                altTrans.setSource("alt");
                final BlancoXliffTarget altTransTarget = new BlancoXliffTarget();
                altTransTarget.setTarget("");
                altTrans.setTarget(altTransTarget);
                unit.getAltTransList().add(altTrans);

                {
                    final BlancoXliffNote note = new BlancoXliffNote();
                    altTrans.getNoteList().add(note);
                    note.setText("B");
                }
            }
            {
                final BlancoXliffAltTrans altTrans = new BlancoXliffAltTrans();
                altTrans.setToolId("eclipse3.2.1");
                altTrans.setSource("alt");
                final BlancoXliffTarget altTransTarget = new BlancoXliffTarget();
                altTransTarget.setTarget("");
                altTrans.setTarget(altTransTarget);
                unit.getAltTransList().add(altTrans);
            }
        }

        new File("./tmp").mkdirs();
        new BlancoXliffSerializer()
                .serialize(xliff, new File("./tmp/Test.xlf"));
    }
}
