/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.properties;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

import blanco.properties.manifest.BlancoPropertiesManifestReader;
import blanco.properties.manifest.valueobject.BlancoPropertiesManifest;
import blanco.properties.message.BlancoPropertiesMessage;

/**
 * wfBNg̃vpeBt@C邽߂̃p[TB
 * 
 * @author IGA Tosiki
 */
public abstract class BlancoPropertiesDirectoryParser {
    /**
     * bZ[WIuWFNgB
     */
    protected final BlancoPropertiesMessage fMsg = new BlancoPropertiesMessage();

    /**
     * ƂȂ̓fBNgB̃fBNgɃvOC܂܂܂B
     */
    protected File fSourceDir = null;

    /**
     * Java^CmĂ郍P[ꗗB
     */
    protected String[] fKnownLocale = null;

    /**
     * Ώۂ̃P[B
     */
    protected String fTargetLocale = "ja";

    /**
     * ΏۃP[lȂ珈i߂邩ǂB
     */
    protected boolean fIsProcessTargetLocale = false;

    /**
     * ^[QbgEP[ΏۂƂ邩ǂB
     * 
     * pbN|󒊏oȂǂ̓ȏꍇɂ̂trueݒ肵܂B
     * 
     * @param argIsProcessTargetLocale
     */
    public void setProcessTargetLocale(final boolean argIsProcessTargetLocale) {
        fIsProcessTargetLocale = argIsProcessTargetLocale;
    }

    public void setTargetLocale(final String arg) {
        fTargetLocale = arg;
    }

    /**
     * vpeBt@CJnB
     * 
     * @param bundleURI
     * @param inputProps
     * @param argPropertiesNameWithPath
     *            ͌̃vpeBt@CB擪/܂݂܂B_jaȂǂ͕tĂȂԂƂȂ܂B
     * @param bufPropsWriter
     * @throws IOException
     */
    protected abstract void beginProperties(final String bundleURI,
            final Properties inputProps,
            final String argPropertiesNameWithPath,
            final BufferedWriter bufPropsWriter) throws IOException;

    /**
     * vpeBt@C̃L[B
     * 
     * @param bundleURI
     * @param inputProps
     * @param key
     * @param bufPropsWriter
     * @return ǂB
     * @throws IOException
     */
    protected abstract boolean processPropertiesKey(final String bundleURI,
            final Properties inputProps, final String key,
            final BufferedWriter bufPropsWriter) throws IOException;

    /**
     * vpeBt@CIB
     * 
     * @param bundleURI
     * @param inputProps
     * @param bufPropsBytes
     *            o͐̃vpeBt@C̓eB(vpeBt@Co͂Kvȏꍇɂ̂ݗp܂)
     * @param isReplaced
     *            uꂽǂB
     * @throws IOException
     */
    protected abstract void endProperties(final String bundleURI,
            final Properties inputProps,
            final BlancoPropertiesManifest manifest,
            final byte[] bufPropsBytes, final boolean isReplaced)
            throws IOException;

    /**
     * p[X̂߂̃Gg|CgB
     * 
     * @param fileSourceDir
     * @throws IOException
     * @throws IllegalArgumentException
     */
    public void parse(final File fileSourceDir) throws IOException,
            IllegalArgumentException {
        fSourceDir = fileSourceDir;
        final File[] files = fSourceDir.listFiles();
        if (files != null) {
            for (int index = 0; index < files.length; index++) {
                if (files[index].isDirectory()) {
                    // WJꂽvOCfBNgB
                    processPluginExpandedDir(files[index].getName(), "");
                } else {
                    if (files[index].getName().endsWith(".jar")) {
                        // jart@C`̃vOCB
                        processPluginJarFile(files[index].getName());
                    }
                }
            }
        }
    }

    /**
     * vOCjart@C܂B
     * 
     * TODO ͂ String  File ɕύX邱ƂB
     * 
     * @param targetPluginFullPlusJar
     * @throws IOException
     */
    private void processPluginJarFile(final String targetPluginFullPlusJar)
            throws IOException {
        final BlancoPropertiesManifest manifest = new BlancoPropertiesManifestReader()
                .readPluginJar(new File(fSourceDir.getAbsolutePath() + "/"
                        + targetPluginFullPlusJar));

        String actualTargetPluginFull = targetPluginFullPlusJar;
        if (actualTargetPluginFull.endsWith(".jar")) {
            // .jar ̎wӏ܂B
            actualTargetPluginFull = actualTargetPluginFull.substring(0,
                    actualTargetPluginFull.length() - ".jar".length());
        } else {
            throw new IllegalArgumentException(fMsg
                    .getMbpri001(targetPluginFullPlusJar));
        }

        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(fSourceDir.getAbsolutePath() + "/"
                        + actualTargetPluginFull + ".jar"));
        processJarFileInternal(manifest, inStream);
        inStream.close();
    }

    /**
     * vOC̓WJfBNg܂B
     * 
     * @param targetPluginFullPlus
     * @throws IOException
     */
    private void processPluginExpandedDir(final String targetPluginFullPlus,
            final String subdir) throws IOException {
        final BlancoPropertiesManifest manifest = new BlancoPropertiesManifestReader()
                .readPluginDirectory(new File(fSourceDir.getAbsolutePath()
                        + "/" + targetPluginFullPlus));

        final File[] files = new File(fSourceDir.getAbsolutePath() + "/"
                + targetPluginFullPlus
                + (subdir.length() == 0 ? "" : "/" + subdir)).listFiles();
        if (files != null) {
            for (int index = 0; index < files.length; index++) {
                if (files[index].isDirectory()) {
                    // TODO fBNgȂĂǂ̂ǂׂB
                    if (files[index].getName().equals(".")
                            || files[index].getName().equals("..")) {
                        // Ȃ
                    } else {
                        // ċAĂяo
                        processPluginExpandedDir(targetPluginFullPlus, subdir
                                + "/" + files[index].getName());
                    }
                } else {
                    if (files[index].getName().endsWith(".jar")) {
                        final InputStream inStream = new BufferedInputStream(
                                new FileInputStream(fSourceDir
                                        .getAbsolutePath()
                                        + "/"
                                        + targetPluginFullPlus
                                        + (subdir.length() == 0 ? "" : "/"
                                                + subdir)
                                        + "/"
                                        + files[index].getName()));
                        if (processJarFileInternal(manifest, inStream)) {
                            // u܂B
                        }
                        inStream.close();
                    } else if (checkFilenameForTarget(files[index].getName())) {
                        final InputStream inStream = new BufferedInputStream(
                                new FileInputStream(files[index]));

                        // 񍐗px[XfBNg:begin
                        final String wrkBase = new File(fSourceDir
                                .getAbsolutePath()
                                + "/" + targetPluginFullPlus)
                                .getCanonicalPath();
                        final String strPropertyFilePath = files[index]
                                .getCanonicalPath().substring(
                                        wrkBase.length() + 1);
                        // 񍐗px[XfBNg:end

                        if (processPropertiesFile(manifest,
                                BlancoPropertiesUtil.getBabelURI(manifest,
                                        strPropertyFilePath), inStream, "/"
                                        + (subdir.length() == 0 ? "" : "/"
                                                + subdir) + "/"
                                        + files[index].getName())) {
                            // u܂B
                        }

                        inStream.close();
                    }
                }
            }
        }
    }

    /**
     * jart@Ĉ߂̓\bhłB
     * 
     * @param manifest
     *            }jtFXgB
     * @param inStreamJarTarget
     *            jart@C̓̓Xg[B
     * @return ǂB
     * @throws IOException
     *             o͗OꍇB
     */
    private boolean processJarFileInternal(
            final BlancoPropertiesManifest manifest,
            final InputStream inStreamJarTarget) throws IOException {
        boolean isReplaced = false;
        final JarInputStream jarInStream = new JarInputStream(
                new BufferedInputStream(inStreamJarTarget));
        for (;;) {
            final JarEntry entry = jarInStream.getNextJarEntry();
            if (entry == null) {
                break;
            }

            if (entry.isDirectory()) {
            } else {
                if (entry.getName().endsWith(".jar")) {
                    if (processJarFileInternal(manifest, jarInStream)) {
                        isReplaced = true;
                    }
                } else {
                    if (checkFilenameForTarget(entry.getName()) == false) {
                        continue;
                    }

                    if (processPropertiesFile(manifest, BlancoPropertiesUtil
                            .getBabelURI(manifest, entry.getName()),
                            jarInStream, "/" + entry.getName())) {
                        isReplaced = true;
                    }
                }
            }
            jarInStream.closeEntry();
        }
        return isReplaced;

        // \B̓Xg[(jarInStream)́AăN[Y܂I Java
        // API̓lŕKvȑ[ułB
    }

    /**
     * vpeBt@C܂B
     * 
     * @param bundleURI
     * @param jarInStream
     * @param fileTarget
     * @return ǂB
     * @throws IOException
     */
    private boolean processPropertiesFile(
            final BlancoPropertiesManifest manifest, final String bundleURI,
            final InputStream jarInStream,
            final String argTargetPropertiesNameWithPath) throws IOException {
        // oCgƂēǂݍ
        final byte[] bytesProperties = BlancoPropertiesUtil
                .readBytes(jarInStream);

        final Properties props = new Properties();
        props.load(new ByteArrayInputStream(bytesProperties));

        final BufferedReader reader = new BufferedReader(new InputStreamReader(
                new ByteArrayInputStream(bytesProperties)));

        final boolean isReplaced = parseProperties(bundleURI, props, manifest,
                reader, argTargetPropertiesNameWithPath);

        return isReplaced;
    }

    /**
     * ^ꂽt@CׂvpeBt@Cł邩ǂ𔻒肵܂B
     * 
     * @param argFilename
     * @return
     */
    private boolean checkFilenameForTarget(final String argFilename) {
        if (argFilename.endsWith(".properties") == false) {
            // t@C .propertiesŏIĂȂ̂͏ΏۊOłB
            return false;
        }

        if (fKnownLocale == null) {
            fKnownLocale = BlancoPropertiesUtil.getAvailableLocaleStrings();
        }

        if (fIsProcessTargetLocale) {
            // ^[QbgP[ΏۂƂȂꍇɂ̂ݔ肵܂B
            if (argFilename.endsWith("_" + fTargetLocale + ".properties")) {
                // ݂̃^[QbgP[Ȃ珈ΏۂłB
                return true;
            }
        }

        for (int index = 0; index < fKnownLocale.length; index++) {
            if (argFilename.endsWith("_" + fKnownLocale[index] + ".properties")) {
                // t@C _(P[).propertiesŏIĂ̂͏ΏۊOłB
                return false;
            }
        }

        return true;
    }

    private boolean parseProperties(final String bundleURI,
            final Properties props, final BlancoPropertiesManifest manifest,
            final BufferedReader reader,
            final String argTargetPropertiesNameWithPath) throws IOException {
        boolean isReplaced = false;

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        final BufferedWriter writer = new BufferedWriter(
                new OutputStreamWriter(outStream));

        beginProperties(bundleURI, props, argTargetPropertiesNameWithPath,
                writer);

        for (;;) {
            outerLoop: {
                final String line = reader.readLine();
                if (line == null) {
                    break;
                }

                if (line.trim().startsWith("#") || line.trim().startsWith("!")
                        || line.trim().length() == 0) {
                    writer.write(line);
                    writer.newLine();
                    continue;
                }

                final StringBuffer strbufKey = new StringBuffer();

                StringReader readerLine = new StringReader(line);
                for (;;) {
                    final int iRead = readerLine.read();
                    if (iRead < 0) {
                        writer.newLine();
                        break outerLoop;
                    }
                    if (iRead == '\\') {
                        // GXP[vJnB
                        final int iRead2 = readerLine.read();
                        if (iRead2 < 0) {
                            // GXP[vȂ̂ɍsɗĂ܂܂B
                            // d̂ŉƂɂ܂B
                            System.out.println(fMsg.getMbprp001(line));
                            break;
                        }
                        switch ((char) iRead2) {
                        case 'n':
                            strbufKey.append('\n');
                            break;
                        default:
                            strbufKey.append((char) iRead2);
                            break;
                        }
                    } else {

                        // ڏB
                        writer.write(iRead);
                        if (iRead == '=') {
                            // ӒlI
                            break;
                        }
                        strbufKey.append((char) iRead);
                    }
                }

                // ͉EӒl

                boolean isEscapeStarted = false;
                for (boolean isValueStarted = false;;) {
                    final int iRead = readerLine.read();
                    if (iRead < 0) {
                        if (isEscapeStarted) {
                            // GXP[vȂ̂ɍsɗĂ܂܂B
                            final String line2 = reader.readLine();
                            if (line2 == null) {
                                break;
                            }
                            isEscapeStarted = false;
                            readerLine = new StringReader(line2);
                            continue;
                        }
                        break;
                    }
                    if (isValueStarted == false && iRead == ' ') {
                        continue;
                    }
                    isValueStarted = true;

                    if (iRead == '\\') {
                        if (isEscapeStarted == false) {
                            isEscapeStarted = true;
                        } else {
                            isEscapeStarted = false;
                        }
                    } else {
                        if (isEscapeStarted) {
                            isEscapeStarted = false;
                        }
                    }
                }

                readerLine.close();

                // 擾ꂽL[ƂɈĉ\ł邱Ƃ`FbN܂B

                // key \ 邱Ƃ̍ltŕ擾܂B
                final String strKey = BlancoPropertiesUtil
                        .normalizeKeyString(strbufKey.toString());
                final String inputValue = (String) props.get(strKey);
                if (inputValue == null) {
                    System.out.println(fMsg.getMbprp002(strKey));
                    final Iterator ite = props.entrySet().iterator();
                    for (; ite.hasNext();) {
                        final Object obj = ite.next();
                        System.out.println("  " + obj.toString());
                    }

                    // fB
                    throw new IllegalArgumentException(fMsg.getMbprp003(
                            bundleURI, strKey));
                }

                if (processPropertiesKey(bundleURI, props, strKey, writer)) {
                    isReplaced = true;
                }
            }
        }

        writer.close();

        endProperties(bundleURI, props, manifest, outStream.toByteArray(),
                isReplaced);

        return isReplaced;
    }
}
