/*
 * blanco Framework
 * Copyright(C) 2006-2008 NTT DATA BUSINESS BRAINS CORPORATION.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.soap.terasoluna.rich;

import java.io.File;
import java.util.HashMap;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoXmlUtil;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

/**
 * d`p[X܂B
 * 
 * uv𗘗p邽߂ɁÃNX͗pB<br>
 * ̃NX blanco Framework̊NXQlƂč쐬܂B
 * 
 * @author IGA Tosiki
 */
public class ParseTelegramProcessDefInfo {
    /**
     * d`̃}bvB
     */
    private HashMap fMap = new HashMap();

    /**
     * w̃e|tH_̑Έʒuɂd`ꗗ̃t@Cǂݍ݂܂B
     * 
     * @param fileTmpDirectory
     *            e|tH_̃[gB
     * @return BlancoSqlDefInfoValueObjectMap߂܂B
     */
    public HashMap process(final File fileTmpDirectory) {
        DOMResult result = null;
        try {
            result = BlancoXmlUtil.transformFile2Dom(new File(fileTmpDirectory
                    .getAbsolutePath()
                    + "/doclisting/blancotelegramprocess-common.combinedxml"));
        } catch (java.lang.IllegalArgumentException ex) {
            System.out.println("t@Cǂݍ݂ȂǂɎs܂Bf܂B" + ex.toString());
            // t@Cǂݍ݂ȂǂɎs܂Bf܂B
            return fMap;
        }
        final Element element = BlancoXmlUtil.getElement(result.getNode(),
                "workbook/sheet");
        if (element == null) {
            System.out
                    .println("blancotelegramprocess-common烋[gm[h͂Ɏs܂B");
            return fMap;
        }
        final NodeList nodeList = element
                .getElementsByTagName("blancotelegramprocess-common");
        final int sizeList = nodeList.getLength();
        for (int index = 0; index < sizeList; index++) {
            final Node nodeLook = nodeList.item(index);
            if (nodeLook instanceof Element == false) {
                continue;
            }
            final Element eleLook = (Element) nodeLook;

            final BlancoWsdlWebServiceOperation telegramProcessDefInfo = new BlancoWsdlWebServiceOperation();

            telegramProcessDefInfo.setName(BlancoXmlUtil.getTextContent(
                    eleLook, "telegramProcessId"));
            telegramProcessDefInfo.setDescription(BlancoXmlUtil.getTextContent(
                    eleLook, "description"));

            fMap.put(telegramProcessDefInfo.getName(), telegramProcessDefInfo);

            // SQL`̃T[`ɂẮATERASOLUNAgΉłɂ͎܂B
        }
        return fMap;
    }
}
