/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoXliffUtilMerge]̃NX
 */
package blanco.xliff.util.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilMergeProcessInput;

/**
 * Apache Ant^XN [BlancoXliffUtilMerge]̃NXB
 *
 * [XLIFFΉc[] w肳ꂽfBNgԂ OASIS XLIFF t@C(*.xlf)}[W܂B̃^XN targetdir()DƂ}[W{܂Bsourcedir(E)݂̂ɑ݂trans-unit (Babel URI)͔j܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.xliff.util.task]BlancoXliffUtilMergeBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoxliffutilmerge&quot; classname=&quot;blanco.xliff.util.task.BlancoXliffUtilMergeTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoXliffUtilMergeTask extends Task {
    /**
     * [XLIFFΉc[] w肳ꂽfBNgԂ OASIS XLIFF t@C(*.xlf)}[W܂B̃^XN targetdir()DƂ}[W{܂Bsourcedir(E)݂̂ɑ݂trans-unit (Babel URI)͔j܂B
     */
    protected BlancoXliffUtilMergeProcessInput fInput = new BlancoXliffUtilMergeProcessInput();

    /**
     * [XLIFFΉc[] w肳ꂽfBNgԂ OASIS XLIFF t@C(*.xlf)}[W܂B̃^XN targetdir()DƂ}[W{܂Bsourcedir(E)݂̂ɑ݂trans-unit (Babel URI)͔j܂B
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * [XLIFFΉc[] w肳ꂽfBNgԂ OASIS XLIFF t@C(*.xlf)}[W܂B̃^XN targetdir()DƂ}[W{܂Bsourcedir(E)݂̂ɑ݂trans-unit (Babel URI)͔j܂B
     */
    protected boolean fIsFieldSourcedirProcessed = false;

    /**
     * [XLIFFΉc[] w肳ꂽfBNgԂ OASIS XLIFF t@C(*.xlf)}[W܂B̃^XN targetdir()DƂ}[W{܂Bsourcedir(E)݂̂ɑ݂trans-unit (Babel URI)͔j܂B
     */
    protected boolean fIsFieldToolidProcessed = false;

    /**
     * [XLIFFΉc[] w肳ꂽfBNgԂ OASIS XLIFF t@C(*.xlf)}[W܂B̃^XN targetdir()DƂ}[W{܂Bsourcedir(E)݂̂ɑ݂trans-unit (Babel URI)͔j܂B
     */
    protected boolean fIsFieldSettargetifnotexistProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * o͑Ώۂ XLIFF (*.xlf) t@C()܂܂fBNgBɏ܂BύX  XLIFF ݂̂Ɏ{܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * o͑Ώۂ XLIFF (*.xlf) t@C()܂܂fBNgBɏ܂BύX  XLIFF ݂̂Ɏ{܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * ͑Ώۂ XLIFF (*.xlf) t@C(E)܂܂fBNgBӂɑ݂Ȃ trans-unit (Babel URI) ͖܂B<br>
     *
     * @param arg Zbgl
     */
    public void setSourcedir(final String arg) {
        fInput.setSourcedir(arg);
        fIsFieldSourcedirProcessed = true;
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * ͑Ώۂ XLIFF (*.xlf) t@C(E)܂܂fBNgBӂɑ݂Ȃ trans-unit (Babel URI) ͖܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSourcedir() {
        return fInput.getSourcedir();
    }

    /**
     * Ant^XN[toolid]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * }[W{ۂɗp tool-idBnlpack  pleiades Ȃǂw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setToolid(final String arg) {
        fInput.setToolid(arg);
        fIsFieldToolidProcessed = true;
    }

    /**
     * Ant^XN[toolid]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * }[W{ۂɗp tool-idBnlpack  pleiades Ȃǂw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getToolid() {
        return fInput.getToolid();
    }

    /**
     * Ant^XN[settargetifnotexist]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * trans-unit  target ݂ȂꍇɒlZbg邩ǂB<br>
     *
     * @param arg Zbgl
     */
    public void setSettargetifnotexist(final boolean arg) {
        fInput.setSettargetifnotexist(arg);
        fIsFieldSettargetifnotexistProcessed = true;
    }

    /**
     * Ant^XN[settargetifnotexist]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * trans-unit  target ݂ȂꍇɒlZbg邩ǂB<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public boolean getSettargetifnotexist() {
        return fInput.getSettargetifnotexist();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoXliffUtilMergeTask begin.");

        // ڔԍ[1]AAgr[g[targetdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldTargetdirProcessed == false) {
            throw new BuildException("K{Agr[g[targetdir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[sourcedir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldSourcedirProcessed == false) {
            throw new BuildException("K{Agr[g[sourcedir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[3]AAgr[g[toolid]͕K{͂łB̓`FbNs܂B
        if (fIsFieldToolidProcessed == false) {
            throw new BuildException("K{Agr[g[toolid]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- sourcedir:[" + getSourcedir() + "]");
            System.out.println("- toolid:[" + getToolid() + "]");
            System.out.println("- settargetifnotexist:[" + getSettargetifnotexist() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoXliffUtilMergeProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilMergeProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoXliffUtilMergeProcess proc = new BlancoXliffUtilMergeProcessImpl();
            if (proc.execute(fInput) != BlancoXliffUtilMergeBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
