/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff.util.task;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

import blanco.commons.util.BlancoFileUtil;
import blanco.xliff.BlancoXliffParser;
import blanco.xliff.BlancoXliffSerializer;
import blanco.xliff.util.task.valueobject.BlancoXliffUtilChangeProcessInput;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoXliffUtilChangeProcessImpl implements
        BlancoXliffUtilChangeProcess {
    private BlancoXliffUtilChangeProcessInput fInput = null;

    private BlancoXliff fXliff = null;

    public int execute(final BlancoXliffUtilChangeProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;
        fXliff = new BlancoXliffParser()
                .parse(new File(fInput.getSourcefile()));

        for (int indexFile = 0; indexFile < fXliff.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) fXliff.getFileList()
                    .get(indexFile);
            processFile(file);
        }

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream(8192);

        new BlancoXliffSerializer().serialize(fXliff, outStream);

        switch (BlancoFileUtil.bytes2FileIfNecessary(outStream.toByteArray(),
                new File(fInput.getTargetfile()))) {
        case 1:
            // {IɁAɂ͓Ȃ݁B
            if (fInput.getVerbose()) {
                System.out.println("xliff: change: create");
            }
            break;
        case 2:
            if (fInput.getVerbose()) {
                System.out.println("xliff: change: update");
            }
            break;
        }

        return 0;
    }

    private void processFile(final BlancoXliffFile file) {
        for (int index = 0; index < file.getBody().getTransUnitList().size(); index++) {
            final BlancoXliffTransUnit transUnit = (BlancoXliffTransUnit) file
                    .getBody().getTransUnitList().get(index);

            if (transUnit.getTranslate() == false) {
                // OځB
            } else {
                if (transUnit.getTarget() == null) {
                    final BlancoXliffTarget target = new BlancoXliffTarget();
                    transUnit.setTarget(target);
                    // source  target ɕʁB
                    target.setTarget(transUnit.getSource());
                    target.setState("x-notarget");
                }
            }
        }
    }
}
