/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherLoggingTransformer
extends LauncherTransformer
implements ITimingLogger {
    private static final Logger log = Logger.getLogger(LauncherLoggingTransformer.class);
    private static final String CLASS_NAME = LauncherLoggingTransformer.class.getName();
    private static final long startTime = System.currentTimeMillis();
    private volatile int loadTime;
    private volatile int loadCall;
    private volatile int transformAbstractTime;
    private volatile int transformAbstractCall;
    private volatile int createCtClassTime;
    private volatile int createCtClassCall;
    private volatile int transformTime;
    private volatile int transformCall;
    private volatile int transformWorkbenchClassTime;
    private volatile int transformWorkbenchClassCall;
    private volatile int transformMainClassTime;
    private volatile int transformMainClassCall;

    public LauncherLoggingTransformer() {
        Pleiades.registTimingLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load() {
        long startTime = System.currentTimeMillis();
        super.load();
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.loadTime = (int)((long)this.loadTime + (System.currentTimeMillis() - startTime));
            ++this.loadCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String internalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytecode) throws IllegalClassFormatException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.transform(loader, internalName, classBeingRedefined, protectionDomain, bytecode);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.transformAbstractTime = (int)((long)this.transformAbstractTime + (System.currentTimeMillis() - startTime));
            ++this.transformAbstractCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.transform(loader, className, protectionDomain, bytecode);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.transformTime = (int)((long)this.transformTime + (System.currentTimeMillis() - startTime));
            ++this.transformCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] transformMainClass(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        byte[] result = super.transformMainClass(protectionDomain, bytecode);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.transformMainClassTime = (int)((long)this.transformMainClassTime + (System.currentTimeMillis() - startTime));
            ++this.transformMainClassCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] transformWorkbenchClass(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
        CtMethod runStartupWithProgress = ctClass.getMethod("runStartupWithProgress", "(ILjava/lang/Runnable;)V");
        runStartupWithProgress.insertAfter(String.valueOf(CLASS_NAME) + ".logUpTime();");
        byte[] result = ctClass.toBytecode();
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.transformWorkbenchClassTime = (int)((long)this.transformWorkbenchClassTime + (System.currentTimeMillis() - startTime));
            ++this.transformWorkbenchClassCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CtClass createCtClass(byte[] bytecode, ProtectionDomain protectionDomain) throws IOException, NotFoundException {
        long startTime = System.currentTimeMillis();
        CtClass result = super.createCtClass(bytecode, protectionDomain);
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            this.createCtClassTime = (int)((long)this.createCtClassTime + (System.currentTimeMillis() - startTime));
            ++this.createCtClassCall;
        }
        return result;
    }

    public static void destroy() {
        LauncherLoggingTransformer.logLapTime();
        LauncherTransformer.destroy();
    }

    public static void logUpTime() {
        LauncherLoggingTransformer.logLapTime();
        long curTime = System.currentTimeMillis();
        double time = (double)(curTime - startTime) / 1000.0;
        log.debug(String.format("Eclipse \u306e\u8d77\u52d5\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\u8d77\u52d5\u6642\u9593: %.3f \u79d2", time));
    }

    public static void logLapTime() {
        long summuryTime = 0L;
        for (ITimingLogger logger : Pleiades.getTimeingLoggers()) {
            summuryTime += logger.logTime();
            logger.reset();
        }
        log.debug(String.format("Pleiades \u51e6\u7406\u6642\u9593\u8a08 %6.3f \u79d2", (double)summuryTime / 1000.0));
    }

    @Override
    public long logTime() {
        String msg = "%-31s %8d \u56de\u547c\u51fa\u8a08 %6.3f \u79d2";
        log.debug(String.format(msg, "load", this.loadCall, (double)this.loadTime / 1000.0));
        log.debug(String.format(msg, "transform (Abstract)", this.transformAbstractCall, (double)this.transformAbstractTime / 1000.0));
        log.debug(String.format(msg, "  transform", this.transformCall, (double)this.transformTime / 1000.0));
        log.debug(String.format(msg, "    createCtClass (Abstract)", this.createCtClassCall, (double)this.createCtClassTime / 1000.0));
        log.debug(String.format(msg, "    transformMainClass", this.transformMainClassCall, (double)this.transformMainClassTime / 1000.0));
        log.debug(String.format(msg, "    transformWorkbenchClass", this.transformWorkbenchClassCall, (double)this.transformWorkbenchClassTime / 1000.0));
        long summuryTime = this.transformAbstractTime + this.transformTime + this.createCtClassTime + this.transformMainClassTime + this.transformWorkbenchClassTime;
        log.debug(String.format("\u30af\u30e9\u30b9\u8a08 %6.3f \u79d2", (double)summuryTime / 1000.0));
        return summuryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        LauncherLoggingTransformer launcherLoggingTransformer = this;
        synchronized (launcherLoggingTransformer) {
            Field[] fields = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (field.getType() == Integer.TYPE) {
                    try {
                        field.setAccessible(true);
                        field.set(this, 0);
                    }
                    catch (Exception e) {
                        log.error("\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                    }
                }
                ++i;
            }
        }
    }
}

