/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.java;

import java.util.List;

import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.cg.valueobject.BlancoCgType;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgInterface\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgInterfaceJavaSourceExpander {

    /**
     * interfaceWJ܂B
     * 
     * @param cgInterface
     *            ΏۂƂȂC^tF[XB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformInterface(final BlancoCgInterface cgInterface,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        // C^tF[X̏ꍇɂ tB[h⃁\bhpublicO܂B

        // ŏɃC^tF[XLangDocɓWJB
        if (cgInterface.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgInterface.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgInterface.getLangDoc().getTitle() == null) {
            cgInterface.getLangDoc().setTitle(cgInterface.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocJavaSourceExpander().transformLangDoc(cgInterface
                .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgInterface, argSourceLines);

        final StringBuffer buf = new StringBuffer();

        if (BlancoStringUtil.null2Blank(cgInterface.getAccess()).length() > 0) {
            buf.append(cgInterface.getAccess() + " ");
        }
        // staticfinal͓WJ܂B
        buf.append("interface " + cgInterface.getName());

        // ŐeNXWJB
        expandExtendClassList(cgInterface, buf);

        // |Cg: eC^tF[XWJ interfaceɂ݂͑܂B

        buf.append(" {");

        argSourceLines.add(buf.toString());

        // ŃtB[hWJB
        expandFieldList(cgInterface, argSourceFile, argSourceLines);

        // Ń\bhWJB
        expandMethodList(cgInterface, argSourceFile, argSourceLines);

        argSourceLines.add("}");
    }

    /**
     * Ame[VWJ܂B
     * 
     * @param cgInterface
     *            C^tF[XB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandAnnotationList(final BlancoCgInterface cgInterface,
            final List<java.lang.String> argSourceLines) {
        for (int index = 0; index < cgInterface.getAnnotationList().size(); index++) {
            final String strAnnotation = cgInterface.getAnnotationList().get(
                    index);

            // JavaAnnotation @ Lq܂B
            argSourceLines.add("@" + strAnnotation);
        }
    }

    /**
     * eNXWJ܂B
     * 
     * @param cgClass
     * @param buf
     */
    private void expandExtendClassList(final BlancoCgInterface cgClass,
            final StringBuffer buf) {
        for (int index = 0; index < cgClass.getExtendClassList().size(); index++) {
            final BlancoCgType type = cgClass.getExtendClassList().get(index);

            if (index == 0) {
                buf.append(" extends "
                        + BlancoCgTypeJavaSourceExpander.toTypeString(type));
            } else {
                throw new IllegalArgumentException("Javał͌p͈񂵂{ł܂B");
            }
        }
    }

    /**
     * ܂܂eX̃tB[hWJ܂B
     * 
     * @param cgInterface
     * @param argSourceFile
     * @param argSourceLines
     */
    private void expandFieldList(final BlancoCgInterface cgInterface,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        if (cgInterface.getFieldList() == null) {
            // tB[h̃Xgnull^܂B
            // Ȃ炸tB[h̃XgɂListZbgĂB
            throw new IllegalArgumentException("tB[h̃Xgnull^܂B");
        }

        for (int index = 0; index < cgInterface.getFieldList().size(); index++) {
            final BlancoCgField cgField = cgInterface.getFieldList().get(index);
            new BlancoCgFieldJavaSourceExpander().transformField(cgField,
                    argSourceFile, argSourceLines, true);
        }
    }

    /**
     * ܂܂eX̃\bhWJ܂B
     * 
     * @param cgInterface
     * @param argSourceFile
     * @param argSourceLines
     */
    private void expandMethodList(final BlancoCgInterface cgInterface,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        if (cgInterface.getMethodList() == null) {
            throw new IllegalArgumentException("\bh̃Xgnull^܂B");
        }
        for (int index = 0; index < cgInterface.getMethodList().size(); index++) {
            final BlancoCgMethod cgMethod = cgInterface.getMethodList().get(
                    index);
            new BlancoCgMethodJavaSourceExpander().transformMethod(cgMethod,
                    argSourceFile, argSourceLines, true);
        }
    }
}
