/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.logmessage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.logmessage.message.BlancoLogMessageMessage;
import blanco.logmessage.resourcebundle.BlancoLogMessageResourceBundle;
import blanco.logmessage.stringgroup.BlancoLogMessageLevelStringGroup;
import blanco.logmessage.valueobject.BlancoLogMessageFieldStructure;
import blanco.logmessage.valueobject.BlancoLogMessageStructure;
import blanco.resourcebundle.BlancoResourceBundleUtil;
import blanco.resourcebundle.BlancoResourceBundleXml2JavaClass;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleResourceStringStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;

/**
 * ubZ[W`vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoLogMessageXml2SourceFile {
    private final BlancoLogMessageMessage fMsg = new BlancoLogMessageMessage();

    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoLogMessageResourceBundle fBundle = new BlancoLogMessageResourceBundle();

    /**
     * o͑ΏۂƂȂvO~OB
     */
    private int fTargetLang = BlancoCgSupportedLang.NOT_DEFINED;

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argTargetLang, final File argDirectoryTarget)
            throws IOException {

        fTargetLang = new BlancoCgSupportedLang().convertToInt(argTargetLang);
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
            break;
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
        default:
            throw new IllegalArgumentException(fMsg.getMbmsgi02(argTargetLang));
        }

        final BlancoLogMessageStructure[] structures = new BlancoLogMessageXmlParser()
                .parse(argMetaXmlSourceFile);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Source(structures[index], argDirectoryTarget);

            if (fTargetLang == BlancoCgSupportedLang.JAVA) {
                expandResourceBundleForJava(structures[index],
                        argDirectoryTarget);
            }
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param argStructure
     *            ^XN̍\B
     * @param argDirectoryTarget
     *            o͐fBNg
     */
    public void structure2Source(final BlancoLogMessageStructure argStructure,
            final File argDirectoryTarget) {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argStructure.getPackage(),
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(BlancoNameAdjuster
                .toClassName(argStructure.getName())
                + BlancoStringUtil.null2Blank(argStructure.getSuffix()),
                BlancoStringUtil.null2Blank(argStructure.getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        if (fTargetLang == BlancoCgSupportedLang.JAVA) {
            // Javȁꍇɂ̓\[Xoh𗘗pB
            final BlancoCgField field = new BlancoCgField();
            field.setName("fBundle");
            field.setType(fCgFactory.createType(argStructure.getPackage() + "."
                    + BlancoNameAdjuster.toClassName(argStructure.getName())
                    + argStructure.getSuffix() + "ResourceBundle"));
            field
                    .setDescription("ObZ[WvpeBt@CΉ邽߂̓Iɗp郊\[XohNXB");
            field.setDefault("new "
                    + BlancoNameAdjuster.toClassName(argStructure.getName())
                    + argStructure.getSuffix() + "ResourceBundle()");
            field.setFinal(true);
            field.setAccess("protected");
            fCgClass.getFieldList().add(field);
        }

        for (int indexField = 0; indexField < argStructure.getFieldList()
                .size(); indexField++) {
            final BlancoLogMessageFieldStructure fieldLook = argStructure
                    .getFieldList().get(indexField);
            expandMethodLogMessage(argStructure, fieldLook, false);
            expandMethodLogMessage(argStructure, fieldLook, true);
        }

        BlancoCgTransformerFactory.getSourceTransformer(fTargetLang).transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * logbZ[W \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argThrowable
     *            OtǂB
     */
    @SuppressWarnings("unchecked")
    private void expandMethodLogMessage(
            final BlancoLogMessageStructure argProcessStructure,
            final BlancoLogMessageFieldStructure fieldLook,
            final boolean argThrowable) {

        final List listSplitMessage = new ArrayList();
        listSplitMessage.add((argProcessStructure.getIdEmbedding() ? "["
                + fieldLook.getName() + "] " : "")
                + fieldLook.getMessage());
        final int maxReplaceNumber = new BlancoLogMessageSplitUtil()
                .split(listSplitMessage);

        final int blancoResourceBundleFormatCount = BlancoResourceBundleUtil
                .getFormatsByArgumentIndex(fieldLook.getMessage(), false).length;

        if (maxReplaceNumber + 1 != blancoResourceBundleFormatCount) {
            throw new IllegalArgumentException(fMsg.getMbmsgi04(
                    argProcessStructure.getName(), fieldLook.getName(), Integer
                            .toString(maxReplaceNumber + 1), Integer
                            .toString(blancoResourceBundleFormatCount)));
        }

        final String methodName = "log"
                + BlancoNameAdjuster.toClassName(fieldLook.getName());

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName(methodName), "ObZ[W`ID["
                        + argProcessStructure.getName() + "]Ax["
                        + fieldLook.getLevel() + "]AL[[" + fieldLook.getName()
                        + "]̕MO܂B");
        fCgClass.getMethodList().add(cgMethod);

        // System.out.println("u:" + maxReplaceNumber);
        for (int indexArg = 0; indexArg <= maxReplaceNumber; indexArg++) {
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("arg" + indexArg,
                            getTypeString(), "u{" + indexArg + "}̒lB"));
        }

        if (argThrowable) {
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("argThrown",
                            "java.lang.Throwable", "OB"));
        }

        if (fieldLook.getNo() != null) {
            cgMethod.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
        }
        cgMethod.getLangDoc().getDescriptionList().add(
                "["
                        + BlancoCgSourceUtil.escapeStringAsLangDoc(fTargetLang,
                                fieldLook.getMessage()) + "]");

        final List<java.lang.String> lineList = cgMethod.getLineList();

        final StringBuffer bufLine = new StringBuffer();

        String logLevelName = "INFO";
        String sysoutLevelName = "INFO";
        String logMessagePrefix = "";
        switch (new BlancoLogMessageLevelStringGroup().convertToInt(fieldLook
                .getLevel())) {
        case BlancoLogMessageLevelStringGroup.FATAL:
            logMessagePrefix = "fatal: ";
            logLevelName = "SEVERE";
            sysoutLevelName = "FATAL";
            break;
        case BlancoLogMessageLevelStringGroup.ERROR:
            logLevelName = "SEVERE";
            sysoutLevelName = "ERROR";
            break;
        case BlancoLogMessageLevelStringGroup.WARN:
            logLevelName = "WARNING";
            sysoutLevelName = "WARN ";
            break;
        case BlancoLogMessageLevelStringGroup.INFO:
            logLevelName = "INFO";
            sysoutLevelName = "INFO ";
            break;
        case BlancoLogMessageLevelStringGroup.CONF:
            logLevelName = "CONFIG";
            sysoutLevelName = "CONF ";
            break;
        case BlancoLogMessageLevelStringGroup.DEBUG:
            logLevelName = "FINE";
            sysoutLevelName = "DEBUG";
            break;
        case BlancoLogMessageLevelStringGroup.TRACE:
            logLevelName = "FINER";
            sysoutLevelName = "TRACE";
            break;
        }

        final StringBuffer buf = new StringBuffer();
        if (argProcessStructure.getIdEmbedding()) {
            // IDߍ
            buf.append(BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                    + "[" + fieldLook.getName() + "] " + logMessagePrefix
                    + BlancoCgLineUtil.getStringLiteralEnclosure(fTargetLang)
                    + " + ");
        } else {
            if (logMessagePrefix.length() > 0) {
                buf
                        .append(BlancoCgLineUtil
                                .getStringLiteralEnclosure(fTargetLang)
                                + logMessagePrefix
                                + BlancoCgLineUtil
                                        .getStringLiteralEnclosure(fTargetLang)
                                + " + ");
            }
        }
        buf.append("fBundle.get"
                + BlancoNameAdjuster.toClassName(fieldLook.getName()) + "(");
        for (int indexArg = 0; indexArg <= maxReplaceNumber; indexArg++) {
            if (indexArg != 0) {
                buf.append(", ");
            }
            buf.append("arg" + indexArg);
        }
        buf.append(")");
        bufLine.append(buf.toString());

        fCgSourceFile.getImportList().add("java.util.logging.Level");
        fCgSourceFile.getImportList().add("java.util.logging.Logger");

        if (argProcessStructure.getStdout()) {
            lineList.add("System.out.println(\"" + sysoutLevelName + ": \" + "
                    + bufLine.toString()
                    + (argThrowable ? " + \": \" + argThrown.toString()" : "")
                    + ")" + BlancoCgLineUtil.getTerminator(fTargetLang));
        }

        lineList.add("Logger.getLogger(\"" + argProcessStructure.getPackage()
                + "\").log(Level." + logLevelName + ", " + bufLine.toString()
                + (argThrowable ? ", argThrown" : "") + ")"
                + BlancoCgLineUtil.getTerminator(fTargetLang));
    }

    /**
     * vO~Oꏈnɍ String ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeString() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "java.lang.String";
        case BlancoCgSupportedLang.CS:
            return "string";
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "string";
        case BlancoCgSupportedLang.VB:
            return "String";
        }
    }

    /**
     * vO~Oꏈnɍ \bh̖Oό`Ȃ܂B
     * 
     * \bh̓ǂݑւB
     * 
     * @return
     */
    private final String getMethodName(final String argMethodName) {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return argMethodName;
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.VB:
            return BlancoNameAdjuster.toUpperCaseTitle(argMethodName);
        case BlancoCgSupportedLang.JS:
            return argMethodName;
        }
    }

    /**
     * JavȁꍇɃ\[XohNX𐶐܂B
     * 
     * @param argStructure
     * @param argDirectoryTarget
     */
    private void expandResourceBundleForJava(
            final BlancoLogMessageStructure argStructure,
            final File argDirectoryTarget) {
        final BlancoResourceBundleBundleStructure bundleStructure = new BlancoResourceBundleBundleStructure();
        bundleStructure.setName(BlancoNameAdjuster.toClassName(argStructure
                .getName())
                + argStructure.getSuffix());
        bundleStructure.setPackage(argStructure.getPackage());
        // NXpbP[WANZXɐ܂B
        bundleStructure.setAccess("");
        bundleStructure.setSuffix("ResourceBundle");
        bundleStructure.setDescription("bZ[W`[" + argStructure.getName()
                + "]Iɗp郊\[XohNXB");

        // TODO ftHgP[𗘗p邱ƂɂĂ܂B
        final Locale defalutLocale = Locale.getDefault();

        for (int index = 0; index < argStructure.getFieldList().size(); index++) {
            final BlancoLogMessageFieldStructure fieldStructure = (BlancoLogMessageFieldStructure) argStructure
                    .getFieldList().get(index);
            final BlancoResourceBundleBundleItemStructure item = new BlancoResourceBundleBundleItemStructure();
            item.setKey(fieldStructure.getName());
            final BlancoResourceBundleBundleResourceStringStructure resourceString = new BlancoResourceBundleBundleResourceStringStructure();
            resourceString.setResourceString(BlancoStringUtil
                    .null2Blank(fieldStructure.getMessage()));
            resourceString.setLocale(defalutLocale.getLanguage());
            item.getResourceStringList().add(resourceString);
            bundleStructure.getItemList().add(item);
        }

        new BlancoResourceBundleXml2JavaClass().structure2Source(
                bundleStructure, argDirectoryTarget);
    }
}
