/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.tmx.util.task;

import java.io.IOException;

import blanco.tmx.util.task.valueobject.BlancoTmxUtilConvertProcessInput;

/**
 * ob`NX [BlancoTmxUtilConvertBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.tmx.util.task.BlancoTmxUtilConvertBatchProcess -help
 * </code>
 */
public class BlancoTmxUtilConvertBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoTmxUtilConvertBatchProcess batchProcess = new BlancoTmxUtilConvertBatchProcess();

        // ob`̈B
        final BlancoTmxUtilConvertProcessInput input = new BlancoTmxUtilConvertProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourcedirProcessed = false;
        boolean isFieldTargetdirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcedir=")) {
                input.setSourcedir(arg.substring(11));
                isFieldSourcedirProcessed = true;
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
                isFieldTargetdirProcessed = true;
            } else if (arg.startsWith("-isindentxml=")) {
                input.setIsindentxml(Boolean.valueOf(arg.substring(13)).booleanValue());
            } else if (arg.startsWith("-encoding=")) {
                input.setEncoding(arg.substring(10));
            } else if (arg.startsWith("-adjustlang=")) {
                input.setAdjustlang(Boolean.valueOf(arg.substring(12)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoTmxUtilConvertBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourcedirProcessed == false) {
            System.out.println("BlancoTmxUtilConvertBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldTargetdirProcessed == false) {
            System.out.println("BlancoTmxUtilConvertBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoTmxUtilConvertProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoTmxUtilConvertProcessC^tF[X blanco.tmx.util.taskpbP[W BlancoTmxUtilConvertProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoTmxUtilConvertProcess process = new BlancoTmxUtilConvertProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoTmxUtilConvertProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoTmxUtilConvertBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoTmxUtilConvertBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoTmxUtilConvertBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoTmxUtilConvertBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoTmxUtilConvertBatchProcess: Usage:");
        System.out.println("  java blanco.tmx.util.task.BlancoTmxUtilConvertBatchProcess -verbose=l1 -sourcedir=l2 -targetdir=l3 -isindentxml=l4 -encoding=l5 -adjustlang=l6");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcedir");
        System.out.println("      [TMXt@Ci[Ă͐惋[gEtH_w肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetdir");
        System.out.println("      [TMXt@Ci[o͐惋[gEtH_w肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -isindentxml");
        System.out.println("      [XMLCfg邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -encoding");
        System.out.println("      [XMLGR[fBOB]");
        System.out.println("      ^[]");
        System.out.println("    -adjustlang");
        System.out.println("      [lang 𒲐邩ǂ? |uCł悤ɉHɂ͂ true ɃZbgB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoTmxUtilConvertProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourcedir() == null) {
            throw new IllegalArgumentException("BlancoTmxUtilConvertBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
        }
        if (input.getTargetdir() == null) {
            throw new IllegalArgumentException("BlancoTmxUtilConvertBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
        }
    }
}
