/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoTmxUtilStatistics]̃NX
 */
package blanco.tmx.util.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.tmx.util.task.valueobject.BlancoTmxUtilStatisticsProcessInput;

/**
 * Apache Ant^XN [BlancoTmxUtilStatistics]̃NXB
 *
 * [TMXΉc[] TMXt@C̓v\܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.tmx.util.task]BlancoTmxUtilStatisticsBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancotmxutilstatistics&quot; classname=&quot;blanco.tmx.util.task.BlancoTmxUtilStatisticsTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoTmxUtilStatisticsTask extends Task {
    /**
     * [TMXΉc[] TMXt@C̓v\܂B
     */
    protected BlancoTmxUtilStatisticsProcessInput fInput = new BlancoTmxUtilStatisticsProcessInput();

    /**
     * [TMXΉc[] TMXt@C̓v\܂B
     */
    protected boolean fIsFieldTmxdirProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[tmxdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * TMXt@Ci[Ă̓tH_w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmxdir(final String arg) {
        fInput.setTmxdir(arg);
        fIsFieldTmxdirProcessed = true;
    }

    /**
     * Ant^XN[tmxdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * TMXt@Ci[Ă̓tH_w肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmxdir() {
        return fInput.getTmxdir();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoTmxUtilStatisticsTask begin.");

        // ڔԍ[1]AAgr[g[tmxdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldTmxdirProcessed == false) {
            throw new BuildException("K{Agr[g[tmxdir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- tmxdir:[" + getTmxdir() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoTmxUtilStatisticsProcessC^tF[X blanco.tmx.util.taskpbP[W BlancoTmxUtilStatisticsProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoTmxUtilStatisticsProcess proc = new BlancoTmxUtilStatisticsProcessImpl();
            if (proc.execute(fInput) != BlancoTmxUtilStatisticsBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
