/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;
import java.io.IOException;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.manifest.BlancoManifestSerializer;
import blanco.manifest.valueobject.BlancoManifest;
import blanco.manifest.valueobject.BlancoManifestEntry;

/**
 * plugin.xmlt@CWJ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoEclipsePluginGenExpandManifest {
    private String fPluginName = null;

    private String fPluginDisplayName = null;

    private String fPackageName = null;

    /**
     * plugin.xmlt@CWJ܂B
     * 
     * @param elementCommon
     * @param listList
     * @param directoryRoot
     *            [gfBNgB̃fBNgplugin.xmlt@Co͂܂B
     */
    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryRoot) {
        fPluginName = BlancoXmlUtil.getTextContent(elementCommon, "name");
        fPluginDisplayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");
        fPackageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");

        // fBNg̎O`FbN쐬
        final File fileSourceRoot = new File(directoryRoot.getAbsolutePath()
                + "/src/" + BlancoStringUtil.replaceAll(fPackageName, ".", "/"));
        if (fileSourceRoot.exists() == false) {
            // fBNg݂Ȃꍇɂ͐VK쐬܂B
            System.out.println("ep: create: "
                    + fileSourceRoot.getAbsolutePath());
            fileSourceRoot.mkdirs();
        }
        final File fileSourceActions = new File(fileSourceRoot
                .getAbsolutePath()
                + "/actions");
        if (fileSourceActions.exists() == false) {
            System.out.println("ep: create: "
                    + fileSourceActions.getAbsolutePath());
            fileSourceActions.mkdirs();
        }
        final File fileSourceEditors = new File(fileSourceRoot
                .getAbsolutePath()
                + "/editors");
        if (fileSourceEditors.exists() == false) {
            System.out.println("ep: create: "
                    + fileSourceEditors.getAbsolutePath());
            fileSourceEditors.mkdirs();
        }
        final File fileSourceWizards = new File(fileSourceRoot
                .getAbsolutePath()
                + "/wizards");
        if (fileSourceWizards.exists() == false) {
            System.out.println("ep: create: "
                    + fileSourceWizards.getAbsolutePath());
            fileSourceWizards.mkdirs();
        }

        final File fileMetaInf = new File(directoryRoot.getAbsolutePath()
                + "/META-INF");
        if (fileMetaInf.exists() == false) {
            // fBNg݂Ȃꍇɂ͐VK쐬܂B
            System.out.println("ep: create: " + fileMetaInf.getAbsolutePath());
            fileMetaInf.mkdirs();
        }

        final File fileTarget = new File(directoryRoot.getAbsolutePath()
                + "/META-INF/MANIFEST.MF");
        if (fileTarget.exists()) {
            System.out.println("ep: skip  : MANIFEST.MF: file already exist.");
        } else {
            System.out.println("ep: create: MANIFEST.MF");
            try {
                expandManifestMf(fileTarget);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * MANIFEST.MFt@C𐶐܂B
     * 
     * @param fileTarget
     *            o͐t@CB
     * @throws IOException
     */
    private void expandManifestMf(final File fileTarget) throws IOException {
        final BlancoManifest manifest = new BlancoManifest();
        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-ManifestVersion");
            entry.getAttributeList().add("2");
        }
        {
            // |CgFoh vOC\̂擪啶܂B
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-Name");
            entry.getAttributeList().add(
                    BlancoNameAdjuster.toUpperCaseTitle(fPluginDisplayName)
                            + " Plug-in");
        }

        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-SymbolicName");
            entry.getAttributeList().add(fPackageName + ";singleton:=true");
        }

        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-Version");
            entry.getAttributeList().add("0.0.1");
        }

        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-Activator");
            entry.getAttributeList().add(
                    fPackageName + "." + fPluginName + "Plugin");
        }
        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Require-Bundle");
            entry.getAttributeList().add("org.eclipse.ui");
            entry.getAttributeList().add("org.eclipse.core.runtime");
            entry.getAttributeList().add("org.eclipse.jface.text");
            entry.getAttributeList().add("org.eclipse.ui.editors");
            entry.getAttributeList().add("org.eclipse.ui.workbench.texteditor");
            entry.getAttributeList().add("org.eclipse.core.resources");
            entry.getAttributeList().add("org.eclipse.ui.ide");
        }
        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-ActivationPolicy");
            entry.getAttributeList().add("lazy");
        }
        {
            // o[WΉ
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Eclipse-LazyStart");
            entry.getAttributeList().add("true");
        }
        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-RequiredExecutionEnvironment");
            entry.getAttributeList().add("J2SE-1.5");
        }

        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-ClassPath");
            entry.getAttributeList().add(
                    "lib/" + fPluginName.toLowerCase() + "plugin.jar");

            final File file = new File("lib");
            final File[] files = file.listFiles();
            for (int index = 0; index < files.length; index++) {
                File look = files[index];
                if (look.isFile() == false) {
                    continue;
                }
                if (look.getName().endsWith(".jar")) {
                    entry.getAttributeList().add("lib/" + look.getName());
                }
            }

        }
        {
            final BlancoManifestEntry entry = new BlancoManifestEntry();
            manifest.getEntryList().add(entry);
            entry.setName("Bundle-Vendor");
            entry.getAttributeList().add("Blanco Framework");
        }

        new BlancoManifestSerializer().serialize(manifest, fileTarget);
    }
}
