/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.manifest;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import blanco.manifest.valueobject.BlancoManifest;
import blanco.manifest.valueobject.BlancoManifestEntry;

/**
 * MANIFEST.MF VACYNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoManifestSerializer {

    public BlancoManifestSerializer() {
    }

    /**
     * MANIFESTXg[ɏo͂܂B
     * 
     * @param argManifest
     * @param outStream
     * @throws IOException
     */
    public void serialize(final BlancoManifest argManifest,
            final OutputStream outStream) throws IOException {
        serializeInternal(argManifest, outStream);
    }

    /**
     * MANIFESTt@Cɏo͂܂B
     * 
     * @param argManifest
     * @param argFileTarget
     * @throws IOException
     */
    public void serialize(final BlancoManifest argManifest,
            final File argFileTarget) throws IOException {
        final OutputStream outStream = new FileOutputStream(argFileTarget);
        try {
            serializeInternal(argManifest, outStream);
        } finally {
            outStream.flush();
            outStream.close();
        }
    }

    private void serializeInternal(final BlancoManifest argManifest,
            final OutputStream outStream) throws IOException {
        final BufferedWriter writer = new BufferedWriter(
                new OutputStreamWriter(outStream));
        try {
            writer.write("Manifest-Version: "
                    + argManifest.getManifestVersion());
            writer.newLine();

            for (BlancoManifestEntry entry : argManifest.getEntryList()) {
                switch (entry.getAttributeList().size()) {
                case 0:
                    // 0̂Ƃ͍܂B
                    writer.write(entry.getName() + ": " + "(not defined)");
                    writer.newLine();
                    break;
                case 1:
                    writer.write(entry.getName() + ": "
                            + entry.getAttributeList().get(0));
                    writer.newLine();
                    break;
                default:
                    writer.write(entry.getName() + ": "
                            + entry.getAttributeList().get(0) + ",");
                    writer.newLine();
                    for (int index = 1; index < entry.getAttributeList().size() - 1; index++) {
                        writer.write(" " + entry.getAttributeList().get(index)
                                + ",");
                        writer.newLine();
                    }
                    // Ō̃Ggɂ̓J}͕t܂B
                    writer.write(" "
                            + entry.getAttributeList().get(
                                    entry.getAttributeList().size() - 1));
                    writer.newLine();
                    break;
                }
            }
        } finally {
            writer.close();
        }
    }
}
