/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoJavaSourceUtil;

/**
 * blancoValueObjectIɗp郆[eBeBNXB
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectUtil {
    /**
     * stŁA^ꂽJavaDocƂăGXP[v܂B
     * 
     * @param argString
     *            GXP[vsB
     * @return GXP[vꂽƂ̕
     */
    public static final String[] escapeStringAsJavaDocWithNewLine(
            final String argString) {
        final List<java.lang.String> result = new ArrayList<java.lang.String>();
        try {
            final BufferedReader reader = new BufferedReader(new StringReader(
                    argString));
            try {
                for (;;) {
                    final String readLine = reader.readLine();
                    if (readLine == null) {
                        break;
                    }
                    result.add(BlancoJavaSourceUtil
                            .escapeStringAsJavaDoc(readLine));
                }
            } finally {
                reader.close();
            }
        } catch (IOException e) {
            throw new IllegalArgumentException("肦Ȃo͗O܂B"
                    + e.toString());
        }

        // ArrayListz񉻂܂B
        final String[] returnValue = new String[result.size()];
        result.toArray(returnValue);
        for (int index = 0; index < returnValue.length; index++) {
            String readLine = returnValue[index];
            if (index < returnValue.length - 1) {
                // Ō̍sȊO st^܂B
                readLine += "\n";
            }
            // 񒆂ׂ̂Ẳs GXP[v܂B
            readLine = readLine.replaceAll("\n", "<br>");
            returnValue[index] = readLine;
        }
        return returnValue;
    }
}
