/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ibatis.task;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.util.BlancoDbMappingUtilJava;
import blanco.dbmetadata.BlancoDbMetaDataSql;
import blanco.dbmetadata.BlancoDbMetaDataUtil;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;
import blanco.ibatis.message.BlancoIBatisMessage;
import blanco.ibatis.task.valueobject.BlancoIBatisSqlMap2RowProcessInput;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

import com.ibatis.common.beans.ProbeException;
import com.ibatis.common.xml.NodeletException;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.StatementType;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;

/**
 * iBatis  sqlMap t@CAʂ̍s\o[IuWFNg܂B
 * 
 * SELECT ݂̂ΏۂƂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoIBatisSqlMap2RowProcessImpl implements
        BlancoIBatisSqlMap2RowProcess {
    protected BlancoIBatisMessage fMsg = new BlancoIBatisMessage();

    protected BlancoIBatisSqlMap2RowProcessInput fInput = null;

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     * 
     * @param input
     *            ̓̓p[^B
     * @return ̎sʁB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(final BlancoIBatisSqlMap2RowProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        if (new File(fInput.getSourcedir()).exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbibri01(fInput
                    .getSourcedir()));
        }
        if (new File(fInput.getSourcedir()).isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbibri02(fInput
                    .getSourcedir()));
        }

        Connection conn = null;
        try {
            conn = BlancoDbMetaDataUtil.connect(fInput.getJdbcdriver(), fInput
                    .getJdbcurl(), fInput.getJdbcuser(), fInput
                    .getJdbcpassword());
        } catch (IllegalArgumentException ex) {
            System.out.println(fMsg.getMbibrp01(ex.toString()));
            return BlancoIBatisSqlMap2RowBatchProcess.END_ERROR;
        }

        try {
            processSqlMapDir(conn, new File(fInput.getSourcedir()));
        } finally {
            try {
                conn.rollback();
                conn.close();
            } catch (SQLException e) {
                // ͊{Iɂ͂肦Ȃ͂B
                e.printStackTrace();
            }
        }

        return 0;
    }

    /**
     * sqlMap i[ĂfBNĝׂĂ xml t@C܂B
     * 
     * @param conn
     *            f[^x[XڑB
     * @param sourceDir
     *            ̓fBNgB
     * @throws IOException
     */
    public void processSqlMapDir(final Connection conn, final File sourceDir)
            throws IOException {
        final File[] files = sourceDir.listFiles();
        if (files == null) {
            return;
        }
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                continue;
            }
            if (files[index].getName().endsWith(".xml") == false) {
                continue;
            }

            try {
                processSqlMap(conn, files[index]);
            } catch (NodeletException e) {
                System.out.println(fMsg.getMbibrp02(files[index].getName(), e
                        .toString()));
                if (fInput.getVerbose()) {
                    e.printStackTrace();
                }
                continue;
            }
        }
    }

    /**
     * sqlMap t@C s킷o[IuWFNg𐶐܂B
     * 
     * @param conn
     *            f[^x[XڑB
     * @param fileSqlMap
     *            sqlMap ̃t@CB
     * @throws IOException
     *             o͗OꍇB
     * @throws NodeletException
     * @throws SQLException
     *             SQLOꍇB
     */
    @SuppressWarnings("unchecked")
    public void processSqlMap(final Connection conn, final File fileSqlMap)
            throws IOException, NodeletException {
        final XmlParserState parserState = new XmlParserState();

        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(fileSqlMap));
        try {
            final SqlMapParser parser = new SqlMapParser(parserState);
            parser.parse(inStream);
        } finally {
            inStream.close();
        }

        for (Iterator<String> iteSqlMapId = parserState.getConfig()
                .getDelegate().getMappedStatementNames(); iteSqlMapId.hasNext();) {
            final MappedStatement mStmt = parserState.getConfig().getDelegate()
                    .getMappedStatement(iteSqlMapId.next());

            if (mStmt.getStatementType() != StatementType.SELECT) {
                // SELECTȊO͏܂B
                continue;
            }

            try {
                processSqlMapEntry(conn, mStmt);
            } catch (SQLException e) {
                System.out.println(fMsg.getMbibrp03(fileSqlMap.getName(), mStmt
                        .getId(), e.toString()));
                if (fInput.getVerbose()) {
                    e.printStackTrace();
                }
                continue;
            } catch (ProbeException e) {
                System.out.println(fMsg.getMbibrp04(fileSqlMap.getName(), mStmt
                        .getId(), e.toString()));
                if (fInput.getVerbose()) {
                    e.printStackTrace();
                }
                continue;
            }
        }
    }

    protected void processSqlMapEntry(final Connection conn,
            final MappedStatement mStmt) throws SQLException, IOException {
        if (false) {
            // TODO ̃\bh瓮ISQL̃p[^擾łΗǂ̂A͂܂ȂB
            // TODO ݂ iBatis ł́AvOsɌĂяoŗ^ꂽp[^̗pOƂȂĂ܂Ă͗lB
            final ParameterMapping[] mappings = mStmt.getParameterMap()
                    .getParameterMappings();
            if (mappings != null) {
                for (int index = 0; index < mappings.length; index++) {
                    System.out.println("  trace: param: "
                            + mappings[index].getPropertyName());
                }
            }
        }

        // SQL擾B
        final String sql = mStmt.getSql().getSql(
                new StatementScope(new SessionScope()), null);

        List<BlancoDbMetaDataColumnStructure> columnList = null;

        if (fInput.getIsbindparameter() == false) {
            // p[^oChɐB
            columnList = BlancoDbMetaDataSql.getResultSetMetaData(conn, sql);
        } else {
            // p[^g͂sǂɂĂ͔B
            final List<BlancoDbMetaDataColumnStructure> paramList = new ArrayList<BlancoDbMetaDataColumnStructure>();

            int replaceCount = 0;
            for (int index = 0; index < sql.length(); index++) {
                // TODO SQL " GXP[v Rg̍lĂ܂B
                if (sql.charAt(index) == '?') {
                    replaceCount++;
                    final BlancoDbMetaDataColumnStructure param = new BlancoDbMetaDataColumnStructure();
                    paramList.add(param);
                    // Ƃ肠ƂƂɂăZbgB
                    param.setDataType(java.sql.Types.CHAR);
                }
            }

            columnList = BlancoDbMetaDataSql.getResultSetMetaData(conn, sql,
                    paramList);
        }

        columnList2RowValueObject(mStmt, columnList);
    }

    /**
     * 񃊃Xg s\o[IuWFNg𐶐܂B
     * 
     * @param mStmt
     * @param columnList
     * @throws IOException
     */
    protected void columnList2RowValueObject(final MappedStatement mStmt,
            final List<BlancoDbMetaDataColumnStructure> columnList)
            throws IOException {
        final BlancoValueObjectClassStructure rowValueObject = new BlancoValueObjectClassStructure();
        // blancoDb̃TtBbNXE[ɍ킹āAt@Cɂ Row t^܂B
        rowValueObject.setName(BlancoNameAdjuster.toClassName(mStmt.getId())
                + "Row");
        // pbP[W͊O^ĂB
        rowValueObject.setPackage(fInput.getPackage());
        rowValueObject.setDescription("sqlMap id [" + mStmt.getId()
                + "] ̌ʂ̍sIuWFNgB");
        rowValueObject.getDescriptionList().add("<P>sqlMap.xml ւ̋LqB</P>");
        rowValueObject.getDescriptionList().add("<UL>");
        rowValueObject.getDescriptionList().add(
                "<LI>&lt;select id=\"" + mStmt.getId() + "\" resultClass=\""
                        + fInput.getPackage() + "."
                        + BlancoNameAdjuster.toClassName(mStmt.getId()) + "Row"
                        + "\" ...");
        rowValueObject.getDescriptionList().add("</UL>");

        for (BlancoDbMetaDataColumnStructure column : columnList) {
            final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
            rowValueObject.getFieldList().add(field);

            field.setName(column.getName());
            field.setType(BlancoDbMappingUtilJava.getFullClassName(column));
            field.setDescription("SQLʂ̗: [" + column.getName() + "]B");
            if (BlancoStringUtil.null2Blank(column.getTypeName()).length() > 0) {
                field.getDescriptionList().add(
                        "TYPE_NAME: [" + column.getTypeName() + "]B");
            }
            if (BlancoStringUtil.null2Blank(column.getDataTypeDisplayName())
                    .length() > 0) {
                field.getDescriptionList().add(
                        "DATA_TYPE_DISPLAY_NAME: ["
                                + column.getDataTypeDisplayName() + "]B");
            }
            if (column.getColumnSize() > 0) {
                field.getDescriptionList().add(
                        "TCY: [" + column.getColumnSize() + "]B");
            }
            if (column.getNullable() == ResultSetMetaData.columnNoNulls) {
                field.getDescriptionList().add("NULL: [NoNulls]B");
            } else if (column.getNullable() == ResultSetMetaData.columnNullable) {
                field.getDescriptionList().add("NULL: [Nullable]B");
            }
        }

        final BlancoValueObjectXml2JavaClass xml2source = new BlancoValueObjectXml2JavaClass();
        xml2source.setEncoding(fInput.getEncoding());
        xml2source.structure2Source(rowValueObject, new File(fInput
                .getTargetdir()));
    }
}
