package blanco.html.normalizer.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;

import blanco.html.normalizer.parser.valueobject.BlancoHtmlEvent;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventCharacters;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventComments;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndElement;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartElement;
import blanco.html.parser.BlancoHtmlContentSerializer;

public class BlancoHtmlEventListSerializer {
    public void serialize(final List<BlancoHtmlEvent> eventList,
            final BufferedWriter writer) throws IOException {
        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        serializer.setWriter(writer);

        for (BlancoHtmlEvent look : eventList) {
            if (look instanceof BlancoHtmlEventStartDocument) {
                serializer.startDocument();
            } else if (look instanceof BlancoHtmlEventEndDocument) {
                serializer.endDocument();
            } else if (look instanceof BlancoHtmlEventStartElement) {
                final BlancoHtmlEventStartElement event = (BlancoHtmlEventStartElement) look;
                serializer.startElement(event.getName(), event.getAttrs());
            } else if (look instanceof BlancoHtmlEventEndElement) {
                final BlancoHtmlEventEndElement event = (BlancoHtmlEventEndElement) look;
                serializer.endElement(event.getName());
            } else if (look instanceof BlancoHtmlEventCharacters) {
                final BlancoHtmlEventCharacters event = (BlancoHtmlEventCharacters) look;
                serializer.characters(event.getCharacters());
            } else if (look instanceof BlancoHtmlEventComments) {
                final BlancoHtmlEventComments event = (BlancoHtmlEventComments) look;
                serializer.comments(event.getComments(), event.getType());
            } else {
                System.out.println("s?: " + look.toString());
            }
        }

        serializer.getWriter().flush();
    }
}
