/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.html.normalizer.task;

import java.io.IOException;

import blanco.html.normalizer.task.valueobject.BlancoHtmlNormalizeQuoteProcessInput;

/**
 * ob`NX [BlancoHtmlNormalizeQuoteBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.html.normalizer.task.BlancoHtmlNormalizeQuoteBatchProcess -help
 * </code>
 */
public class BlancoHtmlNormalizeQuoteBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoHtmlNormalizeQuoteBatchProcess batchProcess = new BlancoHtmlNormalizeQuoteBatchProcess();

        // ob`̈B
        final BlancoHtmlNormalizeQuoteProcessInput input = new BlancoHtmlNormalizeQuoteProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourcedirProcessed = false;
        boolean isFieldTargetdirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcedir=")) {
                input.setSourcedir(arg.substring(11));
                isFieldSourcedirProcessed = true;
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
                isFieldTargetdirProcessed = true;
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourcedirProcessed == false) {
            System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldTargetdirProcessed == false) {
            System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoHtmlNormalizeQuoteProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoHtmlNormalizeQuoteProcessC^tF[X blanco.html.normalizer.taskpbP[W BlancoHtmlNormalizeQuoteProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoHtmlNormalizeQuoteProcess process = new BlancoHtmlNormalizeQuoteProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoHtmlNormalizeQuoteProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoHtmlNormalizeQuoteBatchProcess: Usage:");
        System.out.println("  java blanco.html.normalizer.task.BlancoHtmlNormalizeQuoteBatchProcess -verbose=l1 -sourcedir=l2 -targetdir=l3");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcedir");
        System.out.println("      [HTMLt@Ci[Ă̓fBNgB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetdir");
        System.out.println("      [normalize ꂽHTMLt@Ci[o̓fBNgB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoHtmlNormalizeQuoteProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourcedir() == null) {
            throw new IllegalArgumentException("BlancoHtmlNormalizeQuoteBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
        }
        if (input.getTargetdir() == null) {
            throw new IllegalArgumentException("BlancoHtmlNormalizeQuoteBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetdir]ɒlݒ肳Ă܂B");
        }
    }
}
