package blanco.html.normalizer.util;

import java.util.ArrayList;
import java.util.List;

import blanco.html.normalizer.parser.valueobject.BlancoHtmlEvent;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventCharacters;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventComments;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventEndElement;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartDocument;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEventStartElement;
import blanco.html.normalizer.spec.BlancoHtmlElementSpecUtil;
import blanco.html.normalizer.spec.stringgroup.BlancoHtmlElementSpecTypeStringGroup;
import blanco.html.normalizer.spec.valueobject.BlancoHtmlElementSpec;

public class BlancoHtmlNormalizerUtil {
    /**
     * vfXg𒲐B
     * 
     * ^ÕyA`FbNB⊮B deapth̎{B
     * 
     * @param eventList
     */
    public static final List<BlancoHtmlEvent> adjust(
            final List<BlancoHtmlEvent> argOriginalEventList) {
        final List<BlancoHtmlEvent> eventList = new ArrayList<BlancoHtmlEvent>();
        for (BlancoHtmlEvent event : argOriginalEventList) {
            eventList.add(event);
        }

        int deapth = -1;

        for (BlancoHtmlEvent look : eventList) {
            if (look instanceof BlancoHtmlEventStartDocument) {
                final BlancoHtmlEventStartDocument event = (BlancoHtmlEventStartDocument) look;
                event.setDeapth(deapth);
            } else if (look instanceof BlancoHtmlEventEndDocument) {
                final BlancoHtmlEventEndDocument event = (BlancoHtmlEventEndDocument) look;
                event.setDeapth(deapth);
            } else if (look instanceof BlancoHtmlEventStartElement) {
                // OB
                // TODO lXgłȂJn^OJςȂɂȂĂȂǂ`FbNB
                // JςȂA܂ɕ܂B

                // ^ɑ₵܂B
                deapth++;

                final BlancoHtmlEventStartElement event = (BlancoHtmlEventStartElement) look;
                event.setDeapth(deapth);

                if (event.getName().startsWith("!")
                        || event.getName().startsWith("?")) {
                    // !DOCTYPE ȂǂɑƔfB
                    deapth--;
                } else {
                    final List<BlancoHtmlElementSpec> specs = BlancoHtmlElementSpecUtil
                            .getSpecListInstance();
                    for (BlancoHtmlElementSpec spec : specs) {
                        if (event.getName().toUpperCase().equals(
                                spec.getName().toUpperCase())) {
                            if (spec.getEmpty() == BlancoHtmlElementSpecTypeStringGroup.EMPTY) {
                                // ^OɂẮAL킳炵܂B
                                // |Cg: Ƒ΂ɂɂȂ鏈ƂāA֎~^O͍폜tO𗧂Ă܂B
                                deapth--;
                            }
                        }
                    }
                }
            } else if (look instanceof BlancoHtmlEventEndElement) {

                // TODO ̃^OɕȂĂ͂ȂȂI^OǂO`FbNB
                // ΂ɂȂĂȂ^OΕȂĂ͂ȂȂB

                // TODO ΉtJn^O邩ǂT[`B΁Ã^OA݂Ă͂ȂȂ̂B

                final BlancoHtmlEventEndElement event = (BlancoHtmlEventEndElement) look;
                event.setDeapth(deapth);

                final List<BlancoHtmlElementSpec> specs = BlancoHtmlElementSpecUtil
                        .getSpecListInstance();
                for (BlancoHtmlElementSpec spec : specs) {
                    if (event.getName().toUpperCase().equals(
                            spec.getName().toUpperCase())) {
                        if (spec.getEndTag() == BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN) {
                            // ݂͑Ă͂ȂȂI^OłB
                            // tOZbg܂B
                            event.setIsRemoved(true);
                        }
                    }
                }

                if (event.getIsRemoved()) {
                    // āAłɑ݂Ȃ^OȂ̂ŁA[vZɂ͊֌W܂B
                } else {
                    // ԍŌɌ炵܂B
                    deapth--;
                }
            } else if (look instanceof BlancoHtmlEventCharacters) {
                final BlancoHtmlEventCharacters event = (BlancoHtmlEventCharacters) look;
                event.setDeapth(deapth);
            } else if (look instanceof BlancoHtmlEventComments) {
                final BlancoHtmlEventComments event = (BlancoHtmlEventComments) look;
                event.setDeapth(deapth);
            }
        }

        return eventList;
    }
}
