/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.formatter.task;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;

import blanco.commons.util.BlancoFileUtil;
import blanco.html.formatter.message.BlancoHtmlFormatterMessage;
import blanco.html.formatter.task.valueobject.BlancoHtmlFormatterProcessInput;
import blanco.html.formatter.util.BlancoHtmlFormatterUtil;
import blanco.html.normalizer.parser.BlancoHtmlEventListSerializer;
import blanco.html.normalizer.parser.helper.BlancoHtmlEventParserContentHandler;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEvent;
import blanco.html.normalizer.util.BlancoHtmlNormalizerUtil;
import blanco.html.parser.BlancoHtmlParser;
import blanco.html.parser.BlancoHtmlParserFactory;

public class BlancoHtmlFormatterProcessImpl implements
        BlancoHtmlFormatterProcess {
    protected BlancoHtmlFormatterProcessInput fInput;

    protected BlancoHtmlFormatterMessage fMsg = new BlancoHtmlFormatterMessage();

    public int execute(final BlancoHtmlFormatterProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File sourceDir = new File(fInput.getSourcedir());
        final File targetDir = new File(fInput.getTargetdir());

        if (sourceDir.exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbhtfi01(fInput
                    .getSourcedir()));
        }
        if (sourceDir.isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbhtfi02(fInput
                    .getSourcedir()));
        }
        if (targetDir.exists() == false) {
            if (targetDir.mkdirs() == false) {
                throw new IllegalArgumentException(fMsg.getMbhtfi03(fInput
                        .getTargetdir()));
            }
        } else if (targetDir.isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbhtfi04(fInput
                    .getTargetdir()));
        }
        if (sourceDir.getCanonicalPath().equals(targetDir.getCanonicalPath())) {
            throw new IllegalArgumentException(fMsg.getMbhtfi05(fInput
                    .getSourcedir(), fInput.getTargetdir()));
        }

        process();

        return 0;
    }

    protected void process() throws IOException {
        final File sourceDir = new File(fInput.getSourcedir());
        final File targetDir = new File(fInput.getTargetdir());

        final File[] files = sourceDir.listFiles();
        if (files == null) {
            return;
        }
        for (final File file : files) {
            if (file.isFile() == false) {
                continue;
            }

            final BlancoHtmlEventParserContentHandler handler = new BlancoHtmlEventParserContentHandler();

            final BlancoHtmlParser parser = BlancoHtmlParserFactory
                    .getInstance();
            parser.setHandler(handler);

            final File targetFile = new File(targetDir.getAbsolutePath() + "/"
                    + file.getName());

            final byte[] fileData = BlancoFileUtil.file2Bytes(file);
            parser.parse(fileData);

            List<BlancoHtmlEvent> eventList = handler.getEventList();
            eventList = BlancoHtmlNormalizerUtil.adjust(eventList);
            eventList = BlancoHtmlFormatterUtil.trimWhiteSpaces(eventList);
            eventList = BlancoHtmlFormatterUtil.format(eventList);

            new BlancoHtmlEventListSerializer().serialize(eventList,
                    new BufferedWriter(new OutputStreamWriter(
                            new FileOutputStream(targetFile), parser
                                    .getEncoding())));
        }
    }
}
