/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

import blanco.commons.util.BlancoStringUtil;

/**
 * Native2AsciiC^[
 * 
 * java.util.Properties̗͂g Native2Asciis܂B
 * 
 * @author IGA Tosiki
 * @see java.util.Properties#load(java.io.InputStream)
 */
public class Native2AsciiWriter {
    private BufferedWriter fWriter;

    /**
     * {Iɂ́A8859_1GR[h̃C^[nĂB
     * 
     * @param writer
     *            o͐惉C^[B
     */
    public Native2AsciiWriter(final BufferedWriter writer) {
        this.fWriter = writer;
    }

    /**
     * C^[tbV܂B
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void flush() throws IOException {
        fWriter.flush();
    }

    /**
     * C^[N[Y܂B
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void close() throws IOException {
        fWriter.close();
    }

    /**
     * C^[ɃRgo͂܂B<br>
     * Xy[X~ꍇɂ́A^镶̐擪ɃXy[XĂB
     * 
     * @param comment
     * @throws IOException
     */
    public void writeComment(final String comment) throws IOException {
        fWriter.write("#" + encodeNative2AsciiComment(comment));
        fWriter.newLine();
    }

    /**
     * C^[ɃvpeBo͂܂B
     * 
     * @param key
     *            L[B
     * @param value
     *            lB
     * @throws IOException
     *             o͗OꍇB
     */
    public void writeProperty(final String key, final String value)
            throws IOException {
        fWriter.write(encodeNative2AsciiKey(key));
        fWriter.write("=");
        fWriter.write(encodeNative2AsciiValue(value));
        fWriter.newLine();
    }

    /**
     * ^ꂽlCeBuzvpeBt@Cbytezɕϊ܂B
     * 
     * @param nativeString
     *            lCeBuB
     * @return oCgzB
     * @throws IOException
     *             o͗OꍇB
     */
    private static final byte[] encodeNative2AsciiKeyByteArray(
            final String nativeString) throws IOException {
        final Properties prop = new Properties();
        prop.setProperty(nativeString, "value");
        final ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            prop.store(byteOutStream, "dummy");
            byteOutStream.flush();
        } finally {
            byteOutStream.close();
        }
        return byteOutStream.toByteArray();
    }

    /**
     * ^ꂽlCeBuzvpeBt@Cbytezɕϊ܂B
     * 
     * @param nativeString
     *            ϊƂ̕B
     * @return ϊ̃oCgzB
     * @throws IOException
     *             o͗OꍇB
     */
    private static final byte[] encodeNative2AsciiValueByteArray(
            final String nativeString) throws IOException {
        final Properties prop = new Properties();
        prop.setProperty("key", nativeString);
        final ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            prop.store(byteOutStream, "dummy");
            byteOutStream.flush();
        } finally {
            byteOutStream.close();
        }
        return byteOutStream.toByteArray();
    }

    /**
     * native2asciis܂B
     * 
     * ڂ
     * http://java.sun.com/j2se/1.4/ja/docs/ja/api/java/util/Properties.html
     * #load(java.io.InputStream) QƂB
     * 
     * @param nativeString
     *            ϊƂ̕B
     * @return ϊ̕B
     * @see java.util.Properties#load(java.io.InputStream)
     */
    public static final String encodeNative2AsciiKey(final String nativeString) {
        try {
            final BufferedReader reader = new BufferedReader(
                    new InputStreamReader(new ByteArrayInputStream(
                            encodeNative2AsciiKeyByteArray(nativeString)),
                            "8859_1"));
            for (;;) {
                final String look = reader.readLine();
                if (look == null) {
                    throw new IllegalArgumentException(
                            "encodeNative2Ascii("
                                    + nativeString
                                    + ")̏̉ߒɂāAԃt@C̗\ʏI[܂B̃P[X͂肦܂B");
                }
                if (look.startsWith("#")) {
                    // Rgs͓ǂݔ΂܂B
                    continue;
                }
                reader.close();
                if (look.endsWith("=value")) {
                    return look.substring(0, look.lastIndexOf("=value"));
                }
                throw new IllegalArgumentException("encodeNative2AsciiKey("
                        + nativeString + ")̏̉ߒɂāAԃt@C̓ǂݍ݂̌ʁA\ʍs["
                        + look + "]߂܂B̃P[X͂肦܂B");
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException("encodeNative2Ascii("
                    + nativeString + ")̏̉ߒɂāA\ʗO܂B̃P[X͂肦܂B:"
                    + ex.toString());
        }
    }

    /**
     * native2asciis܂B
     * 
     * ڂ
     * http://java.sun.com/j2se/1.4/ja/docs/ja/api/java/util/Properties.html
     * #load(java.io.InputStream) QƂĂB
     * 
     * @param nativeString
     *            ϊƂ̕B
     * @return ϊ̕B
     * @see java.util.Properties#load(java.io.InputStream)
     */
    public static final String encodeNative2AsciiValue(final String nativeString) {
        try {
            final BufferedReader reader = new BufferedReader(
                    new InputStreamReader(new ByteArrayInputStream(
                            encodeNative2AsciiValueByteArray(nativeString)),
                            "8859_1"));
            for (;;) {
                final String look = reader.readLine();
                if (look == null) {
                    throw new IllegalArgumentException(
                            "encodeNative2Ascii("
                                    + nativeString
                                    + ")̏̉ߒɂāAԃt@C̗\ʏI[܂B̃P[X͂肦܂B");
                }
                if (look.startsWith("#")) {
                    // Rgs͓ǂݔ΂܂B
                    continue;
                }
                reader.close();
                if (look.startsWith("key=")) {
                    return look.substring("key=".length());
                }
                throw new IllegalArgumentException("encodeNative2Ascii("
                        + nativeString + ")̏̉ߒɂāAԃt@C̓ǂݍ݂̌ʁA\ʍs["
                        + look + "]߂܂B̃P[X͂肦܂B");
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException("encodeNative2Ascii("
                    + nativeString + ")̏̉ߒɂāA\ʗO܂B̃P[X͂肦܂B:"
                    + ex.toString());
        }
    }

    /**
     * ^ꂽ񂪃Rgł̂ƂNative2Asciis܂B
     * 
     * @param nativeString
     *            ϊsΏۂ̕B
     * @return asciiRgƂĕϊ̕B
     */
    public static final String encodeNative2AsciiComment(
            final String nativeString) {
        final StringReader reader = new StringReader(nativeString);
        final StringWriter writer = new StringWriter();
        try {
            for (;;) {
                final int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                if ((iRead < 0x0020) || (iRead > 0x007E)) {
                    // ̂ \u007E傫̂
                    // \\uxxxx̂悤16i\s܂B
                    writer.write(toHexString((char) iRead));
                } else {
                    // Â܂܏o܂B
                    writer.write((char) iRead);
                }
            }
            writer.flush();
            return writer.toString();
        } catch (IOException e) {
            // ܂͂肦܂B
            e.printStackTrace();
            return null;
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    // ܂͂肦܂B
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /**
     * ^ꂽcharUnicode\Lɕϊ܂B<br>
     * native2ascii.exe̎dlƂ͈قȂ܂Ajava.util.Properties̎dlɏ]A啶ɕϊ܂B<br>
     * ̃[`́ANative2AsciiWriter̃RgGR[hɗp܂B
     * 
     * @param arg
     *            HEX\LȂB
     * @return HEX\Lɕϊ̕B
     */
    private static final String toHexString(final char arg) {
        return "\\u" + BlancoStringUtil.toHexString(arg).toUpperCase();
    }
}
