/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.charactergroup;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.charactergroup.message.BlancoCharacterGroupMessage;
import blanco.charactergroup.resourcebundle.BlancoCharacterGroupResourceBundle;
import blanco.charactergroup.valueobject.BlancoCharacterGroupFieldStructure;
import blanco.charactergroup.valueobject.BlancoCharacterGroupStructure;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uO[v`vExcell當O[vNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCharacterGroupXml2SourceFile {
    /**
     * bZ[WB
     */
    private final BlancoCharacterGroupMessage fMsg = new BlancoCharacterGroupMessage();

    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoCharacterGroupResourceBundle fBundle = new BlancoCharacterGroupResourceBundle();

    /**
     * o͑ΏۂƂȂvO~OB
     */
    private int fTargetLang = BlancoCgSupportedLang.NOT_DEFINED;

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argTargetLang, final File argDirectoryTarget)
            throws IOException {

        fTargetLang = new BlancoCgSupportedLang().convertToInt(argTargetLang);
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            break;
        default:
            throw new IllegalArgumentException(fMsg.getMbchgi02(argTargetLang));
        }

        // ^͂ăo[IuWFNg̃c[擾܂B
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        final BlancoCharacterGroupStructure[] structures = new BlancoCharacterGroupXmlParser()
                .parse(argMetaXmlSourceFile);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Source(structures[index], argDirectoryTarget);
        }
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void structure2Source(
            final BlancoCharacterGroupStructure argProcessStructure,
            final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(argProcessStructure.getName()
                + BlancoStringUtil.null2Blank(argProcessStructure.getSuffix()),
                BlancoStringUtil.null2Blank(argProcessStructure
                        .getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            expandMethodInit(argProcessStructure);
            break;
        }
        expandMethodMatch(argProcessStructure);
        expandMethodMatchAll(argProcessStructure);
        expandMethodMatchAny(argProcessStructure);

        BlancoCgTransformerFactory.getSourceTransformer(fTargetLang).transform(
                fCgSourceFile, fileBlancoMain);
    }

    private void expandMethodInit(
            BlancoCharacterGroupStructure argProcessStructure) {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("__init__"), "NX\bh");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("encoding='cp932'", getTypeChar(),
                        "GR[fBOBftHg'cp932'"));

        final List<java.lang.String> lineList = cgMethod.getLineList();
        lineList.add("self.encoding = encoding");
    }

    /**
     * match\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodMatch(
            final BlancoCharacterGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("match"), "O[vɊ܂܂镶ł邩ǂ𔻒肵܂B");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeChar(),
                        "`FbNsB"));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeBoolean(),
                "O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB"));

        final List<java.lang.String> lineList = cgMethod.getLineList();

        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add("argCheckUnicode = unicode(argCheck, self.encoding)");
            break;
        }

        for (int indexField = 0; indexField < argProcessStructure
                .getFieldList().size(); indexField++) {
            final BlancoCharacterGroupFieldStructure fieldLook = (BlancoCharacterGroupFieldStructure) argProcessStructure
                    .getFieldList().get(indexField);

            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo()));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(fTargetLang)
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription()));
            }

            // R[h̃_vo͂܂B
            try {
                lineList
                        .add(BlancoCgLineUtil
                                .getSingleLineCommentPrefix(fTargetLang)
                                + fBundle
                                        .getXml2sourceFileDumpEncodingMsg(
                                                BlancoStringUtil
                                                        .toHexString(fieldLook
                                                                .getValue()
                                                                .getBytes(
                                                                        fBundle
                                                                                .getXml2sourceFileDumpEncoding())),
                                                fBundle
                                                        .getXml2sourceFileDumpEncoding()));
                lineList
                        .add(BlancoCgLineUtil
                                .getSingleLineCommentPrefix(fTargetLang)
                                + fBundle
                                        .getXml2sourceFileDumpUtf16beMsg(BlancoStringUtil
                                                .toHexString(fieldLook
                                                        .getValue().getBytes(
                                                                "UTF-16BE"))));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }

            String compareValue = null;

            switch (fTargetLang) {
            case BlancoCgSupportedLang.JAVA:
            case BlancoCgSupportedLang.CS:
            case BlancoCgSupportedLang.JS:
            case BlancoCgSupportedLang.PHP:
            case BlancoCgSupportedLang.RUBY:
            case BlancoCgSupportedLang.PYTHON:
                String escapedValue = "";
                if (fieldLook.getValue().equals("'")) {
                    escapedValue = "\\'";
                } else {
                    escapedValue = BlancoCgSourceUtil.escapeStringAsSource(
                            fTargetLang, fieldLook.getValue());
                }
                compareValue = "'" + escapedValue + "'";
                break;
            case BlancoCgSupportedLang.VB:
                if (fieldLook.getValue().equals("\\")) {
                    // obNXbVʂɏB
                    compareValue = "\"\\\"c";
                } else {
                    compareValue = "\""
                            + BlancoCgSourceUtil.escapeStringAsSource(
                                    fTargetLang, fieldLook.getValue()) + "\"c";
                }
                break;
            }

            switch (fTargetLang) {
            case BlancoCgSupportedLang.JAVA:
            case BlancoCgSupportedLang.CS:
            case BlancoCgSupportedLang.JS:
            case BlancoCgSupportedLang.RUBY:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        "argCheck == " + compareValue));
                break;
            case BlancoCgSupportedLang.VB:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        "argCheck = " + compareValue));
                break;
            case BlancoCgSupportedLang.PHP:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        "$argCheck === " + compareValue));
                break;
            case BlancoCgSupportedLang.PYTHON:
                lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                        "argCheckUnicode == u" + compareValue));
                break;
            }

            switch (fTargetLang) {
            case BlancoCgSupportedLang.PYTHON:
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "True")
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            default:
                lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "true")
                        + BlancoCgLineUtil.getTerminator(fTargetLang));
                break;
            }

            lineList.add(BlancoCgLineUtil.getIfEnd(fTargetLang));
        }

        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "False")
                    + BlancoCgLineUtil.getTerminator(fTargetLang));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "false"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        }

    }

    /**
     * matchAll\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodMatchAll(
            final BlancoCharacterGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("matchAll"),
                "^ꂽ񂪁ASĕO[vɊ܂܂镶ł邩ǂ𔻒肵܂B");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "`FbNsB", true));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeBoolean(),
                "SĂ̕O[vɊ܂܂ĂtureBO[vɊ܂܂Ȃ܂܂ĂfalseB"));

        final List<java.lang.String> lineList = cgMethod.getLineList();

        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
            lineList.add("char[] arrayArg = argCheck."
                    + getMethodName("toCharArray") + "();");
            lineList.add("int arraySize = arrayArg." + getMethodName("length")
                    + ";");
            lineList.add(BlancoCgLineUtil.getForBeginJava(fTargetLang,
                    "int index = 0", "index < arraySize", "index++"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    getMethodName("match") + "(arrayArg[index]) == false"));
            break;
        case BlancoCgSupportedLang.JS:
            lineList.add("var arraySize = argCheck.length;");
            lineList.add(BlancoCgLineUtil.getForBeginJava(fTargetLang,
                    "index = 0", "index < arraySize", "index++"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    "this.match(argCheck.charAt(index)) === false"));
            break;
        case BlancoCgSupportedLang.VB:
            lineList.add("Dim arrayArg As Char() = argCheck."
                    + getMethodName("toCharArray") + "()");
            lineList.add("Dim arraySize As Integer= arrayArg."
                    + getMethodName("Length"));
            lineList.add(BlancoCgLineUtil.getForBeginVb(fTargetLang,
                    "index As Integer = 0", "arraySize - 1"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    getMethodName("match") + "(arrayArg(index)) = False"));
            break;
        case BlancoCgSupportedLang.PHP:
            fCgSourceFile.getImportList().add("mbstring.mb_strlen");
            lineList.add("$arraySize = mb_strlen($argCheck);");
            lineList.add(BlancoCgLineUtil.getForBeginJava(fTargetLang,
                    "$index = 0", "$index < $arraySize", "$index++"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    "$this->match(mb_substr($argCheck, $index, 1)) === false"));
            break;
        case BlancoCgSupportedLang.RUBY:
            lineList.add("argArray = argCheck." + getMethodName("scan")
                    + "(/./)");
            lineList.add(BlancoCgLineUtil.getEachBeginRuby(fTargetLang,
                    "argArray", "arg"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    getMethodName("match") + "(arg) == false"));
            break;
        case BlancoCgSupportedLang.PYTHON:
            lineList.add("argCheckUnicode = unicode(argCheck, self.encoding)");
            lineList.add(BlancoCgLineUtil.getForBeginPython(fTargetLang, "arg",
                    "argCheckUnicode"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang, "self."
                    + getMethodName("match")
                    + "(arg.encode(self.encoding)) == False"));
            break;
        default:
            break;
        }

        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "False"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "false"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        }
        lineList.add(BlancoCgLineUtil.getIfEnd(fTargetLang));

        switch (fTargetLang) {
        case BlancoCgSupportedLang.RUBY:
            lineList.add(BlancoCgLineUtil.getEachEnd(fTargetLang));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getForEnd(fTargetLang));
            break;
        }

        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "True"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "true"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        }
    }

    /**
     * matchAny\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodMatchAny(
            final BlancoCharacterGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("matchAny"),
                "^ꂽ񂪁AO[vɊ܂܂镶ЂƂł܂ł邩ǂ𔻒肵܂B");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "`FbNsB", true));
        cgMethod
                .setReturn(fCgFactory
                        .createReturn(getTypeBoolean(),
                                "O[vɊ܂܂Ă镶ЂƂł܂łtureBO[vɊ܂܂镶ЂƂ܂܂ȂꍇfalseB"));

        final List<java.lang.String> lineList = cgMethod.getLineList();

        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
            lineList.add("char[] arrayArg = argCheck."
                    + getMethodName("toCharArray") + "();");
            lineList.add("int arraySize = arrayArg." + getMethodName("length")
                    + ";");
            lineList.add(BlancoCgLineUtil.getForBeginJava(fTargetLang,
                    "int index = 0", "index < arraySize", "index++"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    getMethodName("match") + "(arrayArg[index])"));
            break;
        case BlancoCgSupportedLang.JS:
            lineList.add("var arraySize = argCheck.length;");
            lineList.add(BlancoCgLineUtil.getForBeginJava(fTargetLang,
                    "index = 0", "index < arraySize", "index++"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    "this.match(argCheck.charAt(index))"));
            break;
        case BlancoCgSupportedLang.VB:
            lineList.add("Dim arrayArg As Char() = argCheck."
                    + getMethodName("toCharArray") + "()");
            lineList.add("Dim arraySize As Integer= arrayArg."
                    + getMethodName("Length"));
            lineList.add(BlancoCgLineUtil.getForBeginVb(fTargetLang,
                    "index As Integer = 0", "arraySize - 1"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    "Match(arrayArg(index))"));
            break;
        case BlancoCgSupportedLang.PHP:
            lineList.add("$arraySize = mb_strlen($argCheck);");
            lineList.add(BlancoCgLineUtil.getForBeginJava(fTargetLang,
                    "$index = 0", "$index < $arraySize", "$index++"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    "$this->match(mb_substr($argCheck, $index, 1))"));
            break;
        case BlancoCgSupportedLang.RUBY:
            lineList.add("argArray = argCheck.scan(/./)");
            lineList.add(BlancoCgLineUtil.getEachBeginRuby(fTargetLang,
                    "argArray", "arg"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                    getMethodName("match") + "(arg)"));
            break;
        case BlancoCgSupportedLang.PYTHON:
            lineList.add("argCheckUnicode = unicode(argCheck, self.encoding)");
            lineList.add(BlancoCgLineUtil.getForBeginPython(fTargetLang, "arg",
                    "argCheckUnicode"));
            lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang, "self."
                    + getMethodName("match") + "(arg.encode(self.encoding))"));
            break;
        default:
            break;
        }

        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "True"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "true"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        }
        lineList.add(BlancoCgLineUtil.getIfEnd(fTargetLang));

        switch (fTargetLang) {
        case BlancoCgSupportedLang.RUBY:
            lineList.add(BlancoCgLineUtil.getEachEnd(fTargetLang));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getForEnd(fTargetLang));
            break;
        }

        switch (fTargetLang) {
        case BlancoCgSupportedLang.PYTHON:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "False"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        default:
            lineList.add(BlancoCgLineUtil.getReturn(fTargetLang, "false"
                    + BlancoCgLineUtil.getTerminator(fTargetLang)));
            break;
        }
    }

    /**
     * vO~Oꏈnɍ boolean ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeBoolean() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "boolean";
        case BlancoCgSupportedLang.CS:
            return "bool";
        case BlancoCgSupportedLang.JS:
            return "boolean";
        case BlancoCgSupportedLang.VB:
            return "Boolean";
        case BlancoCgSupportedLang.PHP:
            return "boolean";
        }
    }

    /**
     * vO~Oꏈnɍ String ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeString() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "java.lang.String";
        case BlancoCgSupportedLang.CS:
            return "string";
        case BlancoCgSupportedLang.JS:
            return "string";
        case BlancoCgSupportedLang.VB:
            return "String";
        case BlancoCgSupportedLang.PHP:
            return "string";
        }
    }

    /**
     * vO~Oꏈnɍ char ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeChar() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "char";
        case BlancoCgSupportedLang.CS:
            return "char";
        case BlancoCgSupportedLang.JS:
            return "string";
        case BlancoCgSupportedLang.VB:
            return "Char";
        case BlancoCgSupportedLang.PHP:
            return "string";
        }
    }

    /**
     * vO~Oꏈnɍ \bh̖Oό`Ȃ܂B
     * 
     * \bh̓ǂݑւB
     * 
     * @return
     */
    private final String getMethodName(final String argMethodName) {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return argMethodName;
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.VB:
            return BlancoNameAdjuster.toUpperCaseTitle(argMethodName);
        case BlancoCgSupportedLang.JS:
            return argMethodName;
        case BlancoCgSupportedLang.PHP:
            return argMethodName;
        }
    }
}
