import java.io.File;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.omegat.core.data.LegacyTM;
import org.omegat.core.data.StringEntry;
import org.omegat.core.data.StringEntryWrapper;
import org.omegat.core.matching.FuzzyMatcherWrapper;
import org.omegat.core.matching.NearString;
import org.omegat.util.Language;
import org.omegat.util.TMXReader;

public class TmxTest extends TestCase {
    public void test() throws Exception {
//        OmegaTWrapper.getCommandThread();

        final TMXReader reader = new TMXReader("UTF-8", new Language("en_US"),
                new Language("ja_JP"), false);

        final File dirTmx = new File("../blancoXliff2Tmx/tmp/tmx/");
        final File[] fileTmxs = dirTmx.listFiles();
        if (fileTmxs == null) {
            System.out.println("fileTmxs is null");
            return;
        }
        for (int index = 0; index < fileTmxs.length; index++) {
            final File fileTmx = fileTmxs[index];
            if (fileTmx.isFile() == false) {
                continue;
            }

            reader.loadFile(fileTmx.getAbsolutePath(), true);
        }

        final int num = reader.numSegments();
        final List<StringEntry> strEntryList = new ArrayList<StringEntry>(num);
        
        for (int i = 0; i < num; i++) {
                String src = reader.getSourceSegment(i);
                String trans = reader.getTargetSegment(i);

                StringEntryWrapper se = new StringEntryWrapper(src);
                se.setTranslation(trans);
                
                strEntryList.add(se);
        }
        LegacyTM legacyTm = new LegacyTM("testTmx", strEntryList);
        List<LegacyTM> legacyTmList = new ArrayList<LegacyTM>();
        legacyTmList.add(legacyTm);
        
        System.out.println("TM size" + strEntryList.size());
        
        long start = System.currentTimeMillis();
        
        final FuzzyMatcherWrapper fuzzyMatcher = FuzzyMatcherWrapper
                .getInstance();

        final StringEntry tuEntry = new StringEntry("Choose the file system.");

        List<NearString> nearList = fuzzyMatcher.match(tuEntry, legacyTmList);

        if (nearList.size() > 0) {
            System.out.println(nearList.size()
                    + "̃}b`݂܂B");
            System.out.println("()" + tuEntry.getSrcText());
            for (NearString nearString: nearList) {
                System.out.println("------------------------------------");
                System.out.println(nearString.score + "%}b`");
                System.out.println(nearString.str.getSrcText());
                System.out.println(nearString.str.getTranslation());
            }
            System.out.println("------------------------------------");
            System.out.println("");
        }

        long end = System.currentTimeMillis();
        System.out.println("time:" + (end - start));

    }
}
