/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ProjectFactory;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;

public class Main {
    protected static final Pattern PARAM = Pattern.compile("\\-\\-([A-Za-z\\-]+)(=(.+))?");
    protected static File projectLocation = null;
    protected static final Map<String, String> params = new TreeMap<String, String>();
    protected static RUN_MODE runMode = RUN_MODE.GUI;

    public static void main(String[] stringArray) {
        String string;
        for (String string2 : stringArray) {
            Matcher matcher = PARAM.matcher(string2);
            if (matcher.matches()) {
                params.put(matcher.group(1), matcher.group(3));
                continue;
            }
            if (string2.startsWith("resource-bundle=")) {
                params.put("resource-bundle", string2.substring(16));
                continue;
            }
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory()) continue;
            projectLocation = file;
        }
        runMode = RUN_MODE.parse(params.get("mode"));
        String string3 = params.get("resource-bundle");
        if (string3 != null) {
            OStrings.loadBundle(string3);
        }
        if ((string = params.get("config-dir")) != null) {
            RuntimePreferences.setConfigDir(string);
        }
        if (params.containsKey("quiet")) {
            RuntimePreferences.setQuietMode(true);
        }
        Log.log("\n===================================================================\n" + OStrings.getDisplayVersion() + " (" + new Date() + ") " + " Locale " + Locale.getDefault());
        Log.logRB("LOG_STARTUP_INFO", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home"));
        switch (runMode) {
            case GUI: {
                Main.runGUI();
                break;
            }
            case CONSOLE_TRANSLATE: {
                Main.runConsoleTranslate();
            }
        }
    }

    protected static void runGUI() {
        Log.log("Docking Framework version: " + DockingDesktop.getDockingFrameworkVersion());
        Log.log("");
        try {
            UIManager.getInstalledLookAndFeels();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "OmegaT");
        }
        catch (Exception exception) {
            Log.logErrorRB("MAIN_ERROR_CANT_INIT_OSLF", new Object[0]);
        }
        try {
            Core.initializeGUI(params);
        }
        catch (Throwable throwable) {
            Main.showError(throwable);
        }
        CoreEvents.fireApplicationStartup();
        if (projectLocation != null) {
            try {
                ProjectProperties projectProperties = ProjectFileStorage.loadProjectProperties(projectLocation);
                ProjectFactory.loadProject(projectProperties);
            }
            catch (Exception exception) {
                Main.showError(exception);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Core.getMainWindow().getApplicationFrame().setVisible(true);
            }
        });
    }

    protected static void runConsoleTranslate() {
        Log.log("Console mode");
        Log.log("");
        System.out.println("Initializing");
        try {
            Core.initializeConsole(params);
        }
        catch (Throwable throwable) {
            Main.showError(throwable);
        }
        try {
            System.out.println("Loading Project");
            ProjectProperties projectProperties = null;
            try {
                projectProperties = ProjectFileStorage.loadProjectProperties(projectLocation);
                if (!projectProperties.verifyProject()) {
                    System.out.println("The project cannot be verified");
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
                System.exit(1);
            }
            RealProject realProject = new RealProject(projectProperties, false);
            Core.setProject(realProject);
            System.out.println("Translating Project");
            realProject.compileProject();
            System.out.println("Finished");
        }
        catch (Exception exception) {
            System.err.println("An error has occured: " + exception.toString());
            System.exit(1);
        }
    }

    public static void showError(Throwable throwable) {
        switch (runMode) {
            case GUI: {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), throwable.getMessage(), OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
                break;
            }
            case CONSOLE_TRANSLATE: {
                System.err.println(throwable.getMessage());
            }
        }
        System.exit(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RUN_MODE {
        GUI,
        CONSOLE_TRANSLATE;


        public static RUN_MODE parse(String string) {
            try {
                return RUN_MODE.valueOf(string.toUpperCase().replace('-', '_'));
            }
            catch (Exception exception) {
                return GUI;
            }
        }
    }
}

