/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryManager {
    private final String EXT_DEF_ENC = ".tab";
    private final String EXT_UTF8_ENC = ".utf8";
    private List<GlossaryEntry> glossaryEntries;

    public void loadGlossaryFiles(File file) {
        if (!file.isDirectory()) {
            Log.logRB("CT_ERROR_ACCESS_GLOSSARY_DIR", new Object[0]);
            return;
        }
        try {
            ArrayList<GlossaryEntry> arrayList = new ArrayList<GlossaryEntry>();
            for (String string : file.list()) {
                String string2 = file.getAbsolutePath() + File.separator + string;
                String string3 = string2.toLowerCase();
                if (!string3.endsWith(".tab") && !string3.endsWith(".utf8")) continue;
                Log.logRB("CT_LOADING_GLOSSARY", string2);
                this.loadGlossaryFile(new File(string2), arrayList);
            }
            this.glossaryEntries = Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            Log.logRB("CT_ERROR_ACCESS_GLOSSARY_DIR", new Object[0]);
            Log.log(exception);
        }
    }

    private void loadGlossaryFile(File file, List<GlossaryEntry> list) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        Closeable closeable;
        String string = file.getName().toLowerCase();
        InputStreamReader inputStreamReader = null;
        if (string.endsWith(".tab")) {
            inputStreamReader = new InputStreamReader(new FileInputStream(file));
        } else if (string.endsWith(".utf8")) {
            closeable = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)closeable, "UTF-8");
        }
        closeable = new BufferedReader(inputStreamReader);
        ((BufferedReader)closeable).mark(1);
        int n = ((BufferedReader)closeable).read();
        if (n != 65279) {
            ((BufferedReader)closeable).reset();
        }
        String string2 = ((BufferedReader)closeable).readLine();
        while (string2 != null) {
            String[] stringArray;
            if (!string2.startsWith("#") && (stringArray = string2.split("\t")).length >= 2 && stringArray[0].length() != 0) {
                String string3 = "";
                if (stringArray.length >= 3) {
                    string3 = stringArray[2];
                }
                list.add(new GlossaryEntry(stringArray[0], stringArray[1], string3));
            }
            string2 = ((BufferedReader)closeable).readLine();
        }
        ((BufferedReader)closeable).close();
    }

    public List<GlossaryEntry> getGlossaryEntries() {
        return this.glossaryEntries;
    }

    public void clear() {
        this.glossaryEntries = null;
    }
}

