/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpHtmlParser
implements Iterable<HtmlFragment> {
    private static final Logger log = Logger.getLogger(HelpHtmlParser.class);
    private static final Map<String, String> htmlJavaCharsetMap = new HashMap<String, String>(){
        {
            this.put("shift_jis", "Windows-31J");
        }

        @Override
        public String get(Object key) {
            String htmlCharset = (String)key;
            String javaCharset = (String)super.get(htmlCharset.toLowerCase());
            return javaCharset == null ? htmlCharset : javaCharset;
        }
    };
    private byte[] inputBytes;
    private String inputString;
    private Matcher blockTagMatcher;
    private int blockTagMatcherStart;
    private Matcher tagMatcher;
    private StringBuffer outputBuffer;

    public HelpHtmlParser(InputStream is) {
        String EN_CHARSET = "ISO-8859-1";
        try {
            this.inputBytes = IOUtils.toByteArray((InputStream)is);
            this.inputString = new String(this.inputBytes, "ISO-8859-1").trim();
            if (this.inputString.startsWith("<!DOCTYPE") || this.inputString.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE")) {
                String charsetPattern = "(?i)(?s).+?text/html; charset=([^\"]+).+";
                if (this.inputString.matches(charsetPattern)) {
                    String charset = this.inputString.replaceFirst(charsetPattern, "$1");
                    if (!charset.equalsIgnoreCase("ISO-8859-1")) {
                        String javaCharset = htmlJavaCharsetMap.get(charset);
                        this.inputString = new String(this.inputBytes, javaCharset);
                    }
                } else {
                    log.warn("HTML \u306e charset \u304c\u898b\u3064\u304b\u3089\u306a\u3044\u305f\u3081\u3001%s \u3067\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002\n%s", "ISO-8859-1", this.inputString.length() > 500 ? this.inputString.substring(0, 500) : this.inputString);
                }
                String html4StrictBlockElements = "p|div|table|dl|ul|ol|form|address|blockquote|h[1-6]|fieldset|hr|pre";
                String blockElementsEx = "li|title|th|td|" + html4StrictBlockElements;
                String blockTags = "(?i)(?s)<(|/)(" + blockElementsEx + ")(>|\\s+[^>]*>)";
                Pattern blockTagPattern = Pattern.compile(String.valueOf(blockTags) + "(.+?)" + blockTags);
                this.blockTagMatcher = blockTagPattern.matcher(this.inputString);
                this.outputBuffer = new StringBuffer();
            }
        }
        catch (Exception e) {
            log.error(e, "\u30d8\u30eb\u30d7 HTML \u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Iterator<HtmlFragment> iterator() {
        return new Iterator<HtmlFragment>(){
            private int id;
            private HtmlFragment f;
            private HtmlFragment fNext;

            private boolean isNoText(String group123, String group2) {
                if (group123.matches("(?i)(?s)<pre>.+</pre>") || group2.trim().equals("") || group2.matches("(?i)(?s)(.+<body.+|<font[^>]*>|<[\\w/]+>|</tr>.*<tr.*>)\\s*")) {
                    return true;
                }
                return group2.matches("(?i)(?s)(<[^>]+>\\s*)+") && !group2.matches("(?i)(?s).*?\\s(alt|title)=.*");
            }

            @Override
            public boolean hasNext() {
                String m1;
                if (this.fNext != null) {
                    this.f = this.fNext;
                    this.fNext = null;
                    return true;
                }
                if (HelpHtmlParser.this.blockTagMatcher == null || !HelpHtmlParser.this.blockTagMatcher.find(HelpHtmlParser.this.blockTagMatcherStart)) {
                    return false;
                }
                HelpHtmlParser.this.outputBuffer.append(HelpHtmlParser.this.inputString.substring(HelpHtmlParser.this.blockTagMatcherStart, HelpHtmlParser.this.blockTagMatcher.start()));
                String group123 = HelpHtmlParser.this.blockTagMatcher.group();
                Pattern pat = Pattern.compile("(?i)(?s)^(<.+?>\\s*)(.+)(\\s*<.+>)$");
                HelpHtmlParser.this.tagMatcher = pat.matcher(group123);
                if (!HelpHtmlParser.this.tagMatcher.find()) {
                    throw new IllegalArgumentException("HTML \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u4e0d\u6b63\uff1a" + group123);
                }
                HelpHtmlParser.this.blockTagMatcherStart = HelpHtmlParser.this.blockTagMatcher.end() - (HelpHtmlParser.this.tagMatcher.end() - HelpHtmlParser.this.tagMatcher.end(2));
                String group2 = HelpHtmlParser.this.tagMatcher.group(2);
                String group12 = String.valueOf(HelpHtmlParser.this.tagMatcher.group(1)) + HelpHtmlParser.this.tagMatcher.group(2);
                if (this.isNoText(group123, group2)) {
                    HelpHtmlParser.this.outputBuffer.append(group12);
                    return this.hasNext();
                }
                this.f = new HtmlFragment(this.id++);
                this.f.starts = HelpHtmlParser.this.tagMatcher.group(1);
                this.f.text = HelpHtmlParser.this.tagMatcher.group(2);
                String p = "(?i)(?s)^(.+)(\\s*<font.*>)$";
                Matcher m = Pattern.compile(p).matcher(this.f.text);
                if (m.find()) {
                    this.f.text = m.group(1);
                    this.f.ends = String.valueOf(m.group(2)) + this.f.ends;
                }
                if ((m = Pattern.compile(p = "(?i)(?s)^(<(p|/font)>\\s*)(.+)$").matcher(this.f.text)).find()) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(3);
                }
                if ((m = Pattern.compile(p = "(?i)(?s)^((|\u300c)<a\\s+.+>[A-Z1-9_]+?</a>[\\s-\u300d]*)(.+)$").matcher(this.f.text)).find()) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(3);
                }
                if ((m = Pattern.compile(p = "(?i)(?s)^(.+?)(\\s*(|\\()\\s*<a\\s+.+>[A-Z1-9_]+?</a>\\s*(|\\)))$").matcher(this.f.text)).find()) {
                    this.f.text = m.group(1);
                    this.f.ends = String.valueOf(m.group(2)) + this.f.ends;
                }
                while ((m = Pattern.compile(p = "(?i)(?s)^(\\s*<[^>]+>\\s*)(.+?)(\\s*</[^>]+>\\s*)$").matcher(this.f.text)).find() && !(m1 = m.group(1)).contains("alt=") && !m1.contains("title=")) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(2);
                    this.f.ends = String.valueOf(m.group(3)) + this.f.ends;
                }
                p = "(?i)(?s)^(.+?)((\\s*<br>\\s*)+)$";
                m = Pattern.compile(p).matcher(this.f.text);
                if (m.find()) {
                    this.f.text = m.group(1);
                    this.f.ends = String.valueOf(m.group(2)) + this.f.ends;
                }
                if ((m = Pattern.compile(p = "(?i)(?s)^(<[^>]+?\\s(alt|title)=\")(.+?)(\"[^>]*>\\s*)$").matcher(this.f.text)).find()) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(3);
                    this.f.ends = String.valueOf(m.group(4)) + this.f.ends;
                    p = "(?i)(?s)^(\"\\s+(alt|title)=\")(.+?)(\".*)$";
                    m = Pattern.compile(p).matcher(this.f.ends);
                    if (m.find()) {
                        this.f.ends = "";
                        this.fNext = new HtmlFragment(this.id++);
                        this.fNext.starts = m.group(1);
                        this.fNext.text = m.group(3);
                        this.fNext.ends = m.group(4);
                    }
                }
                return true;
            }

            @Override
            public HtmlFragment next() {
                return this.f;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public InputStream getInputStream() {
        if (this.blockTagMatcher == null) {
            return new ByteArrayInputStream(this.inputBytes);
        }
        try {
            this.outputBuffer.append(this.inputString.substring(this.blockTagMatcherStart));
            String s = this.outputBuffer.toString().replaceFirst("(text/html; charset=)[^\"]+", "$1UTF-8");
            return new ByteArrayInputStream(s.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public class HtmlFragment {
        public final int id;
        private String starts = "";
        private String text = "";
        private String textBackup = "";
        private String ends = "";

        HtmlFragment(int id) {
            this.id = id;
        }

        public String getText() {
            this.textBackup = this.text.replaceAll("(\\r\\n|\\r)", "\n");
            this.textBackup = this.textBackup.replaceAll("(\\p{ASCII})\\n", "$1 ");
            this.textBackup = this.textBackup.replaceAll("\\n(\\p{ASCII})", " $1");
            this.textBackup = this.textBackup.replace("\n", "");
            this.textBackup = this.textBackup.replaceAll("\\s+", " ");
            return this.textBackup;
        }

        public void setText(String text) {
            if (text.equals(this.textBackup)) {
                text = this.text;
            }
            String s = String.valueOf(this.starts) + text + this.ends;
            HelpHtmlParser.this.outputBuffer.append(s);
        }

        public String toString() {
            String p = "id" + this.id + ":group";
            return String.valueOf(p) + "1| " + this.starts + "\n" + p + "2| " + this.getText() + "\n" + p + "3| " + this.ends;
        }

        public String getStarts() {
            return this.starts;
        }

        public String getEnds() {
            return this.ends;
        }
    }
}

