/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.pleiades.generator.Generator;
import jp.sourceforge.mergedoc.pleiades.generator.Validator;
import jp.sourceforge.mergedoc.pleiades.generator.nls.AbstractExtractor;
import jp.sourceforge.mergedoc.pleiades.generator.nls.HelpPlugin;
import jp.sourceforge.mergedoc.pleiades.generator.nls.HelpTranslationRule;
import jp.sourceforge.mergedoc.pleiades.generator.nls.HtmlFragmentList;
import jp.sourceforge.mergedoc.pleiades.generator.nls.HtmlFragmentListUnit;
import jp.sourceforge.mergedoc.pleiades.generator.nls.PropertySetUnit;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.HelpHtmlParser;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import org.apache.commons.lang.StringUtils;

public class HelpExtractor
extends AbstractExtractor {
    private static boolean isReExtractFromNls = true;
    private static final PropertySet vHelpTransProp = new PropertySet("props/validation-help-translation.properties");
    private static final PropertySet vHelpTransReverseProp = new PropertySet("props/validation-help-translation-reverse.properties");

    public static void main(String ... args) throws IOException {
        new HelpExtractor().run("help", args);
    }

    protected void doExtract() throws IOException {
        if (isReExtractFromNls) {
            super.doExtract();
        }
    }

    protected void extractPlugins(File pluginsFolder) throws IOException {
        HashMap<String, PropertySetUnit> pluginTocMap = new HashMap<String, PropertySetUnit>();
        HashMap<String, HtmlFragmentListUnit> pluginHtmlMap = new HashMap<String, HtmlFragmentListUnit>();
        Object[] pluginFiles = pluginsFolder.listFiles();
        Arrays.sort(pluginFiles);
        Object[] objectArray = pluginFiles;
        int n = pluginFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object pluginFile = objectArray[n2];
            HelpPlugin plugin = new HelpPlugin((File)pluginFile);
            String pluginId = plugin.getId();
            PropertySetUnit propUnit = (PropertySetUnit)pluginTocMap.get(pluginId);
            if (propUnit == null) {
                propUnit = new PropertySetUnit();
                pluginTocMap.put(pluginId, propUnit);
            }
            propUnit.getEnPropertySet().putAll(plugin.getEnPropertySet());
            propUnit.getJaPropertySet().putAll(plugin.getJaPropertySet());
            HtmlFragmentListUnit htmlUnit = (HtmlFragmentListUnit)pluginHtmlMap.get(pluginId);
            if (htmlUnit == null) {
                htmlUnit = new HtmlFragmentListUnit();
                pluginHtmlMap.put(pluginId, htmlUnit);
            }
            htmlUnit.enHtmlMap.putAll(plugin.getHtmlListUnit().enHtmlMap);
            htmlUnit.jaHtmlMap.putAll(plugin.getHtmlListUnit().jaHtmlMap);
            log.debug("en:%3d\u3001ja:%3d\u3001%s", htmlUnit.enHtmlMap.size(), htmlUnit.jaHtmlMap.size(), pluginId);
            ++n2;
        }
        String pluginPath = Files.relativePath(inNlsFolder, pluginsFolder);
        for (Map.Entry entry : pluginTocMap.entrySet()) {
            String pluginId = (String)entry.getKey();
            PropertySetUnit propUnit = (PropertySetUnit)entry.getValue();
            PropertySet enProp = propUnit.getEnPropertySet();
            PropertySet jaProp = propUnit.getJaPropertySet();
            PropertySet outProp = new PropertySet();
            for (Property ja : jaProp) {
                String enValue = (String)enProp.get(ja.key);
                if (!StringUtils.isNotEmpty((String)enValue) || enValue.equals(ja.value) || ja.value.matches("\\p{ASCII}+")) continue;
                outProp.put(enValue, ja.value);
            }
            HtmlFragmentListUnit listUnit = (HtmlFragmentListUnit)pluginHtmlMap.get(pluginId);
            for (Map.Entry entry2 : listUnit.enHtmlMap.entrySet()) {
                HtmlFragmentList enList = (HtmlFragmentList)entry2.getValue();
                HtmlFragmentList jaList = listUnit.jaHtmlMap.get(entry2.getKey());
                if (jaList == null) {
                    log.debug("\u65e5\u672c\u8a9e\u30ea\u30b9\u30c8\u304c null \u3067\u3059\u3002\u82f1\u8a9e\u30ea\u30b9\u30c8\u306e\u30d1\u30b9: " + enList.path, new Object[0]);
                    continue;
                }
                this.optimizeListSize(enList, jaList);
                if (enList.size() != jaList.size()) continue;
                int i = 0;
                while (i < enList.size()) {
                    outProp.put(enList.get(i).getText(), jaList.get(i).getText());
                    ++i;
                }
            }
            int n3 = outProp.size();
            if (n3 <= 0) continue;
            this.count += n3;
            String outFileName = String.valueOf(pluginPath.replace('\\', '@')) + "@" + pluginId + ".properties";
            File outFile = new File(this.extractTempFolder, outFileName);
            outProp.store(outFile, "eclipse.org \u8a00\u8a9e\u30d1\u30c3\u30af\u62bd\u51fa\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (\u30d7\u30e9\u30b0\u30a4\u30f3\u5225)");
        }
    }

    protected void afterExtract(PropertySet extractedProp) throws IOException {
        this.createBeforeValidator(String.valueOf(this.extractPropPath) + "_before_apply_rule_validate.log").validate(extractedProp);
        PropertySet existsProp = new PropertySet("props/temp-nls-ui-customized.properties", "props/temp-additions-all.properties");
        PropertySet prop = new HelpTranslationRule(String.valueOf(this.extractPropPath) + "_rule.log", existsProp).apply(extractedProp);
        PropertySet helpTextProp = new PropertySet();
        PropertySet helpHtmlProp = new PropertySet();
        Validator uiValidator = new Validator(String.valueOf(this.extractPropPath) + "_after_apply_rule_validate.log", new PropertySet[0]);
        for (Property p : prop) {
            if (this.isValidUiProperty(p, uiValidator)) {
                helpTextProp.put(p.key, p.value);
                continue;
            }
            helpHtmlProp.put(p.key, p.value);
        }
        Generator.storeHistory(helpTextProp, "props/temp-nls-help-checked.properties", "\u30d8\u30eb\u30d7\u30fb\u30c6\u30ad\u30b9\u30c8\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (\u7ffb\u8a33\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f\u3001\u30d0\u30ea\u30c7\u30fc\u30bf\u30fc\u691c\u8a3c OK)\n\n  \u8a00\u8a9e\u30d1\u30c3\u30af\u306e\u30d8\u30eb\u30d7\u304b\u3089\u62bd\u51fa\u3057\u305f\u3082\u306e\u3067\u3001translation.properties \u306b\u30de\u30fc\u30b8\u3055\u308c\u307e\u3059\u3002\n  \u53e5\u70b9\u89e3\u6790\u306b\u3088\u308a\u30a8\u30f3\u30c8\u30ea\u30fc\u306f\u53ef\u80fd\u306a\u9650\u308a\u6587\u5358\u4f4d\u306b\u5206\u5272\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1a" + this.extractPropPath);
        Generator.storeHistory(helpHtmlProp, "props/temp-nls-help-unchecked.properties", "\u30d8\u30eb\u30d7 HTML \u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (\u7ffb\u8a33\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f\u3001\u30d0\u30ea\u30c7\u30fc\u30bf\u30fc\u691c\u8a3c NG)\n\n  \u8a00\u8a9e\u30d1\u30c3\u30af\u306e\u30d8\u30eb\u30d7\u304b\u3089\u62bd\u51fa\u3057\u305f\u3082\u306e\u3067\u3059\u3002\n  \u53e5\u70b9\u89e3\u6790\u306b\u3088\u308a\u30a8\u30f3\u30c8\u30ea\u30fc\u306f\u53ef\u80fd\u306a\u9650\u308a\u6587\u5358\u4f4d\u306b\u5206\u5272\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1a" + this.extractPropPath);
    }

    protected Validator createBeforeValidator(String logFileName) {
        return new Validator(logFileName, new PropertySet[0]);
    }

    private boolean isValidUiProperty(Property p, Validator uiValidator) {
        String s = String.valueOf(p.key) + p.value;
        if (s.contains("<") || s.contains(">") || s.contains(" alt=") || s.contains(" ALT =") || Mnemonics.containsHtmlReference(s)) {
            return false;
        }
        return uiValidator.validate(p).isSuccess();
    }

    public String optimizeListSize(HtmlFragmentList enList, HtmlFragmentList jaList) {
        String string;
        int jaListSizeOld;
        int enListSizeOld;
        StringBuilder msg;
        block18: {
            msg = new StringBuilder();
            if (enList.size() == jaList.size() || enList.size() == 0 || jaList.size() == 0) {
                return msg.toString();
            }
            enListSizeOld = enList.size();
            jaListSizeOld = jaList.size();
            if (enList.size() >= jaList.size()) break block18;
            int i = 0;
            while (i < enList.size()) {
                HelpHtmlParser.HtmlFragment en = enList.get(i);
                HelpHtmlParser.HtmlFragment ja = jaList.get(i);
                for (Property vTrans : vHelpTransProp) {
                    String enPart = vTrans.key;
                    String jaPart = vTrans.value;
                    if (!en.getText().matches(enPart)) continue;
                    while (!ja.getText().matches(jaPart)) {
                        HelpHtmlParser.HtmlFragment jaOld = (HelpHtmlParser.HtmlFragment)jaList.remove(i);
                        ja = jaList.get(i);
                        msg.append("\u2605\u65e5\u672c\u8a9e\u8aad\u307f\u98db\u3070\u3057 " + enPart + "\n" + en + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n" + jaOld + "\n" + ja + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                    }
                }
                ++i;
            }
            String string2 = msg.toString();
            if (enList.size() != jaList.size()) {
                log.warn("\u30ea\u30b9\u30c8\u30fb\u30b5\u30a4\u30ba\u4e0d\u6b63\u3002\u82f1\u8a9e\uff1a%3d -> %3d\u3001\u65e5\u672c\u8a9e\uff1a%3d -> %3d\u3001%s", enListSizeOld, enList.size(), jaListSizeOld, jaList.size(), enList.path);
            }
            return string2;
        }
        try {
            HelpHtmlParser.HtmlFragment en;
            String altPattern = "(?s)(?i).+?\\s(alt|title)=\".*";
            int i = 0;
            while (i < jaList.size()) {
                HelpHtmlParser.HtmlFragment enOld;
                HelpHtmlParser.HtmlFragment en2 = enList.get(i);
                HelpHtmlParser.HtmlFragment ja = jaList.get(i);
                if (en2 == null) break;
                if (en2.getStarts().matches("(?s)(?i).+?\\s(alt|title)=\".*") && !ja.getStarts().matches("(?s)(?i).+?\\s(alt|title)=\".*")) {
                    enOld = (HelpHtmlParser.HtmlFragment)enList.remove(i);
                    en2 = enList.get(i);
                    msg.append("\u25cf\u82f1\u8a9e\u8aad\u307f\u98db\u3070\u3057 (\u5148\u982d alt \u306a\u3057)\n" + ja + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n" + enOld + "\n" + en2 + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                } else if (en2.getText().matches("(?s)(?i).+?\\s(alt|title)=\".*") && !ja.getText().matches("(?s)(?i).+?\\s(alt|title)=\".*")) {
                    enOld = (HelpHtmlParser.HtmlFragment)enList.remove(i);
                    en2 = enList.get(i);
                    msg.append("\u25cf\u82f1\u8a9e\u8aad\u307f\u98db\u3070\u3057 (\u30c6\u30ad\u30b9\u30c8 alt \u306a\u3057)\n" + ja + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n" + enOld + "\n" + en2 + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                } else {
                    for (Property vTrans : vHelpTransReverseProp) {
                        String jaPart = vTrans.key;
                        String enPart = vTrans.value;
                        if (!ja.getText().matches(jaPart)) continue;
                        while (!en2.getText().matches(enPart)) {
                            HelpHtmlParser.HtmlFragment enOld2 = (HelpHtmlParser.HtmlFragment)enList.remove(i);
                            en2 = enList.get(i);
                            msg.append("\u25cf\u82f1\u8a9e\u8aad\u307f\u98db\u3070\u3057 " + enPart + "\n" + ja + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n" + enOld2 + "\n" + en2 + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                        }
                    }
                }
                ++i;
            }
            if (enList.size() == jaList.size() + 1 && (en = (HelpHtmlParser.HtmlFragment)enList.getLast()).getStarts().matches("(?s)(?i).+?\\s(alt|title)=\".*")) {
                enList.remove(en);
                msg.append("\u25cf\u82f1\u8a9e\u672b\u5c3e\u8981\u7d20\u30ab\u30c3\u30c8 (\u5148\u982d alt \u306a\u3057)\n" + en + "\n");
            }
            string = msg.toString();
        }
        catch (Throwable throwable) {
            if (enList.size() != jaList.size()) {
                log.warn("\u30ea\u30b9\u30c8\u30fb\u30b5\u30a4\u30ba\u4e0d\u6b63\u3002\u82f1\u8a9e\uff1a%3d -> %3d\u3001\u65e5\u672c\u8a9e\uff1a%3d -> %3d\u3001%s", enListSizeOld, enList.size(), jaListSizeOld, jaList.size(), enList.path);
            }
            throw throwable;
        }
        if (enList.size() != jaList.size()) {
            log.warn("\u30ea\u30b9\u30c8\u30fb\u30b5\u30a4\u30ba\u4e0d\u6b63\u3002\u82f1\u8a9e\uff1a%3d -> %3d\u3001\u65e5\u672c\u8a9e\uff1a%3d -> %3d\u3001%s", enListSizeOld, enList.size(), jaListSizeOld, jaList.size(), enList.path);
        }
        return string;
    }
}

