/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoNLpackGenerator]̃NX
 */
package blanco.nlpack.generator.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorProcessInput;

/**
 * Apache Ant^XN [BlancoNLpackGenerator]̃NXB
 *
 * w肳ꂽfBNg JavaAvP[V|󂵂܂BblancoNLpackGenerator̒SI^XNłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.nlpack.generator.task]BlancoNLpackGeneratorBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blanconlpackgenerator&quot; classname=&quot;blanco.nlpack.generator.task.BlancoNLpackGeneratorTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoNLpackGeneratorTask extends Task {
    /**
     * w肳ꂽfBNg JavaAvP[V|󂵂܂BblancoNLpackGenerator̒SI^XNłB
     */
    protected BlancoNLpackGeneratorProcessInput fInput = new BlancoNLpackGeneratorProcessInput();

    /**
     * tB[h [sourcedir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldSourcedirProcessed = false;

    /**
     * tB[h [targetdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * tB[h [tmpdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTmpdirProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * \[XfBNgB*.jart@CWJEclipsevOCB<br>
     *
     * @param arg Zbgl
     */
    public void setSourcedir(final String arg) {
        fInput.setSourcedir(arg);
        fIsFieldSourcedirProcessed = true;
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * \[XfBNgB*.jart@CWJEclipsevOCB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSourcedir() {
        return fInput.getSourcedir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * |̃t@Ci[Bo͐tH_w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * |̃t@Ci[Bo͐tH_w肵܂B<br>
     * ftHgl[blanco.nl]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
        fIsFieldTmpdirProcessed = true;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoNLpackGeneratorTask begin.");

        // ڔԍ[1]AAgr[g[sourcedir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldSourcedirProcessed == false) {
            throw new BuildException("K{Agr[g[sourcedir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- sourcedir:[" + getSourcedir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoNLpackGeneratorProcessC^tF[X blanco.nlpack.generator.taskpbP[W BlancoNLpackGeneratorProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoNLpackGeneratorProcess proc = new BlancoNLpackGeneratorProcessImpl();
            if (proc.execute(fInput) != BlancoNLpackGeneratorBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
