/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator;

import java.io.BufferedWriter;
import java.io.IOException;

import blanco.commons.io.Native2AsciiWriter;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultDetailCsvRecord;
import blanco.nlpack.generator.dictionary.BlancoNLpackGeneratorOmitDictionary;
import blanco.nlpack.generator.dictionary.BlancoNLpackGeneratorPleiadesDictionary;
import blanco.nlpack.generator.frgmnt.BlancoNLpackGeneratorTranslationFragment;
import blanco.nlpack.generator.message.BlancoNLpackGeneratorMessage;

/**
 * vpeBt@CA[_EC^oR(pꂩ)eւƒlϊ܂B
 * 
 * @author IGA Tosiki
 */
class BlancoNLpackGeneratorPropertiesConverter {
    /**
     * bZ[WIuWFNgB
     */
    private final BlancoNLpackGeneratorMessage fMsg = new BlancoNLpackGeneratorMessage();

    /**
     * Pleiades̃CX^XB
     */
    private BlancoNLpackGeneratorPleiadesDictionary fPleiadesDictionary = new BlancoNLpackGeneratorPleiadesDictionary();

    /**
     * blancoNLpackGeneratorƂĂ̏OCX^XB
     */
    private BlancoNLpackGeneratorOmitDictionary fOmitDictionary = new BlancoNLpackGeneratorOmitDictionary();

    /**
     * |tOg̃CX^XB
     */
    private BlancoNLpackGeneratorTranslationFragment fTranslationFragment = new BlancoNLpackGeneratorTranslationFragment();

    /**
     * qbgB
     */
    private int fReplaceHitCount = 0;

    /**
     * j[jbNϊB
     */
    private int fReplaceMnemonicCount = 0;

    /**
     * OB
     */
    private int fReplaceOmitCount = 0;

    /**
     * ~XB
     */
    private int fReplaceMissCount = 0;

    public void resetReplaceCount() {
        // Ăяo邲ƂɃJE^Zbg܂B
        fReplaceHitCount = 0;
        fReplaceMnemonicCount = 0;
        fReplaceOmitCount = 0;
        fReplaceMissCount = 0;
    }

    /**
     * qbg擾܂B
     * 
     * @return qbgB
     */
    public int getReplaceHitCount() {
        return fReplaceHitCount;
    }

    /**
     * j[jbNϊ擾܂B
     * 
     * @return j[jbNϊB
     */
    public int getReplaceMnemonicCount() {
        return fReplaceMnemonicCount;
    }

    /**
     * O擾܂B
     * 
     * @return OB
     */
    public int getReplaceOmitCount() {
        return fReplaceOmitCount;
    }

    /**
     * ~X擾܂B
     * 
     * @return ~XB
     */
    public int getReplaceMissCount() {
        return fReplaceMissCount;
    }

    /**
     * Ђ܂B
     * 
     * @param bundleURI
     * @param strKey
     * @param inputValue
     * @param writer
     * @param record
     * @return
     * @throws IOException
     */
    public boolean lookup(final String bundleURI, final String strKey,
            final String inputValue, final BufferedWriter writer,
            final BlancoNLpackGeneratorResultDetailCsvRecord record)
            throws IOException {
        final String bundleURIwithKey = bundleURI + "?key=" + strKey;

        record.setBundleUri(bundleURIwithKey);
        record.setKey(strKey);
        record.setInput(inputValue);

        if (fTranslationFragment.checkTranslationFragment(bundleURIwithKey,
                inputValue)) {
            final String outputValue = fTranslationFragment.lookup(
                    bundleURIwithKey, inputValue);

            // o͒lZbgI
            writer.write(Native2AsciiWriter
                    .encodeNative2AsciiValue(outputValue));
            fReplaceHitCount++;
            // tOgu}[NB
            record.setAction("hit.f");
            record.setOutput(outputValue);
            return true;
        }

        final String outputValue = fPleiadesDictionary.lookup(inputValue);
        if (outputValue == null) {
            throw new IllegalArgumentException(fMsg.getMbebc003(bundleURI,
                    strKey));
        }

        if (fOmitDictionary.checkOmitURI(bundleURI)
                || fOmitDictionary.checkOmitURI(bundleURIwithKey)) {
            // URIx[XomitŏOΏۂƂ킩ꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceOmitCount++;
            record.setAction("omit.u");
            return false;
        }

        if (fOmitDictionary.checkOmitPhrase(inputValue)) {
            // 񂾂ꍇɃt[YOΏۂƂ킩ꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceOmitCount++;
            record.setAction("omit.p");
            return false;
        }

        if (fOmitDictionary.checkOmitString(inputValue)) {
            // 񂾂ꍇɏOΏۂƂ킩ꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceOmitCount++;
            record.setAction("omit.s");
            return false;
        }

        if (fPleiadesDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_NOT_FOUND) {
            // ɌȂꍇB

            // ͂ꂽvaluê܂܏óB
            writer
                    .write(Native2AsciiWriter
                            .encodeNative2AsciiValue(inputValue));
            fReplaceMissCount++;
            record.setAction("miss");
            return false;
        }

        if (fPleiadesDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_MNEMONIC_CHANGED) {
            // j[jbNϊ̂ݎ{ꂽꍇB

            if (fOmitDictionary.checkOmitMnemonicOnlyURI(bundleURI)
                    || fOmitDictionary
                            .checkOmitMnemonicOnlyURI(bundleURIwithKey)) {
                // j[jbNϊ݂̂̏Ot@CɍvꍇB

                // ͕ϊĂ̓_B
                // ͂ꂽvaluê܂܏óB
                writer.write(Native2AsciiWriter
                        .encodeNative2AsciiValue(inputValue));
                fReplaceOmitCount++;
                record.setAction("omit.m");
                return false;
            }

            // o͒lZbgI
            writer.write(Native2AsciiWriter
                    .encodeNative2AsciiValue(outputValue));
            fReplaceMnemonicCount++;
            // u}[NB
            record.setAction("mnemon");
            record.setOutput(outputValue);
            return true;
        }

        if (fPleiadesDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_FOUND) {
            // ̈ĂɐꍇB

            // o͒lZbgI
            writer.write(Native2AsciiWriter
                    .encodeNative2AsciiValue(outputValue));
            fReplaceHitCount++;
            // u}[NB
            record.setAction("hit.p");
            record.setOutput(outputValue);
            return true;
        }

        throw new IllegalArgumentException("z肳ȂӏɓĂ܂B");
    }
}
