/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorResultDetailCsvReader;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorResultDetailCsvWriter;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultDetailCsvRecord;

public class BlancoNLpackGeneratorResultDetailUtil {
    /**
     * uBundleUrivtB[h̒lɂA݂̍sLǂ`FbN܂B
     * 
     * @param reader
     *            `FbN{[_B
     * @return LȂtrueBȂfalseB
     * @throws IOException
     *             o͗OꍇB
     */
    public static boolean checkValidResultDetailRecordByFieldBundleUri(
            final BufferedReader reader) throws IOException {
        // "babel: ȊO̍s͖܂B
        reader.mark(8);
        final char[] buf = new char[7];
        final int len = reader.read(buf);
        reader.reset();

        if (len <= 0) {
            // t@C̏I[ɓB܂B
            // I[͐sƂĈ܂BĂяoœK؂ɏĂB
            return true;
        }
        if (len < 7) {
            // Z܂B͖sƔf܂B
            return false;
        }
        if (new String(buf).equals("\"babel:") == false) {
            // s\ȍsB
            // s̓ǂݔ΂͌ĂяołȂ܂B
            return false;
        }

        return true;
    }

    public static void loadResultDetail(final File fileResultDetail,
            final Map<String, BlancoNLpackGeneratorResultDetailCsvRecord> map)
            throws IOException, BlancoCsvIOException {
        final BlancoNLpackGeneratorResultDetailCsvReader reader = new BlancoNLpackGeneratorResultDetailCsvReader(
                new BufferedReader(new FileReader(fileResultDetail)));
        for (int index = 0;; index++) {
            if (BlancoNLpackGeneratorResultDetailUtil
                    .checkValidResultDetailRecordByFieldBundleUri(reader
                            .getReader()) == false) {
                // ̍s͓ǂݔ΂܂B
                reader.getReader().readLine();
                continue;
            }

            final BlancoNLpackGeneratorResultDetailCsvRecord record = reader
                    .readRecord();
            if (record == null) {
                break;
            }
            map.put(record.getBundleUri(), record);
        }
        reader.close();
    }

    public static void loadResultDetail(final File fileResultDetail,
            final List<BlancoNLpackGeneratorResultDetailCsvRecord> list)
            throws IOException, BlancoCsvIOException {
        final BlancoNLpackGeneratorResultDetailCsvReader reader = new BlancoNLpackGeneratorResultDetailCsvReader(
                new BufferedReader(new FileReader(fileResultDetail)));
        for (int index = 0;; index++) {
            if (BlancoNLpackGeneratorResultDetailUtil
                    .checkValidResultDetailRecordByFieldBundleUri(reader
                            .getReader()) == false) {
                // ̍s͓ǂݔ΂܂B
                reader.getReader().readLine();
                continue;
            }

            final BlancoNLpackGeneratorResultDetailCsvRecord record = reader
                    .readRecord();
            if (record == null) {
                break;
            }
            list.add(record);
        }
        reader.close();
    }

    public static void saveResultDetail(final File fileResultDetail,
            final List<BlancoNLpackGeneratorResultDetailCsvRecord> list)
            throws IOException, BlancoCsvIOException {
        final BlancoNLpackGeneratorResultDetailCsvWriter writer = new BlancoNLpackGeneratorResultDetailCsvWriter(
                new BufferedWriter(new FileWriter(fileResultDetail)));
        for (int index = 0; index < list.size(); index++) {
            final BlancoNLpackGeneratorResultDetailCsvRecord record = list
                    .get(index);
            writer.writeRecord(record);
        }
        writer.close();
    }
}
