package blanco.valueobject.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.valueobject.BlancoValueObjectConstants;
import blanco.valueobject.BlancoValueObjectMeta2Xml;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.resourcebundle.BlancoValueObjectResourceBundle;
import blanco.valueobject.task.valueobject.BlancoValueObjectBatchProcessInput;

public class BlancoValueObjectBatchProcess extends
        AbstractBlancoValueObjectBatchProcess {
    /**
     * blancoValueObject̃\[XohIuWFNgB
     */
    private final BlancoValueObjectResourceBundle fBundle = new BlancoValueObjectResourceBundle();

    public int process(final BlancoValueObjectBatchProcessInput input) {
        System.out.println("- " + BlancoValueObjectConstants.PRODUCT_NAME
                + " (" + BlancoValueObjectConstants.VERSION + ")");
        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(input.getMetadir()));
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoValueObjectConstants.TARGET_SUBDIRECTORY).mkdirs();

            new BlancoValueObjectMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoValueObjectConstants.TARGET_SUBDIRECTORY);

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoValueObjectConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final BlancoValueObjectXml2JavaClass xml2JavaClass = new BlancoValueObjectXml2JavaClass();
                xml2JavaClass.setNameAdjust(input.getNameAdjust());
                xml2JavaClass.process(fileMeta2[index], new File(input
                        .getTargetdir()));

                // P̎R[h̎@\ 0.9.1ȍ~ł͍폜܂B
            }

            // Ƀ^fBNgƂĎw肳ĂfBNg𑖍
            final File[] fileMeta3 = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta3.length; index++) {
                if (fileMeta3[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final BlancoValueObjectXml2JavaClass xml2JavaClass = new BlancoValueObjectXml2JavaClass();
                xml2JavaClass.setNameAdjust(input.getNameAdjust());
                xml2JavaClass.process(fileMeta3[index], new File(input
                        .getTargetdir()));

                // P̎R[h̎@\ 0.9.1ȍ~ł͍폜܂B
            }

            return END_SUCCESS;
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
    }
}
