/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.encryption;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;

import blanco.commons.util.BlancoStreamUtil;
import blanco.encryption.message.BlancoEncryptionMessage;

/**
 * gvDES (Triple DES) ASYɂt@CÍc[B
 * 
 * t@C̊gqɂAÍ^̔fȂ悤ɂȂĂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoEncryptionDesede {
    /**
     * pASYB
     */
    private static final String ALGORITHM = "DESede";

    /**
     * bZ[WB
     */
    private final BlancoEncryptionMessage fMsg = new BlancoEncryptionMessage();

    /**
     * ÍȂ܂B
     * 
     * Iɂ GZIPks܂B
     * 
     * @param argFileInput
     *            ̓t@CB
     * @param argFileOutput
     *            o̓t@C(Í)B
     * @param argPassword
     *            ÍpX[hB
     * @throws IOException
     *             o͗O ꍇB
     */
    public void encrypt(final File argFileInput, final File argFileOutput,
            final String argPassword) throws IOException {
        // TODO ̓p[^`FbN̎B
        // TODO t@C݃`FbNB

        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(argFileInput));
        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream(argFileOutput));

        encrypt(inStream, outStream, argPassword);

        // TODO mclose̎B
        inStream.close();
        outStream.flush();
        outStream.close();

        // ŌɃt@C̓tRs[܂B
        if (argFileOutput.setLastModified(argFileInput.lastModified()) == false) {
            throw new IllegalArgumentException(fMsg.getMbecde01());
        }
    }

    /**
     * ÍȂ܂B
     * 
     * Iɂ GZIPks܂B
     * 
     * @param argInput
     *            ̓Xg[B
     * @param argOutput
     *            o̓Xg[(Í)B̏o̓Xg[ \bhĂяoɃN[Y܂B
     * @param argPassword
     *            ÍpX[hB
     * @throws IOException
     *             o͗O ꍇB
     */
    public void encrypt(final InputStream argInput,
            final OutputStream argOutput, final String argPassword)
            throws IOException {
        // TODO ̓p[^`FbN̎B

        try {
            final Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(Cipher.ENCRYPT_MODE, BlancoEncryptionSecretKeyUtil
                    .getSha256KeyForDesede(argPassword));

            // o͂Í
            final OutputStream outStream = new GZIPOutputStream(
                    new CipherOutputStream(argOutput, cipher));

            BlancoStreamUtil.copy(argInput, outStream);

            // flush{Kv܂B
            outStream.flush();

            // ނA close{Ă܂B
            // closeȂƁA
            // <code>java.io.EOFException: Unexpected end of ZLIB input
            // stream</code>OĂ܂܂B_ł͉􂪌Ă܂B
            outStream.close();

        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde02(e.toString()));
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde03(e.toString()));
        } catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde04(e.toString()));
        }
    }

    /**
     * s܂B
     * 
     * Iɂ GZIPLs܂B
     * 
     * @param argFileInput
     *            ̓t@C(Í)B
     * @param argFileOutput
     *            o̓t@CB
     * @param argPassword
     *            ÍpX[hB
     * @throws IOException
     *             o͗O ꍇB
     */
    public void decrypt(final File argFileInput, final File argFileOutput,
            final String argPassword) throws IOException {
        // TODO ̓p[^`FbN̎B
        // TODO t@C݃`FbNB

        try {
            final InputStream inStream = new BufferedInputStream(
                    new FileInputStream(argFileInput));
            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream(argFileOutput));

            decrypt(inStream, outStream, argPassword);

            // TODO mclose̎B
            inStream.close();
            outStream.flush();
            outStream.close();

            // ŌɃt@C̓tRs[܂B
            if (argFileOutput.setLastModified(argFileInput.lastModified()) == false) {
                throw new IllegalArgumentException(fMsg.getMbecde05());
            }
        } catch (IOException e) {
            throw new IllegalArgumentException(fMsg.getMbecde06(e.toString()));
        }
    }

    /**
     * s܂B
     * 
     * Iɂ GZIPLs܂B
     * 
     * @param argInput
     *            ̓Xg[(Í)B
     * @param argOutput
     *            o̓Xg[B
     * @param argPassword
     *            ÍpX[hB
     * @throws IOException
     *             o͗O ꍇB
     */
    public void decrypt(final InputStream argInput,
            final OutputStream argOutput, final String argPassword)
            throws IOException {
        // TODO ̓p[^`FbN̎B

        try {
            final Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, BlancoEncryptionSecretKeyUtil
                    .getSha256KeyForDesede(argPassword));

            // ͂Í
            final InputStream inStream = new GZIPInputStream(
                    new CipherInputStream(argInput, cipher));

            BlancoStreamUtil.copy(inStream, argOutput);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde07(e.toString()));
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde08(e.toString()));
        } catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde09(e.toString()));
        }
    }
}
