package blanco.encryption.task;

import java.io.File;
import java.io.IOException;

import blanco.encryption.BlancoEncryptionConstants;
import blanco.encryption.BlancoEncryptionDesede;
import blanco.encryption.BlancoEncryptionDesede2;
import blanco.encryption.message.BlancoEncryptionMessage;
import blanco.encryption.task.valueobject.BlancoEncryptionDesedeBatchProcessInput;

/**
 * ob`NX
 * 
 * ob`̌ĂяoB <code>
 * java -classpath (NXpX) blanco.encryption.task.BlancoEncryptionDesedeBatchProcess -help
 * </code>
 */
public class BlancoEncryptionDesedeBatchProcess extends
        AbstractBlancoEncryptionDesedeBatchProcess {
    /**
     * bZ[WB
     */
    private final BlancoEncryptionMessage fMsg = new BlancoEncryptionMessage();

    /**
     * Í̃t@Cɕt^镶 Level1B
     */
    private static final String ENCRYPTED_FILE_EXT_LEVEL_1 = ".blancodesede";

    /**
     * Í̃t@Cɕt^镶 Level2B
     */
    private static final String ENCRYPTED_FILE_EXT_LEVEL_2 = ".blancodesede2";

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     * 
     * ̃\bhɎۂ̏eLq܂B
     * 
     * @param input
     *            ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION,
     *         END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int process(final BlancoEncryptionDesedeBatchProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoEncryptionConstants.PRODUCT_NAME + " ("
                + BlancoEncryptionConstants.VERSION + ")");

        // TODO t@C݃`FbNB
        final File fileInputDir = new File(input.getInputDir());
        if (fileInputDir.exists() == false) {
            System.out.println(fMsg.getMbecdea1(input.getInputDir()));
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        }

        final File fileOutputDir = new File(input.getOutputDir());
        if (fileOutputDir.exists() == false) {
            if (fileOutputDir.mkdirs() == false) {
                throw new IllegalArgumentException(fMsg.getMbecdea2(input
                        .getOutputDir()));
            }
        } else {
            if (fileOutputDir.isFile()) {
                throw new IllegalArgumentException(fMsg.getMbecdea3(input
                        .getOutputDir()));
            }
        }

        if (fileInputDir.getCanonicalPath().equals(
                fileOutputDir.getCanonicalPath())) {
            throw new IllegalArgumentException(fMsg.getMbecdea4(input
                    .getInputDir(), input.getOutputDir()));
        }

        final File[] files = fileInputDir.listFiles();

        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                // t@CȊO͏܂B
                continue;
            }

            // TODO ̃t@Cǂ߂邩ǂ`FbNKvB

            if (files[index].getName().endsWith(ENCRYPTED_FILE_EXT_LEVEL_1) == false
                    && files[index].getName().endsWith(
                            ENCRYPTED_FILE_EXT_LEVEL_2) == false) {
                // Í
                switch (input.getLevel()) {
                case 1: {
                    final File fileOutput = new File(fileOutputDir
                            .getAbsolutePath()
                            + "/"
                            + files[index].getName()
                            + ENCRYPTED_FILE_EXT_LEVEL_1);
                    System.out.println("blanco.encrypt["
                            + files[index].getAbsolutePath() + "] -> ["
                            + fileOutput.getName() + "]");
                    new BlancoEncryptionDesede().encrypt(files[index],
                            fileOutput, input.getPassword());
                }
                    break;
                case 2: {
                    final File fileOutput = new File(fileOutputDir
                            .getAbsolutePath()
                            + "/"
                            + files[index].getName()
                            + ENCRYPTED_FILE_EXT_LEVEL_2);
                    System.out.println("blanco.encrypt["
                            + files[index].getAbsolutePath() + "] -> ["
                            + fileOutput.getName() + "]");
                    new BlancoEncryptionDesede2().encrypt(files[index],
                            fileOutput, input.getPassword());
                }
                    break;
                }

            } else if (files[index].getName().endsWith(
                    ENCRYPTED_FILE_EXT_LEVEL_1)) {
                // 
                final File fileOutput = new File(fileOutputDir
                        .getAbsolutePath()
                        + "/"
                        + files[index].getName().substring(
                                0,
                                files[index].getName().length()
                                        - ENCRYPTED_FILE_EXT_LEVEL_1.length()));
                System.out.println("blanco.decrypt["
                        + files[index].getAbsolutePath() + "] -> ["
                        + fileOutput.getName() + "]");
                new BlancoEncryptionDesede().decrypt(files[index], fileOutput,
                        input.getPassword());
            } else if (files[index].getName().endsWith(
                    ENCRYPTED_FILE_EXT_LEVEL_2)) {
                // 
                System.out.println("blanco.decrypt["
                        + files[index].getAbsolutePath() + "] -> ["
                        + input.getOutputDir() + "]");
                // Level2̏ꍇɂ́AfBNgn܂B
                new BlancoEncryptionDesede2().decrypt(files[index], new File(
                        input.getOutputDir()), input.getPassword());
            } else {
                throw new IllegalArgumentException("P̃oO: ɓĂĂ͂Ȃ܂I");
            }
        }

        return END_SUCCESS;
    }
}
