/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoEncryptionDesede]̃NX
 */
package blanco.encryption.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.encryption.task.valueobject.BlancoEncryptionDesedeBatchProcessInput;

/**
 * Apache Ant^XN [BlancoEncryptionDesede]̃NXB
 *
 * gvDEŜ߂AntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.encryption.task]BlancoEncryptionDesedeBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoencryptiondesede&quot; classname=&quot;blanco.encryption.task.BlancoEncryptionDesedeTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoEncryptionDesedeTask extends Task {
    /**
     * gvDEŜ߂AntTaskłB
     */
    protected BlancoEncryptionDesedeBatchProcessInput fInput = new BlancoEncryptionDesedeBatchProcessInput();

    /**
     * gvDEŜ߂AntTaskłB
     */
    protected boolean fIsFieldInputDirProcessed = false;

    /**
     * gvDEŜ߂AntTaskłB
     */
    protected boolean fIsFieldOutputDirProcessed = false;

    /**
     * gvDEŜ߂AntTaskłB
     */
    protected boolean fIsFieldPasswordProcessed = false;

    /**
     * gvDEŜ߂AntTaskłB
     */
    protected boolean fIsFieldLevelProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[inputDir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ̓fBNgw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setInputDir(final String arg) {
        fInput.setInputDir(arg);
        fIsFieldInputDirProcessed = true;
    }

    /**
     * Ant^XN[inputDir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ̓fBNgw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getInputDir() {
        return fInput.getInputDir();
    }

    /**
     * Ant^XN[outputDir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o̓fBNgw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setOutputDir(final String arg) {
        fInput.setOutputDir(arg);
        fIsFieldOutputDirProcessed = true;
    }

    /**
     * Ant^XN[outputDir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o̓fBNgw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getOutputDir() {
        return fInput.getOutputDir();
    }

    /**
     * Ant^XN[password]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * pX[hw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setPassword(final String arg) {
        fInput.setPassword(arg);
        fIsFieldPasswordProcessed = true;
    }

    /**
     * Ant^XN[password]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * pX[hw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getPassword() {
        return fInput.getPassword();
    }

    /**
     * Ant^XN[level]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * Í̃xB<br>
     *
     * @param arg Zbgl
     */
    public void setLevel(final String arg) {
        try {
            fInput.setLevel(Integer.parseInt(arg));
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException("Ant^XN[level]Agr[gɗ^ꂽl̐l͂Ɏs܂B" + e.toString());
        }
        fIsFieldLevelProcessed = true;
    }

    /**
     * Ant^XN[level]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * Í̃xB<br>
     * ftHgl[1]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getLevel() {
        return String.valueOf(fInput.getLevel());
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoEncryptionDesedeTask begin.");

        // ڔԍ[1]AAgr[g[inputDir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldInputDirProcessed == false) {
            throw new BuildException("K{Agr[g[inputDir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[outputDir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldOutputDirProcessed == false) {
            throw new BuildException("K{Agr[g[outputDir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[3]AAgr[g[password]͕K{͂łB̓`FbNs܂B
        if (fIsFieldPasswordProcessed == false) {
            throw new BuildException("K{Agr[g[password]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- inputDir:[" + getInputDir() + "]");
            System.out.println("- outputDir:[" + getOutputDir() + "]");
            System.out.println("- password:[" + getPassword() + "]");
            System.out.println("- level:[" + getLevel() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            if (new BlancoEncryptionDesedeBatchProcess().execute(fInput) != BlancoEncryptionDesedeBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
