/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipsenls;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.eclipsenls.message.BlancoEclipseNlsMessage;
import blanco.eclipsenls.valueobject.BlancoEclipseNlsFieldStructure;
import blanco.eclipsenls.valueobject.BlancoEclipseNlsStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uEclipse NLS `vExcell𒊏o܂B
 * 
 * ̃NX́AXMLt@C񒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoEclipseNlsXmlParser {
    /**
     * bZ[W`B
     */
    protected final BlancoEclipseNlsMessage fMsg = new BlancoEclipseNlsMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoEclipseNlsStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoEclipseNlsStructure[] parse(
            final BlancoXmlDocument argXmlDocument) {
        final List<BlancoEclipseNlsStructure> listStructure = new ArrayList<BlancoEclipseNlsStructure>();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List<BlancoXmlElement> listSheet = BlancoXmlBindingUtil
                .getElementsByTagName(elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final BlancoEclipseNlsStructure structure = parseElementSheet(elementSheet);
            if (structure != null) {
                // ꂽL܂B
                listStructure.add(structure);
            }
        }

        final BlancoEclipseNlsStructure[] result = new BlancoEclipseNlsStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoEclipseNlsStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoEclipseNlsStructure structure = new BlancoEclipseNlsStructure();
        // ̓p[^擾܂B

        final List<BlancoXmlElement> listCommon = BlancoXmlBindingUtil
                .getElementsByTagName(argElementSheet,
                        "blancoeclipsenls-common");
        if (listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        // ŏ̃ACêݏĂ܂B
        final BlancoXmlElement elementCommon = listCommon.get(0);

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "name"));
        structure.setPackage(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "package"));

        if (BlancoStringUtil.null2Blank(structure.getName()).length() == 0) {
            return null;
        }

        if (BlancoStringUtil.null2Blank(structure.getPackage()).trim().length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbenli01(structure
                    .getName()));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "description") != null) {
            structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "baseName") != null) {
            structure.setBaseName(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "baseName"));
        }

        final BlancoXmlElement elementMessageList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancoeclipsenls-list");
        if (elementMessageList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List<BlancoXmlElement> listField = BlancoXmlBindingUtil
                .getElementsByTagName(elementMessageList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final BlancoXmlElement elementField = listField.get(indexField);

            final BlancoEclipseNlsFieldStructure fieldStructure = new BlancoEclipseNlsFieldStructure();

            fieldStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "no"));
            fieldStructure.setName(BlancoXmlBindingUtil.getTextContent(
                    elementField, "key"));
            if (BlancoStringUtil.null2Blank(fieldStructure.getName()).length() == 0) {
                // keyw肳ĂȂꍇɂ͏܂B
                continue;
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(elementField, "value"))
                    .length() > 0) {
                fieldStructure.setMessage(BlancoXmlBindingUtil.getTextContent(
                        elementField, "value"));
            }

            if (BlancoStringUtil.null2Blank(fieldStructure.getMessage())
                    .length() == 0) {
                // ŌxB
                continue;
            }

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < structure.getFieldList().size(); indexPast++) {
                final BlancoEclipseNlsFieldStructure fieldPast = (BlancoEclipseNlsFieldStructure) structure
                        .getFieldList().get(indexPast);
                if (fieldPast.getName().equals(fieldStructure.getName())) {
                    throw new IllegalArgumentException(fMsg.getMbenli02(
                            structure.getName(), fieldStructure.getName()));
                }
            }

            structure.getFieldList().add(fieldStructure);
        }

        return structure;
    }
}
