/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * blancoEclipseNls ̂߂̕ϊ`܂B
 */
package blanco.eclipsenls;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.commons.calc.parser.BlancoCalcParser;

/**
 * blancoEclipseNls ̂߂̕ϊ`܂B
 */
public class BlancoEclipseNlsMeta2Xml {
    /**
     * `^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB
     */
    protected boolean fCacheMeta2Xml = false;

    /**
     * `^t@C璆XMLt@Cւ̕ϊLbVōς܂񐔁B
     */
    protected int fCacheMeta2XmlCount = 0;

    /**
     * NX[_̒`\XMLt@C̓Ǎ񐔂炷߂̃LbVB
     */
    protected byte[] fCacheMetaDefXml = null;

    /**
     * `^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOw肵܂B
     *
     * @param argCacheMeta2Xml `^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂB
     */
    public void setCacheMeta2Xml(final boolean argCacheMeta2Xml) {
        fCacheMeta2Xml = argCacheMeta2Xml;
    }

    /**
     * Excelt@C̃Xg[XMLt@C̃Xg[ɕϊ܂B
     *
     * `t@C͓IɃpXێĂ܂B
     *
     * @param inStreamMetaSource ^t@C̓̓Xg[B
     * @param outStreamTarget XMLt@C̏o̓Xg[B
     * @throws IOException o͗OꍇB
     * @throws TransformerException XMLϊOꍇB
     */
    public void process(final InputStream inStreamMetaSource, final OutputStream outStreamTarget) throws IOException, TransformerException {
        if (inStreamMetaSource == null) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: inStreamMetaSource is null.");
        }
        if (outStreamTarget == null) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: outStreamTarget is null.");
        }

        if (fCacheMetaDefXml == null) {
            // ̃NXgƂȂNX[_XMLݒt@C̃[hȂ܂B
            final InputStream meta2xmlStream = getClass().getClassLoader().getResourceAsStream("blanco/eclipsenls/BlancoEclipseNlsMeta2Xml.xml");
            if (meta2xmlStream == null) {
                throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: \[X[blanco/eclipsenls/BlancoEclipseNlsMeta2Xml.xml]̎擾Ɏs܂.");
            }
            final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            final byte[] bufWrk = new byte[8192];
            for (;;) {
                final int readLength = meta2xmlStream.read(bufWrk);
                if (readLength <= 0) {
                    break;
                }
                outStream.write(bufWrk, 0, readLength);
            }
            outStream.flush();
            meta2xmlStream.close();
            fCacheMetaDefXml = outStream.toByteArray();
        }

        InputStream inStreamDef = new ByteArrayInputStream(fCacheMetaDefXml);
        try {
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource, outStreamTarget);
        } finally {
            if (inStreamDef != null) {
                inStreamDef.close();
            }
        }
    }

    /**
     * Excelt@CXMLt@Cɕϊ܂B
     *
     * @param fileMeta ^t@C̓̓t@CB
     * @param fileOutput XMLt@C̏óB
     * @throws IOException o͗OꍇB
     * @throws TransformerException XMLϊOꍇB
     */
    public void process(final File fileMeta, final File fileOutput) throws IOException, TransformerException {
        if (fileMeta == null) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: fileMeta is null.");
        }
        if (fileOutput == null) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: fileOutput is null.");
        }
        if (fileMeta.exists() == false) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: file file [" + fileMeta.getAbsolutePath() + "] not found.");
        }

        if (fCacheMeta2Xml && fileMeta.lastModified() < fileOutput.lastModified()) {
            // LbV𗘗pāAXLbv܂B
            fCacheMeta2XmlCount++;
            return;
        }

        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(fileMeta), 8192);
            outStream = new BufferedOutputStream(new FileOutputStream(fileOutput), 8192);

            // Xg[̏ł̂ŁAۂ̏Ȃ܂B
            process(inStream, outStream);

            outStream.flush();
        } finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    /**
     * wfBNgExcelt@CXMLt@Cɕϊ܂B
     *
     * w肳ꂽtH_̊gq[.xls]̃t@C܂B<br>
     * f[^ Ƃ̃t@CɊgq[.xml]t^t@C֕ۑ܂B
     *
     * @param fileMetadir ^t@Ci[Ă̓fBNgB
     * @param targetDirectory o̓fBNgB
     * @throws IOException o͗OꍇB
     * @throws TransformerException XMLϊOꍇB
     */
    public void processDirectory(final File fileMetadir, final String targetDirectory) throws IOException, TransformerException {
        System.out.println("m2x: begin.");
        final long startMills = System.currentTimeMillis();
        long totalFileCount = 0;
        long totalFileBytes = 0;

        if (fileMetadir == null) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: fileMetadir is null.");
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: targetDirectory is null.");
        }
        if (fileMetadir.exists() == false) {
            throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Invalid argument: file [" + fileMetadir.getAbsolutePath() + "] not found.");
        }
        final File fileTargetDirectory = new File(targetDirectory);
        if (fileTargetDirectory.exists() == false) {
            // o͐fBNg݂Ȃ̂ŁAOɍ쐬܂B
            fileTargetDirectory.mkdirs();
        }

        // w肳ꂽfBNg̃t@Cꗗ擾܂B
        final File[] fileMeta = fileMetadir.listFiles();
        if (fileMeta == null) {
            throw new IllegalArgumentException("BlancoMeta2XmlProcessMeta2Xml: list directory [" + fileMetadir.getAbsolutePath() + "] is failed.");
        }
        for (int index = 0; index < fileMeta.length; index++) {
            if (fileMeta[index].getName().endsWith(".xls") == false) {
                // t@C̊gqׂ̂Ƃ͈قȂ邽ߏXLbv܂BB
                continue;
            }

            if (progress(index + 1, fileMeta.length, fileMeta[index].getName()) == false) {
                // i\珈f̎ŵŁAf܂B
                break;
            }

            try {
                totalFileCount++;
                totalFileBytes += fileMeta[index].length();
                process(fileMeta[index], new File(targetDirectory + "/" + fileMeta[index].getName() + ".xml"));
            } catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalArgumentException("BlancoEclipseNlsMeta2Xml: Exception occurs during processing the file [" + fileMeta[index].getAbsolutePath() + "]. " + ex.toString());
            }
        }

        if (fCacheMeta2Xml) {
            System.out.println("m2x: cache: " + fCacheMeta2XmlCount + " file skipped.");
        }
        final long costMills = System.currentTimeMillis() - startMills + 1;
        System.out.println("m2x: end: " + (costMills / 1000) + " sec, " + totalFileCount + " file, " + totalFileBytes + " byte (" + (totalFileBytes * 1000 / costMills) + " byte/sec).");
    }

    /**
     * ̐i܂B
     *
     * i\ꍇɂ͌pď肱݂܂B
     *
     * @param progressCurrent ݏĂ錏̔ԍB
     * @param progressTotal B
     * @param progressItem ĂACeB
     * @return 𑱍sĂ悢ǂBfalseȂ珈fB
     */
    protected boolean progress(final int progressCurrent, final int progressTotal, final String progressItem) {
        // ɏs true ߂܂B
        return true;
    }
}
