/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipsenls;

import java.io.File;
import java.io.IOException;

import blanco.eclipsenls.valueobject.BlancoEclipseNlsFieldStructure;
import blanco.eclipsenls.valueobject.BlancoEclipseNlsStructure;
import blanco.resourcebundle.BlancoResourceBundleXml2Properties;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleResourceStringStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;

/**
 * uEclipse NLS `vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoEclipseNlsXml2PropertiesFile {
    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget) throws IOException {
        final BlancoEclipseNlsStructure[] structures = new BlancoEclipseNlsXmlParser()
                .parse(argMetaXmlSourceFile);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Properties(structures[index], argDirectoryTarget);
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param argStructure
     *            ^XN̍\B
     * @param argDirectoryTarget
     *            o͐fBNg
     */
    public void structure2Properties(
            final BlancoEclipseNlsStructure argStructure,
            final File argDirectoryTarget) {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        final BlancoResourceBundleBundleStructure structure = new BlancoResourceBundleBundleStructure();
        structure.setName(argStructure.getBaseName());
        structure.setPackage(argStructure.getPackage());

        for (int indexField = 0; indexField < argStructure.getFieldList()
                .size(); indexField++) {
            final BlancoEclipseNlsFieldStructure fieldLook = argStructure
                    .getFieldList().get(indexField);

            final BlancoResourceBundleBundleItemStructure item = new BlancoResourceBundleBundleItemStructure();
            structure.getItemList().add(item);
            item.setNo(fieldLook.getNo());
            item.setKey(fieldLook.getName());
            final BlancoResourceBundleBundleResourceStringStructure resourceStringStructure = new BlancoResourceBundleBundleResourceStringStructure();
            item.getResourceStringList().add(resourceStringStructure);
            resourceStringStructure.setResourceString(fieldLook.getMessage());
        }

        final BlancoResourceBundleXml2Properties xml2Properties = new BlancoResourceBundleXml2Properties();
        xml2Properties.setCommentTimestamp(false);
        xml2Properties.structure2Properties(structure, null, fileBlancoMain);
    }
}
