/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data.stat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.List;
import java.util.TreeMap;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.matching.Tokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    public static void buildProjectStats(List<StringEntry> list, List<SourceTextEntry> list2, ProjectProperties projectProperties, int n) {
        Object object;
        Object object2;
        Object object3;
        String string;
        int n2;
        int n3 = 0;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        int n7 = 4;
        int n8 = 5;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        for (StringEntry stringEntry : list) {
            String string2 = stringEntry.getSrcText();
            n2 = stringEntry.getParentList().size();
            int n19 = Statistics.numberOfWords(string2);
            n10 += n19;
            n9 += n19 * n2;
            string = StaticUtils.stripTags(string2);
            int n20 = Statistics.numberOfCharactersWithoutSpaces(string);
            n12 += n20;
            n11 += n20 * n2;
            int n21 = string.length();
            n14 += n21;
            n13 += n21 * n2;
            if (stringEntry.isTranslated()) continue;
            n15 += n19;
            n16 += n20;
            n17 += n21;
            n18 += n2;
        }
        int n22 = list.size() - n;
        int n23 = 0;
        int n24 = 0;
        n2 = 0;
        TreeMap<String, int[]> treeMap = new TreeMap<String, int[]>();
        for (SourceTextEntry sourceTextEntry : list2) {
            object3 = sourceTextEntry.getSrcFile().name;
            object2 = treeMap.containsKey(object3 = StaticUtils.makeFilenameRelative((String)object3, projectProperties.getSourceRoot())) ? (int[])treeMap.get(object3) : new int[]{0, 0, 0, 0, 0, 0};
            object = sourceTextEntry.getSrcText();
            string = StaticUtils.stripTags((String)object);
            int n25 = Statistics.numberOfWords((String)object);
            int n26 = n3;
            object2[n26] = object2[n26] + n25;
            int n27 = Statistics.numberOfCharactersWithoutSpaces(string);
            int n28 = n5;
            object2[n28] = object2[n28] + n27;
            int n29 = string.length();
            int n30 = n7;
            object2[n30] = object2[n30] + n29;
            if (!sourceTextEntry.isTranslated()) {
                n23 += n25;
                int n31 = n4;
                object2[n31] = object2[n31] + n25;
                n24 += n27;
                int n32 = n6;
                object2[n32] = object2[n32] + n27;
                n2 += n29;
                int n33 = n8;
                object2[n33] = object2[n33] + n29;
            }
            treeMap.put((String)object3, (int[])object2);
        }
        try {
            Object object4;
            try {
                object4 = new File(projectProperties.getProjectInternal() + "word_counts");
                if (((File)object4).exists()) {
                    ((File)object4).delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object4 = projectProperties.getProjectInternal() + "project_stats.txt";
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((String)object4), "UTF-8");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Project_Statistics") + "\n\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Total") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + list2.size() + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n9 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n11 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n13 + "\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Remaining") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + n18 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n23 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n24 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n2 + "\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Unique") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + list.size() + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n10 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n12 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n14 + "\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Unique_Remaining") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + n22 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n15 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n16 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n17 + "\n");
            outputStreamWriter.write("\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_FILE_Statistics") + "\n\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_FILE_Name") + "\t" + OStrings.getString("CT_STATS_FILE_Total_Words") + "\t" + OStrings.getString("CT_STATS_FILE_Remaining_Words") + "\t" + OStrings.getString("CT_STATS_FILE_Total_Characters_NOSP") + "\t" + OStrings.getString("CT_STATS_FILE_Remaining_Characters_NOSP") + "\t" + OStrings.getString("CT_STATS_FILE_Total_Characters") + "\t" + OStrings.getString("CT_STATS_FILE_Remaining_Characters") + "\n");
            object3 = treeMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (int[])treeMap.get(object2);
                outputStreamWriter.write((String)object2 + "\t" + (int)object[n3] + "\t" + (int)object[n4] + "\t" + (int)object[n5] + "\t" + (int)object[n6] + "\t" + (int)object[n7] + "\t" + (int)object[n8] + "\n");
            }
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int numberOfCharactersWithoutSpaces(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            ++n;
        }
        return n;
    }

    private static int numberOfWords(String string) {
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        BreakIterator breakIterator = Tokenizer.getWordBreaker();
        breakIterator.setText(string);
        String string2 = new String();
        int n3 = breakIterator.first();
        int n4 = breakIterator.next();
        while (n4 != -1) {
            string2 = string.substring(n3, n4);
            boolean bl = false;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (!Character.isLetterOrDigit(c)) continue;
                bl = true;
                break;
            }
            if (bl && !PatternConsts.OMEGAT_TAG.matcher(string2).matches()) {
                ++n2;
            }
            n3 = n4;
            n4 = breakIterator.next();
        }
        return n2;
    }
}

