/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Rule
implements Serializable {
    private boolean breakRule;
    private Pattern beforebreak;
    private Pattern afterbreak;

    public Rule() {
    }

    public Rule(boolean bl, String string, String string2) {
        this.setBreakRule(bl);
        this.setBeforebreak(string);
        this.setAfterbreak(string2);
    }

    public boolean isBreakRule() {
        return this.breakRule;
    }

    public void setBreakRule(boolean bl) {
        this.breakRule = bl;
    }

    public String getBeforebreak() {
        if (this.beforebreak != null) {
            return this.beforebreak.pattern();
        }
        return null;
    }

    public Pattern getCompiledBeforebreak() {
        return this.beforebreak;
    }

    public void setBeforebreak(String string) throws PatternSyntaxException {
        this.beforebreak = this.compilePattern(string);
    }

    public String getAfterbreak() {
        if (this.afterbreak != null) {
            return this.afterbreak.pattern();
        }
        return null;
    }

    public Pattern getCompiledAfterbreak() {
        return this.afterbreak;
    }

    public void setAfterbreak(String string) throws PatternSyntaxException {
        this.afterbreak = this.compilePattern(string);
    }

    private Pattern compilePattern(String string) {
        Pattern pattern = Pattern.compile(string);
        if ((pattern.flags() & 2) == 2) {
            return Pattern.compile(string, 96);
        }
        return Pattern.compile(string, 32);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Rule rule = (Rule)object;
        return this.breakRule == rule.breakRule && this.getBeforebreak().equals(rule.getBeforebreak()) && this.getAfterbreak().equals(rule.getAfterbreak());
    }

    public int hashCode() {
        return (this.isBreakRule() ? 1 : -1) + this.getBeforebreak().hashCode() - this.getAfterbreak().hashCode();
    }

    public String toString() {
        return (this.isBreakRule() ? "Break " : "Exception ") + "Before: " + this.getBeforebreak() + "After: " + this.getAfterbreak();
    }
}

