/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.bundles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.OStrings;

public class ResourceBundleFilter
extends AbstractFilter {
    public String getFileFormatName() {
        return OStrings.getString("RBFILTER_FILTER_NAME");
    }

    public boolean isSourceEncodingVariable() {
        return false;
    }

    public boolean isTargetEncodingVariable() {
        return false;
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.properties", null, null, "${nameOnly}_${targetLocale}.${extension}")};
    }

    public BufferedReader createReader(File file, String string) throws UnsupportedEncodingException, IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
    }

    public BufferedWriter createWriter(File file, String string) throws UnsupportedEncodingException, IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1"));
    }

    protected String getNextLine(LinebreakPreservingReader linebreakPreservingReader) throws IOException {
        String string = linebreakPreservingReader.readLine();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n == 92 && i != string.length() - 1) {
                if ((n = string.charAt(++i)) != 117) {
                    if (n == 110) {
                        n = 10;
                    } else if (n == 114) {
                        n = 13;
                    } else if (n == 116) {
                        n = 9;
                    } else {
                        stringBuffer.append('\\');
                    }
                } else if (string.length() >= i + 1 + 4) {
                    n = (char)Integer.parseInt(string.substring(i + 1, i + 1 + 4), 16);
                    i += 4;
                } else {
                    throw new IOException(OStrings.getString("RBFH_ERROR_ILLEGAL_U_SEQUENCE"));
                }
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private String toAscii(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (bl && c == ' ') {
                stringBuffer.append("\\ ");
                continue;
            }
            if (bl && c == '=') {
                stringBuffer.append("\\=");
                continue;
            }
            if (bl && c == ':') {
                stringBuffer.append("\\:");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            String string2 = Integer.toString(c, 16);
            while (string2.length() < 4) {
                string2 = '0' + string2;
            }
            stringBuffer.append("\\u" + string2);
        }
        return stringBuffer.toString();
    }

    private String removeExtraSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n == 92) {
                n = i + 1 < string.length() ? (int)string.charAt(++i) : 32;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private String leftTrim(String string) {
        int n;
        for (n = 0; n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t'); ++n) {
        }
        string = string.replaceAll("\\\\ ", " ");
        return string.substring(n, string.length());
    }

    public void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException {
        String string;
        LinebreakPreservingReader linebreakPreservingReader = new LinebreakPreservingReader(bufferedReader);
        boolean bl = false;
        while ((string = this.getNextLine(linebreakPreservingReader)) != null) {
            String string2 = string.trim();
            if (string2.length() == 0) {
                bufferedWriter.write(this.toAscii(string, false) + linebreakPreservingReader.getLinebreak());
                continue;
            }
            char c = string2.charAt(0);
            if (c == '#' || c == '!') {
                bufferedWriter.write(this.toAscii(string, false) + linebreakPreservingReader.getLinebreak());
                if (string2.indexOf("NOI18N") < 0) continue;
                bl = true;
                continue;
            }
            while (string.charAt(string.length() - 1) == '\\') {
                String string3 = this.getNextLine(linebreakPreservingReader);
                if (string3 == null) {
                    string3 = "";
                }
                string = string.substring(0, string.length() - 1) + this.leftTrim(string3);
            }
            int n = this.searchEquals(string);
            String string4 = n >= 0 ? string.substring(0, n).trim() : string.trim();
            string4 = this.removeExtraSlashes(string4);
            bufferedWriter.write(this.toAscii(string4, true));
            if (n >= 0) {
                char c2;
                int n2;
                for (n2 = n + 1; n2 < string.length() && ((c2 = string.charAt(n2)) == ' ' || c2 == '\t'); ++n2) {
                }
                String string5 = string.substring(n, n2);
                bufferedWriter.write(string5);
                String string6 = n2 < string.length() ? this.removeExtraSlashes(string.substring(n2)) : "";
                if (bl) {
                    bufferedWriter.write(this.toAscii(string6, false));
                    bl = false;
                } else {
                    string6 = string6.replaceAll("\\n\\n", "\n \n");
                    String string7 = this.processEntry(string6);
                    string7 = string7.replaceAll("\\n\\s\\n", "\n\n");
                    if ((string7 = this.toAscii(string7, false)).length() > 0 && string7.charAt(0) == ' ') {
                        string7 = '\\' + string7;
                    }
                    bufferedWriter.write(string7);
                }
            }
            bufferedWriter.write(linebreakPreservingReader.getLinebreak());
        }
    }

    private int searchEquals(String string) {
        int n = 97;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n != 92) {
                if (c == '=' || c == ':') {
                    return i;
                }
                if (c == ' ' || c == '\t') {
                    for (int j = i + 1; j < string.length(); ++j) {
                        char c2 = string.charAt(j);
                        if (c2 == ':' || c2 == '=') {
                            return j;
                        }
                        if (c2 == ' ' || c2 == '\t') continue;
                        return i;
                    }
                    return i;
                }
            }
            n = c;
        }
        return -1;
    }
}

