/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class HelpFrame
extends JFrame {
    private static HelpFrame singleton;
    private JEditorPane m_helpPane;
    private JButton m_closeButton;
    private JButton m_homeButton;
    private JButton m_backButton;
    private List<String> m_historyList = new ArrayList<String>();
    private String m_filename_nosharp;
    private String m_filename = "";
    private String m_language;

    private HelpFrame() {
        this.initWindowLayout();
        Container container = this.getContentPane();
        this.m_helpPane = new JEditorPane();
        this.m_helpPane.setEditable(false);
        this.m_helpPane.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(this.m_helpPane);
        container.add((Component)jScrollPane, "Center");
        this.m_homeButton = new JButton();
        this.m_homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.m_historyList.add(HelpFrame.this.m_filename);
                HelpFrame.this.displayHome();
                HelpFrame.this.m_backButton.setEnabled(true);
            }
        });
        this.m_backButton = new JButton();
        this.m_backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HelpFrame.this.m_historyList.size() > 0) {
                    String string = (String)HelpFrame.this.m_historyList.remove(HelpFrame.this.m_historyList.size() - 1);
                    HelpFrame.this.displayFile(string);
                }
                if (HelpFrame.this.m_historyList.isEmpty()) {
                    HelpFrame.this.m_backButton.setEnabled(false);
                }
            }
        });
        this.m_backButton.setEnabled(false);
        this.m_closeButton = new JButton();
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.dispose();
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(this.m_backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.m_homeButton);
        box.add(Box.createHorizontalGlue());
        box.add(this.m_closeButton);
        container.add((Component)box, "North");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFrame.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.m_helpPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpFrame.this.m_historyList.add(HelpFrame.this.m_filename);
                    HelpFrame.this.displayFile(hyperlinkEvent.getDescription());
                    HelpFrame.this.m_backButton.setEnabled(true);
                }
            }
        });
        this.updateUIText();
        this.displayHome();
    }

    public static HelpFrame getInstance() {
        if (singleton == null) {
            singleton = new HelpFrame();
        }
        return singleton;
    }

    public void displayHome() {
        if (this.m_language == null) {
            this.m_language = HelpFrame.detectDocLanguage();
            if (this.m_language == null) {
                this.displayLanguageIndex();
                return;
            }
        }
        this.displayFile("index.html");
    }

    public void displayLanguageIndex() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            object2 = new BufferedReader(new FileReader(StaticUtils.installDir() + File.separator + "docs" + File.separator + "languageIndex.html"));
            object = ((BufferedReader)object2).readLine();
            while (object != null) {
                stringBuffer.append((String)object);
                stringBuffer.append('\n');
                object = ((BufferedReader)object2).readLine();
            }
        }
        catch (IOException iOException) {
            Log.log(iOException);
            return;
        }
        object2 = new StringBuffer(1024);
        ((StringBuffer)object2).append("<table>\n");
        object = new File(StaticUtils.installDir() + File.separator + "docs");
        Object[] objectArray = ((File)object).listFiles();
        Arrays.sort(objectArray);
        for (Object object3 : objectArray) {
            if (!((File)object3).isDirectory()) continue;
            String string = ((File)object3).getName();
            String string2 = this.getLocaleName(string);
            String string3 = HelpFrame.getDocVersion(string);
            if (string3 == null) continue;
            ((StringBuffer)object2).append("<tr><td><a href=\"omegat:select-lang?lang=");
            ((StringBuffer)object2).append(string);
            ((StringBuffer)object2).append("\">");
            ((StringBuffer)object2).append(string2);
            ((StringBuffer)object2).append("</a></td><td>(");
            if (string3.equals(OStrings.VERSION)) {
                ((StringBuffer)object2).append("<font color=\"green\"><strong>");
            } else {
                ((StringBuffer)object2).append("<font color=\"red\">");
            }
            ((StringBuffer)object2).append(string3);
            if (string3.equals(OStrings.VERSION)) {
                ((StringBuffer)object2).append("</strong>");
            }
            ((StringBuffer)object2).append("</font>)</td></tr>\n");
        }
        ((StringBuffer)object2).append("</table>");
        String string = stringBuffer.toString().replaceFirst("\\$INDEX", ((StringBuffer)object2).toString());
        this.m_helpPane.setContentType("text/plain");
        this.m_helpPane.setContentType("text/html");
        this.m_helpPane.setText(string);
        this.m_filename = "omegat:lang-index";
    }

    private void displayFile(String string) {
        this.m_helpPane.setContentType("text/plain");
        this.m_helpPane.setContentType("text/html");
        if (string.startsWith("http://")) {
            String string2 = "<b>" + string + "</b>";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><p>");
            stringBuffer.append(StaticUtils.format(OStrings.getString("HF_ERROR_EXTLINK_TITLE"), string2));
            stringBuffer.append("<p>");
            stringBuffer.append(StaticUtils.format(OStrings.getString("HF_ERROR_EXTLINK_MSG"), "<b>" + StaticUtils.installDir() + File.separator + "docs" + File.separator + "index.html</b>"));
            stringBuffer.append("</body></html>");
            this.m_helpPane.setText(stringBuffer.toString());
        } else if (string.startsWith("omegat:")) {
            this.handleCommand(string);
        } else {
            if (string.startsWith("#")) {
                string = this.m_filename_nosharp + string;
            }
            String string3 = this.absolutePath(string);
            int n = string.indexOf(35);
            if (n < 0) {
                n = string.length();
            }
            this.m_filename_nosharp = string.substring(0, n);
            try {
                URL uRL = new URL(string3);
                this.m_helpPane.setPage(uRL);
                this.m_filename = string;
            }
            catch (IOException iOException) {
                String string4 = this.errorHaiku() + "<p>&nbsp;<p>" + OStrings.getString("HF_CANT_FIND_HELP") + string3;
                this.m_helpPane.setText(string4);
            }
        }
    }

    private void handleCommand(String string) {
        if (!string.startsWith("omegat:")) {
            throw new IllegalArgumentException("Command must start with 'omegat:'");
        }
        if ((string = string.substring(7, string.length())).startsWith("select-lang")) {
            int n = string.indexOf("lang=");
            this.m_language = string.substring(n + 5, string.length());
            this.displayHome();
        } else if (string.startsWith("lang-index")) {
            this.displayLanguageIndex();
        } else {
            throw new IllegalArgumentException("Unrecognized command");
        }
    }

    private String errorHaiku() {
        String string;
        switch ((int)(Math.random() * 11.0)) {
            case 0: {
                string = OStrings.getString("HF_HAIKU_1");
                break;
            }
            case 1: {
                string = OStrings.getString("HF_HAIKU_2");
                break;
            }
            case 2: {
                string = OStrings.getString("HF_HAIKU_3");
                break;
            }
            case 3: {
                string = OStrings.getString("HF_HAIKU_4");
                break;
            }
            case 4: {
                string = OStrings.getString("HF_HAIKU_5");
                break;
            }
            case 5: {
                string = OStrings.getString("HF_HAIKU_6");
                break;
            }
            case 6: {
                string = OStrings.getString("HF_HAIKU_7");
                break;
            }
            case 7: {
                string = OStrings.getString("HF_HAIKU_8");
                break;
            }
            case 8: {
                string = OStrings.getString("HF_HAIKU_9");
                break;
            }
            case 9: {
                string = OStrings.getString("HF_HAIKU_10");
                break;
            }
            default: {
                string = OStrings.getString("HF_HAIKU_11");
            }
        }
        return string;
    }

    private void updateUIText() {
        Mnemonics.setLocalizedText((AbstractButton)this.m_closeButton, (String)OStrings.getString("BUTTON_CLOSE"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_homeButton, (String)OStrings.getString("BUTTON_HOME"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_backButton, (String)OStrings.getString("BUTTON_BACK"));
        this.setTitle(OStrings.getString("HF_WINDOW_TITLE"));
    }

    private String absolutePath(String string) {
        try {
            return "file:" + new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + this.m_language + File.separator + string).getCanonicalPath();
        }
        catch (IOException iOException) {
            Log.log(iOException);
            return null;
        }
    }

    private static String detectDocLanguage() {
        String string = Locale.getDefault().getLanguage().toLowerCase();
        String string2 = Locale.getDefault().getCountry().toUpperCase();
        String string3 = string + "_" + string2;
        String string4 = HelpFrame.getDocVersion(string3);
        if (string4 != null && string4.equals(OStrings.VERSION)) {
            return string3;
        }
        string3 = string;
        string4 = HelpFrame.getDocVersion(string3);
        if (string4 != null && string4.equals(OStrings.VERSION)) {
            return string3;
        }
        return null;
    }

    private static String getDocVersion(String string) {
        File file = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + string + File.separator + "index.html");
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + string + File.separator + "version.properties");
        if (!file2.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file2));
        }
        catch (IOException iOException) {
            Log.log(iOException);
            return null;
        }
        return properties.getProperty("version");
    }

    private String getLocaleName(String string) {
        String string2 = string.substring(0, 2);
        String string3 = string.length() >= 5 ? string.substring(3, 5) : "";
        Locale locale = new Locale(string2, string3);
        if (string2.equalsIgnoreCase("sh")) {
            return "srpskohrvatski";
        }
        return locale.getDisplayName(locale);
    }

    private void initWindowLayout() {
        try {
            String string = Preferences.getPreference("help_window_x");
            String string2 = Preferences.getPreference("help_window_y");
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            this.setLocation(n, n2);
            String string3 = Preferences.getPreference("help_window_width");
            String string4 = Preferences.getPreference("help_window_height");
            int n3 = Integer.parseInt(string3);
            int n4 = Integer.parseInt(string4);
            this.setSize(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.setSize(600, 500);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("help_window_width", this.getWidth());
        Preferences.setPreference("help_window_height", this.getHeight());
        Preferences.setPreference("help_window_x", this.getX());
        Preferences.setPreference("help_window_y", this.getY());
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201 || n == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(windowEvent);
    }
}

