/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.omegat.util.StaticUtils;

public class MainWindowMenuShortcuts {
    public static void setShortcuts(JMenuBar jMenuBar) {
        Properties properties = MainWindowMenuShortcuts.loadPredefinedShortcuts();
        MainWindowMenuShortcuts.setup(jMenuBar.getComponents(), properties);
    }

    private static void setup(Component[] componentArray, Properties properties) {
        for (Component component : componentArray) {
            if (component instanceof JMenu) {
                MainWindowMenuShortcuts.setup(((JMenu)component).getMenuComponents(), properties);
            }
            if (!(component instanceof JMenuItem)) continue;
            String string = ((JMenuItem)component).getActionCommand();
            MainWindowMenuShortcuts.setAccelerator((JMenuItem)component, properties.getProperty(string));
        }
    }

    private static void setAccelerator(JMenuItem jMenuItem, String string) {
        if (string == null) {
            return;
        }
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadPredefinedShortcuts() {
        Properties properties;
        block9: {
            properties = new Properties();
            String string = MainWindowMenuShortcuts.class.getPackage().getName().replace('.', '/') + "/MainMenuShortcuts";
            string = string + (StaticUtils.onMacOSX() ? ".mac.properties" : ".properties");
            File file = new File(StaticUtils.getConfigDir(), "MainMenuShortcuts.properties");
            try {
                InputStream inputStream = MainWindowMenuShortcuts.class.getClassLoader().getResourceAsStream(string);
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
                if (!file.exists()) break block9;
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    properties.load(fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {
                throw new ExceptionInInitializerError();
            }
        }
        return properties;
    }
}

